/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.views.contentoutline;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.wst.javascript.ui.internal.common.ContentElement;
import org.eclipse.wst.javascript.ui.internal.common.ContentElementComparerImpl;
import org.eclipse.wst.javascript.ui.internal.common.JSContentElementImpl;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPluginImageHelper;
import org.eclipse.wst.javascript.ui.internal.editor.JavaScriptUIMessages;
import org.eclipse.wst.javascript.ui.internal.editor.Logger;
import org.eclipse.wst.javascript.ui.internal.views.contentoutline.JSLabelProvider;
import org.eclipse.wst.javascript.ui.internal.views.contentoutline.JSTreeContentProvider;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.edit.util.SharedEditorPluginImageHelper;

public class JSContentOutlinePage
extends ContentOutlinePage
implements IDocumentListener {
    private static final String OUTLINE_LINK_PREF = "outline-link-editor";
    private static final String OUTLINE_SHOW_HIERARCHY_PREF = "outline-show-hierarchy";
    private static final String OUTLINE_SHOW_VARIABLES_PREF = "outline-show-variables";
    private static final String OUTLINE_SORT_PREF = "outline-sort";
    protected ImageDescriptor COLLAPSE_D = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/dlcl16/collapseall.gif");
    protected ImageDescriptor COLLAPSE_E = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/elcl16/collapseall.gif");
    protected ImageDescriptor DELETE_D = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/dlcl16/delete.gif");
    protected ImageDescriptor DELETE_E = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/elcl16/delete.gif");
    private MenuManager fContextMenu = null;
    private boolean fContextMenuRegistered = false;
    protected DeleteAction fDeleteAction = new DeleteAction();
    protected IDocument fDocument = null;
    private DoubleClickProvider fDoubleClickProvider;
    private boolean fIsLinked = true;
    private ISelectionListener fSelectionListener;
    private PropertyChangeUpdateActionContributionItem fShowHierarchyItem;
    private PropertyChangeUpdateActionContributionItem fShowVariablesItem;
    private PropertyChangeUpdateActionContributionItem fSortItem;
    protected ISourceViewer fSourceViewer = null;
    private PropertyChangeUpdateActionContributionItem fToggleLinkItem;
    protected ImageDescriptor SYNCED_D = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/dlcl16/synced.gif");
    protected ImageDescriptor SYNCED_E = SharedEditorPluginImageHelper.getImageDescriptor((String)"icons/full/elcl16/synced.gif");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public JSContentOutlinePage(IDocument document, ISourceViewer sourceViewer) {
        this.setDocument(document);
        this.setSourceViewer(sourceViewer);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        if (this.fDoubleClickProvider == null) {
            this.fDoubleClickProvider = new DoubleClickProvider();
        }
        this.fDoubleClickProvider.addDoubleClickListener(listener);
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.fDeleteAction);
        IContributionItem[] items = menuManager.getItems();
        if (items.length > 0 && items[items.length - 1].getId() != null) {
            menuManager.insertAfter(items[items.length - 1].getId(), (IContributionItem)new GroupMarker("additions"));
        } else {
            menuManager.add((IContributionItem)new GroupMarker("additions"));
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)new JSTreeContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new JSLabelProvider());
        this.getTreeViewer().setInput((Object)this.fDocument);
        this.getTreeViewer().setComparer((IElementComparer)new ContentElementComparerImpl());
        if (this.fDoubleClickProvider == null) {
            this.fDoubleClickProvider = new DoubleClickProvider();
        }
        this.getTreeViewer().addDoubleClickListener((IDoubleClickListener)this.fDoubleClickProvider);
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener((IDocumentListener)this);
        }
        this.fContextMenu = new MenuManager("#popup");
        this.fContextMenu.setRemoveAllWhenShown(true);
        this.fContextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                JSContentOutlinePage.this.contextMenuAboutToShow(menuManager);
            }
        });
        Menu menu = this.fContextMenu.createContextMenu((Control)this.getTreeViewer().getTree());
        this.getTreeViewer().getTree().setMenu(menu);
        this.registerContextMenu();
    }

    public void dispose() {
        super.dispose();
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener((IDocumentListener)this);
        }
        if (this.fShowHierarchyItem != null) {
            this.fShowHierarchyItem.disconnect();
        }
        if (this.fSortItem != null) {
            this.fSortItem.disconnect();
        }
        if (this.fShowVariablesItem != null) {
            this.fShowVariablesItem.disconnect();
        }
        if (this.fToggleLinkItem != null) {
            this.fToggleLinkItem.disconnect();
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.getSelectionServiceListener());
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
    }

    public Object getAdapter(Class key) {
        Object adapter = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            adapter = new ShowInTarget();
        }
        final IEditorPart editor = this.getActiveEditorPart();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz2) && editor != null) {
            adapter = new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext((Object)editor.getEditorInput(), editor.getEditorSite().getSelectionProvider().getSelection());
                }
            };
        } else {
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (key.equals(clazz3) && editor != null) {
                adapter = editor.getAdapter(key);
            }
        }
        return adapter;
    }

    IEditorPart getActiveEditorPart() {
        return this.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
    }

    ContentElement getContentElementAt(ContentElement contentElement, int caretPosition) {
        ContentElement result = null;
        Vector children = contentElement.getChildren();
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                ContentElement eachContentElement = (ContentElement)iter.next();
                result = this.getContentElementAt(eachContentElement, caretPosition);
                if (result == null) continue;
                return result;
            }
        }
        int offset = contentElement.getOffset();
        int length = contentElement.getLength();
        if (caretPosition >= offset && caretPosition <= offset + length) {
            result = contentElement;
        }
        return result;
    }

    private ISelectionListener getSelectionServiceListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (!JSContentOutlinePage.this.getTreeViewer().getControl().isDisposed() && !JSContentOutlinePage.this.getTreeViewer().getControl().isFocusControl() && JSContentOutlinePage.this.getTreeViewer().getControl().isVisible()) {
                        IStructuredSelection structuredSelection;
                        if (JSContentOutlinePage.this.fIsLinked && (structuredSelection = JSContentOutlinePage.this.getStructuredSelectionFor(selection)) != null) {
                            JSContentOutlinePage.this.getTreeViewer().setSelection((ISelection)structuredSelection);
                        }
                        JSContentOutlinePage.this.getTreeViewer().refresh();
                    }
                }
            };
        }
        return this.fSelectionListener;
    }

    protected ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    IStructuredSelection getStructuredSelectionFor(ISelection selection) {
        IStructuredSelection structuredSelection = null;
        if (selection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
        } else if (selection instanceof ITextSelection) {
            ContentElement o = null;
            if (selection instanceof ITextSelection) {
                TreeItem[] treeItems = this.getTreeViewer().getTree().getItems();
                int i = 0;
                while (i < treeItems.length) {
                    ContentElement eachContentElement = (ContentElement)treeItems[i].getData();
                    o = this.getContentElementAt(eachContentElement, ((ITextSelection)selection).getOffset());
                    if (o != null) break;
                    ++i;
                }
                if (o != null) {
                    structuredSelection = new StructuredSelection(o);
                }
            }
        }
        return structuredSelection;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.getSelectionServiceListener());
    }

    void registerContextMenu() {
        IEditorPart ownerEditor;
        IWorkbenchPage page;
        if (!this.fContextMenuRegistered && this.getTreeViewer() != null && this.getTreeViewer().getControl() != null && (page = this.getSite().getWorkbenchWindow().getActivePage()) != null && (ownerEditor = page.getActiveEditor()) != null) {
            this.fContextMenuRegistered = true;
            this.getSite().registerContextMenu(String.valueOf(ownerEditor.getEditorSite().getId()) + ".OutlineContext", this.fContextMenu, (ISelectionProvider)this);
        }
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        if (this.fDoubleClickProvider != null) {
            this.fDoubleClickProvider.removeDoubleClickListener(listener);
        }
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        SortAction sortAction = new SortAction(this.getTreeViewer(), JSEditorPlugin.getDefault().getPreferenceStore(), OUTLINE_SORT_PREF);
        this.fSortItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)sortAction);
        PropertyChangeUpdateAction action = new ShowHierarchyAction(JavaScriptUIMessages.JSContentOutlinePage_2, JSEditorPlugin.getInstance().getPreferenceStore(), OUTLINE_SHOW_HIERARCHY_PREF, true);
        this.fShowHierarchyItem = new PropertyChangeUpdateActionContributionItem(action);
        action = new ShowVariablesAction(JavaScriptUIMessages.JSContentOutlinePage_3, JSEditorPlugin.getInstance().getPreferenceStore(), OUTLINE_SHOW_VARIABLES_PREF, true);
        this.fShowVariablesItem = new PropertyChangeUpdateActionContributionItem(action);
        CollapseTreeAction collapseAction = new CollapseTreeAction(this.getTreeViewer());
        this.fToggleLinkItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)new ToggleLinkAction(JSEditorPlugin.getInstance().getPreferenceStore(), OUTLINE_LINK_PREF));
        actionBars.getToolBarManager().add((IContributionItem)this.fSortItem);
        actionBars.getToolBarManager().add((IAction)collapseAction);
        actionBars.getMenuManager().add((IContributionItem)this.fToggleLinkItem);
        actionBars.getMenuManager().add((IContributionItem)this.fShowHierarchyItem);
        actionBars.getMenuManager().add((IContributionItem)this.fShowVariablesItem);
    }

    public void setDocument(IDocument document) {
        if (document != this.fDocument) {
            this.fDocument = document;
            if (this.getTreeViewer() != null) {
                this.getTreeViewer().setInput((Object)this.fDocument);
                this.getTreeViewer().refresh();
            }
        }
    }

    public void setLinkWithEditor(boolean b) {
        this.fIsLinked = b;
    }

    public void setSelection(ISelection selection) {
        if (this.getTreeViewer() != null && this.fIsLinked) {
            this.getTreeViewer().setSelection(selection, true);
        }
    }

    protected void setSourceViewer(ISourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
    }

    protected class CollapseTreeAction
    extends Action {
        private TreeViewer fTreeViewer = null;

        public CollapseTreeAction(TreeViewer viewer) {
            super(JavaScriptUIMessages.JSContentOutlinePage_0, 1);
            this.setImageDescriptor(JSContentOutlinePage.this.COLLAPSE_E);
            this.setDisabledImageDescriptor(JSContentOutlinePage.this.COLLAPSE_D);
            this.setToolTipText(this.getText());
            this.fTreeViewer = viewer;
        }

        public void run() {
            super.run();
            this.fTreeViewer.collapseAll();
        }
    }

    protected class DeleteAction
    extends Action {
        public DeleteAction() {
            super(JavaScriptUIMessages.JSContentOutlinePage_5);
            this.setImageDescriptor(JSContentOutlinePage.this.DELETE_E);
            this.setDisabledImageDescriptor(JSContentOutlinePage.this.DELETE_D);
            this.setToolTipText(this.getText());
        }

        public void run() {
            Object firstElement;
            ISelection selection = JSContentOutlinePage.this.getTreeViewer().getSelection();
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof ContentElement) {
                ContentElement contentElement = (ContentElement)firstElement;
                try {
                    JSContentOutlinePage.this.fDocument.replace(contentElement.getOffset(), contentElement.getLength(), "");
                    JSContentOutlinePage.this.getTreeViewer().refresh();
                }
                catch (BadLocationException exception) {
                    Logger.logException(exception);
                }
            }
        }
    }

    private class DoubleClickProvider
    implements IDoubleClickListener {
        private IDoubleClickListener[] listeners = null;

        private DoubleClickProvider() {
        }

        void addDoubleClickListener(IDoubleClickListener newListener) {
            if (this.listeners == null) {
                this.listeners = new IDoubleClickListener[]{newListener};
            } else {
                IDoubleClickListener[] newListeners = new IDoubleClickListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
                newListeners[this.listeners.length] = newListener;
                this.listeners = newListeners;
            }
        }

        public void doubleClick(DoubleClickEvent event) {
            this.fireDoubleClickEvent(event);
        }

        private void fireDoubleClickEvent(DoubleClickEvent event) {
            IDoubleClickListener[] firingListeners = this.listeners;
            int i = 0;
            while (i < firingListeners.length) {
                IDoubleClickListener l = firingListeners[i];
                Platform.run((ISafeRunnable)new SafeRunnable(this, l, event){
                    final /* synthetic */ DoubleClickProvider this$1;
                    private final /* synthetic */ IDoubleClickListener val$l;
                    private final /* synthetic */ DoubleClickEvent val$event;
                    {
                        this.this$1 = doubleClickProvider;
                        this.val$l = iDoubleClickListener;
                        this.val$event = doubleClickEvent;
                    }

                    public void run() {
                        this.val$l.doubleClick(this.val$event);
                    }
                });
                ++i;
            }
        }

        void removeDoubleClickListener(IDoubleClickListener oldListener) {
            if (this.listeners != null) {
                if (this.listeners.length == 1 && this.listeners[0].equals(oldListener)) {
                    this.listeners = null;
                } else {
                    ArrayList<IDoubleClickListener> newListeners = new ArrayList<IDoubleClickListener>(Arrays.asList(this.listeners));
                    newListeners.remove(oldListener);
                    this.listeners = newListeners.toArray(new IDoubleClickListener[this.listeners.length - 1]);
                }
            }
        }
    }

    protected class ShowHierarchyAction
    extends PropertyChangeUpdateAction {
        public ShowHierarchyAction(String text, IPreferenceStore store, String preferenceKey, boolean defaultValue) {
            super(text, store, preferenceKey, defaultValue);
            this.setToolTipText(this.getText());
            this.setImageDescriptor(JSEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/hierarchy.gif"));
        }

        public void update() {
            super.update();
            JSContentElementImpl.setSupportChildren(this.isChecked());
            Object[] expanded = JSContentOutlinePage.this.getTreeViewer().getExpandedElements();
            JSContentOutlinePage.this.getTreeViewer().refresh();
            JSContentOutlinePage.this.getTreeViewer().setExpandedElements(expanded);
        }
    }

    private class ShowInTarget
    implements IShowInTarget {
        private ShowInTarget() {
        }

        public boolean show(ShowInContext context) {
            JSContentOutlinePage.this.setSelection((ISelection)JSContentOutlinePage.this.getStructuredSelectionFor(context.getSelection()));
            return JSContentOutlinePage.this.getTreeViewer().getSelection().equals(context.getSelection());
        }
    }

    protected class ShowVariablesAction
    extends PropertyChangeUpdateAction {
        public ShowVariablesAction(String text, IPreferenceStore store, String preferenceKey, boolean defaultValue) {
            super(text, store, preferenceKey, defaultValue);
            this.setToolTipText(this.getText());
            this.setImageDescriptor(JSEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/default.gif"));
        }

        public void update() {
            super.update();
            JSContentElementImpl.setSupportVariables(this.isChecked());
            Object[] expanded = JSContentOutlinePage.this.getTreeViewer().getExpandedElements();
            JSContentOutlinePage.this.getTreeViewer().refresh();
            JSContentOutlinePage.this.getTreeViewer().setExpandedElements(expanded);
        }
    }

    protected class SortAction
    extends PropertyChangeUpdateAction {
        private TreeViewer treeViewer;

        public SortAction(TreeViewer viewer, IPreferenceStore store, String preferenceKey) {
            super(JavaScriptUIMessages.JSContentOutlinePage_4, store, preferenceKey, false);
            this.setImageDescriptor(JSEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/sort.gif"));
            this.setToolTipText(this.getText());
            this.treeViewer = viewer;
            if (this.isChecked()) {
                this.treeViewer.setSorter((ViewerSorter)new CategorySorter(Collator.getInstance()));
            }
        }

        public void update() {
            super.update();
            this.treeViewer.getControl().setRedraw(false);
            Object[] expandedElements = this.treeViewer.getExpandedElements();
            ISelection selection = this.treeViewer.getSelection();
            if (this.isChecked()) {
                this.treeViewer.setSorter((ViewerSorter)new CategorySorter(Collator.getInstance()));
            } else {
                this.treeViewer.setSorter(null);
            }
            this.treeViewer.setInput(this.treeViewer.getInput());
            this.treeViewer.setExpandedElements(expandedElements);
            this.treeViewer.setSelection(selection);
            this.treeViewer.getControl().setRedraw(true);
        }

        protected class CategorySorter
        extends ViewerSorter {
            public CategorySorter() {
            }

            public CategorySorter(Collator collator) {
                super(collator);
            }

            public int category(Object element) {
                if (element instanceof ContentElement) {
                    return ((ContentElement)element).getType();
                }
                return 0;
            }
        }
    }

    protected class ToggleLinkAction
    extends PropertyChangeUpdateAction {
        public ToggleLinkAction(IPreferenceStore store, String preference) {
            super(JavaScriptUIMessages.JSContentOutlinePage_1, store, preference, true);
            this.setToolTipText(this.getText());
            this.setDisabledImageDescriptor(JSContentOutlinePage.this.SYNCED_D);
            this.setImageDescriptor(JSContentOutlinePage.this.SYNCED_E);
            this.update();
        }

        public void update() {
            JSContentOutlinePage.this.setLinkWithEditor(this.isChecked());
        }
    }
}

