/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.uriresolver.internal.util;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.uriresolver.internal.util.URIEncoder;

public class URIHelper {
    protected static final String FILE_PROTOCOL = "file:";
    protected static final String PLATFORM_RESOURCE_PROTOCOL = "platform:/resource/";
    protected static final String PROTOCOL_PATTERN = ":";

    public static String normalize(String uri) {
        if (uri != null) {
            String protocol = URIHelper.getProtocol(uri);
            String file = uri;
            if (protocol != null) {
                try {
                    URL url = new URL(uri);
                    Path path = new Path(url.getFile());
                    URL url2 = new URL(url.getProtocol(), url.getHost(), url.getPort(), path.toString());
                    uri = url2.toString();
                }
                catch (Exception exception) {}
            } else {
                Path path = new Path(file);
                uri = path.toString();
            }
        }
        return uri;
    }

    public static String normalize(String uri, String resourceLocation, String rootLocation) {
        String result = null;
        if (uri != null) {
            if (URIHelper.hasProtocol(uri)) {
                result = URIHelper.isPlatformResourceProtocol(uri) ? URIHelper.resolvePlatformUrl(uri) : uri;
            }
            if (result == null && (uri.indexOf(PROTOCOL_PATTERN) != -1 || uri.startsWith("/") || uri.startsWith("\\"))) {
                result = uri;
            }
            if (result == null && resourceLocation != null) {
                result = resourceLocation.endsWith("/") ? String.valueOf(resourceLocation) + uri : String.valueOf(resourceLocation) + "/../" + uri;
            }
            if (result == null) {
                result = uri;
            }
            result = URIHelper.normalize(result);
        }
        return result;
    }

    public static boolean isURL(String uri) {
        return uri.indexOf(":/") > 2;
    }

    public static String getLastSegment(String uri) {
        String result = uri;
        int index = Math.max(uri.lastIndexOf("/"), uri.lastIndexOf("\\"));
        if (index != -1) {
            result = uri.substring(index + 1);
        }
        return result;
    }

    public static String getFileExtension(String uri) {
        String result = null;
        int dotIndex = URIHelper.getExtensionDotIndex(uri);
        if (dotIndex != -1) {
            result = uri.substring(dotIndex + 1);
        }
        return result;
    }

    public static String removeFileExtension(String uri) {
        String result = null;
        int dotIndex = URIHelper.getExtensionDotIndex(uri);
        if (dotIndex != -1) {
            result = uri.substring(0, dotIndex);
        }
        return result;
    }

    protected static String resolvePlatformUrl(String urlspec) {
        String result = null;
        try {
            urlspec = urlspec.replace('\\', '/');
            URL url = new URL(urlspec);
            URL resolvedURL = Platform.resolve((URL)url);
            result = resolvedURL.toString();
        }
        catch (Exception exception) {}
        return result;
    }

    protected static int getExtensionDotIndex(String uri) {
        int result = -1;
        int dotIndex = uri.lastIndexOf(".");
        int slashIndex = Math.max(uri.lastIndexOf("/"), uri.lastIndexOf("\\"));
        if (dotIndex != -1 && dotIndex > slashIndex) {
            result = dotIndex;
        }
        return result;
    }

    public static boolean isPlatformResourceProtocol(String uri) {
        return uri != null && uri.startsWith(PLATFORM_RESOURCE_PROTOCOL);
    }

    public static String removePlatformResourceProtocol(String uri) {
        if (uri != null && uri.startsWith(PLATFORM_RESOURCE_PROTOCOL)) {
            uri = uri.substring(PLATFORM_RESOURCE_PROTOCOL.length());
        }
        return uri;
    }

    public static String prependPlatformResourceProtocol(String uri) {
        if (uri != null && !uri.startsWith(PLATFORM_RESOURCE_PROTOCOL)) {
            uri = PLATFORM_RESOURCE_PROTOCOL + uri;
        }
        return uri;
    }

    public static String prependFileProtocol(String uri) {
        if (uri != null && !uri.startsWith(FILE_PROTOCOL)) {
            uri = FILE_PROTOCOL + uri;
        }
        return uri;
    }

    public static boolean hasProtocol(String uri) {
        int index;
        boolean result = false;
        if (uri != null && (index = uri.indexOf(PROTOCOL_PATTERN)) != -1 && index > 2) {
            result = true;
        }
        return result;
    }

    public static boolean isAbsolute(String uri) {
        int index;
        boolean result = false;
        if (uri != null && ((index = uri.indexOf(PROTOCOL_PATTERN)) != -1 || uri.startsWith("/"))) {
            result = true;
        }
        return result;
    }

    public static String addImpliedFileProtocol(String uri) {
        if (!URIHelper.hasProtocol(uri)) {
            String prefix = FILE_PROTOCOL;
            prefix = String.valueOf(prefix) + (uri.startsWith("/") ? "//" : "///");
            uri = String.valueOf(prefix) + uri;
        }
        return uri;
    }

    protected static String getProtocol(String uri) {
        int index;
        String result = null;
        if (uri != null && (index = uri.indexOf(PROTOCOL_PATTERN)) > 2) {
            result = uri.substring(0, index + PROTOCOL_PATTERN.length());
        }
        return result;
    }

    public static String removeProtocol(String uri) {
        int index;
        String result = uri;
        if (uri != null && (index = uri.indexOf(PROTOCOL_PATTERN)) > 2) {
            result = result.substring(index + PROTOCOL_PATTERN.length());
        }
        return result;
    }

    protected static boolean isProtocolFileOrNull(String uri) {
        String protocol = URIHelper.getProtocol(uri);
        return protocol == null || protocol.equals(FILE_PROTOCOL);
    }

    protected static boolean isMatchingProtocol(String uri1, String uri2) {
        boolean result = false;
        String protocol1 = URIHelper.getProtocol(uri1);
        String protocol2 = URIHelper.getProtocol(uri2);
        result = URIHelper.isProtocolFileOrNull(protocol1) && URIHelper.isProtocolFileOrNull(protocol2) ? true : protocol1 != null && protocol2 != null && protocol1.equals(protocol2);
        return result;
    }

    public static String getRelativeURI(String uri, String resourceLocation) {
        String result = uri;
        if (URIHelper.isMatchingProtocol(uri, resourceLocation)) {
            result = URIHelper.getRelativeURI((IPath)new Path(URIHelper.removeProtocol(uri)), (IPath)new Path(URIHelper.removeProtocol(resourceLocation)));
        }
        return result;
    }

    public static String getRelativeURI(IPath uri, IPath resourceLocation) {
        String result = null;
        int nMatchingSegments = 0;
        resourceLocation = resourceLocation.removeLastSegments(1);
        while (true) {
            String a = uri.segment(nMatchingSegments);
            String b = resourceLocation.segment(nMatchingSegments);
            if (a == null || b == null || !a.equals(b)) break;
            ++nMatchingSegments;
        }
        if (nMatchingSegments == 0) {
            result = uri.toOSString();
        } else {
            result = "";
            boolean isFirst = true;
            String[] segments = resourceLocation.segments();
            int i = nMatchingSegments;
            while (i < segments.length) {
                result = String.valueOf(result) + (isFirst ? ".." : "/..");
                if (isFirst) {
                    isFirst = false;
                }
                ++i;
            }
            segments = uri.segments();
            i = nMatchingSegments;
            while (i < segments.length) {
                result = String.valueOf(result) + (isFirst ? segments[i] : "/" + segments[i]);
                if (isFirst) {
                    isFirst = false;
                }
                ++i;
            }
        }
        return result;
    }

    public static String getPlatformURI(IResource resource) {
        String fullPath = resource.getFullPath().toString();
        if (fullPath.startsWith("/")) {
            fullPath = fullPath.substring(1);
        }
        return PLATFORM_RESOURCE_PROTOCOL + fullPath;
    }

    public static boolean isReadableURI(String uri, boolean testRemoteURI) {
        boolean result = true;
        if (uri != null) {
            try {
                uri = URIHelper.normalize(uri, null, null);
                if (URIHelper.isProtocolFileOrNull(uri)) {
                    File file = new File(uri = URIHelper.removeProtocol(uri));
                    result = file.exists() && file.isFile();
                } else if (URIHelper.isPlatformResourceProtocol(uri)) {
                    result = false;
                } else if (testRemoteURI) {
                    URL url = new URL(uri);
                    InputStream is = url.openConnection().getInputStream();
                    is.close();
                    result = true;
                }
            }
            catch (Exception exception) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isValidURI(String uri) {
        boolean result = false;
        try {
            new URI(uri);
            result = true;
        }
        catch (Exception exception) {}
        return result;
    }

    public static String getURIForFilePath(String filePath) {
        String result = URIHelper.addImpliedFileProtocol(filePath);
        if (!URIHelper.isValidURI(result)) {
            try {
                result = URIEncoder.encode(result, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return result;
    }
}

