/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.ProgressUtil;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public class PublishUtil {
    private static final int BUFFER = 10240;
    private static byte[] buf = new byte[10240];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private PublishUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus copyFile(InputStream in, String to) {
        IStatus iStatus;
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(to);
                int avail = in.read(buf);
                while (true) {
                    if (avail <= 0) {
                        iStatus = Status.OK_STATUS;
                        Object var4_7 = null;
                        break;
                    }
                    ((OutputStream)out).write(buf, 0, avail);
                    avail = in.read(buf);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error copying file", e);
                Status status = new Status(4, "org.eclipse.jst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
                Object var4_8 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out == null) return status;
                    ((OutputStream)out).close();
                    return status;
                }
                catch (Exception exception) {}
                return status;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {}
            catch (Exception exception) {}
            if (in != null) {
                in.close();
            }
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            if (out == null) throw throwable;
            ((OutputStream)out).close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (in != null) {
            in.close();
        }
        try {}
        catch (Exception exception) {}
        if (out == null) return iStatus;
        ((OutputStream)out).close();
        return iStatus;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyFile(InputStream in, IPath to, long ts) throws CoreException {
        OutputStream out;
        block19: {
            out = null;
            File tempFile = null;
            try {
                try {
                    File file = to.toFile();
                    File tempDir = JavaServerPlugin.getInstance().getStateLocation().toFile();
                    tempFile = File.createTempFile("tmp", "." + to.getFileExtension(), tempDir);
                    out = new FileOutputStream(tempFile);
                    int avail = in.read(buf);
                    while (true) {
                        if (avail <= 0) {
                            out.close();
                            out = null;
                            int i = 0;
                            if (!file.exists()) break;
                            ++i;
                            if (file.delete()) break;
                            i += 2;
                            tempFile.delete();
                            throw new Exception(NLS.bind((String)Messages.errorDelete, (Object)file.toString()));
                        }
                        out.write(buf, 0, avail);
                        avail = in.read(buf);
                    }
                    i += 4;
                    if (!tempFile.renameTo(file)) {
                        throw new Exception(NLS.bind((String)Messages.errorRename, (Object)tempFile.toString(), (Object)file.toString()));
                    }
                    if (ts != -1L && ts != 0L) {
                        file.setLastModified(ts);
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Error copying file", e);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object)to.toOSString(), (Object)e.getLocalizedMessage()), (Throwable)e));
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (tempFile == null || !tempFile.exists()) break block19;
                tempFile.deleteOnExit();
            }
        }
        try {}
        catch (Exception exception) {}
        if (in != null) {
            in.close();
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (out == null) return;
        out.close();
    }

    private static void copyFile(IModuleFile mf, IPath path) throws CoreException {
        IFile file;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)mf.getAdapter((Class)clazz)) != null) {
            PublishUtil.copyFile(file.getContents(), path, file.getLocalTimeStamp());
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            File file2 = (File)mf.getAdapter((Class)clazz2);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file2);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.core", 0, NLS.bind((String)Messages.errorReading, (Object)file2.getAbsolutePath()), (Throwable)e));
            }
            PublishUtil.copyFile(in, path, file2.lastModified());
        }
    }

    public static void deleteDirectory(File dir, IProgressMonitor monitor) {
        try {
            if (!dir.exists() || !dir.isDirectory()) {
                return;
            }
            File[] files = dir.listFiles();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    current.delete();
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                    PublishUtil.deleteDirectory(current, ProgressUtil.getSubMonitorFor(monitor, 10));
                }
                ++i;
            }
            dir.delete();
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error deleting directory " + dir.getAbsolutePath(), e);
        }
    }

    public static void smartCopy(IModuleResource[] resources, IPath path, IProgressMonitor monitor) throws CoreException {
        int toSize;
        if (resources == null) {
            return;
        }
        File toDir = path.toFile();
        File[] toFiles = toDir.listFiles();
        int fromSize = resources.length;
        if (toDir.exists() && toDir.isDirectory()) {
            toSize = toFiles.length;
            int i = 0;
            while (i < toSize) {
                String name = toFiles[i].getName();
                boolean isDir = toFiles[i].isDirectory();
                boolean found = false;
                int j = 0;
                while (j < fromSize) {
                    if (name.equals(resources[j].getName()) && isDir == resources[j] instanceof IModuleFolder) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    if (isDir) {
                        PublishUtil.deleteDirectory(toFiles[i], null);
                    } else {
                        toFiles[i].delete();
                    }
                }
                if (monitor.isCanceled()) {
                    return;
                }
                ++i;
            }
        } else {
            if (toDir.isFile()) {
                toDir.delete();
            }
            toDir.mkdir();
        }
        monitor.worked(50);
        toFiles = toDir.listFiles();
        toSize = toFiles.length;
        int dw = 0;
        if (toSize > 0) {
            dw = 500 / toSize;
        }
        int i = 0;
        while (i < fromSize) {
            IModuleResource current = resources[i];
            boolean copy = true;
            boolean currentIsDir = current instanceof IModuleFolder;
            if (copy) {
                IPath toPath = path.append(current.getName());
                if (!currentIsDir) {
                    IModuleFile mf = (IModuleFile)current;
                    PublishUtil.copyFile(mf, toPath);
                    monitor.worked(dw);
                } else {
                    IModuleFolder folder = (IModuleFolder)current;
                    IModuleResource[] children = folder.members();
                    monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{resources[i].getName(), current.getName()}));
                    PublishUtil.smartCopy(children, toPath, ProgressUtil.getSubMonitorFor(monitor, dw));
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            ++i;
        }
        monitor.worked(500 - dw * toSize);
        monitor.done();
    }

    public static void handleDelta(int kind, IPath path, IModuleResourceDelta delta) throws CoreException {
        IPath path2;
        IModuleResource resource = delta.getModuleResource();
        int kind2 = delta.getKind();
        if (resource instanceof IModuleFile) {
            IModuleFile file = (IModuleFile)resource;
            if (kind2 == 3) {
                PublishUtil.deleteFile(path, file);
            } else {
                PublishUtil.copyFile(path, file);
            }
            return;
        }
        if (kind2 == 1) {
            path2 = path.append(resource.getModuleRelativePath()).append(resource.getName());
            path2.toFile().mkdirs();
        } else if (kind == 3) {
            path2 = path.append(resource.getModuleRelativePath()).append(resource.getName());
            path2.toFile().delete();
        }
        IModuleResourceDelta[] childDeltas = delta.getAffectedChildren();
        int size = childDeltas.length;
        int i = 0;
        while (i < size) {
            PublishUtil.handleDelta(kind, path, childDeltas[i]);
            ++i;
        }
    }

    protected static void deleteFile(IPath path, IModuleFile file) {
        IPath path2 = path.append(file.getModuleRelativePath()).append(file.getName());
        path2.toFile().delete();
    }

    private static void copyFile(IPath path, IModuleFile mf) throws CoreException {
        IFile file;
        Class<?> clazz;
        IPath path3 = path.append(mf.getModuleRelativePath()).append(mf.getName());
        File f = path3.toFile().getParentFile();
        if (!f.exists()) {
            f.mkdirs();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)mf.getAdapter((Class)clazz)) != null) {
            PublishUtil.copyFile(file.getContents(), path3, file.getLocalTimeStamp());
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            File file2 = (File)mf.getAdapter((Class)clazz2);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file2);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.core", 0, NLS.bind((String)Messages.errorReading, (Object)file2.getAbsolutePath()), (Throwable)e));
            }
            PublishUtil.copyFile(in, path3, file2.lastModified());
        }
    }

    public static void copy(IModuleResource[] resources, IPath path) throws CoreException {
        if (resources == null) {
            return;
        }
        int size = resources.length;
        int i = 0;
        while (i < size) {
            PublishUtil.copy(resources[i], path);
            ++i;
        }
    }

    private static void copy(IModuleResource resource, IPath path) throws CoreException {
        if (resource instanceof IModuleFolder) {
            IModuleFolder folder = (IModuleFolder)resource;
            PublishUtil.copy(folder.members(), path);
        } else {
            IFile file;
            Class<?> clazz;
            IModuleFile mf = (IModuleFile)resource;
            IPath path3 = path.append(mf.getModuleRelativePath()).append(mf.getName());
            File f = path3.toFile().getParentFile();
            if (!f.exists()) {
                f.mkdirs();
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)mf.getAdapter((Class)clazz)) != null) {
                PublishUtil.copyFile(file.getContents(), path3, file.getLocalTimeStamp());
            } else {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.io.File");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                File file2 = (File)mf.getAdapter((Class)clazz2);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file2);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.core", 0, NLS.bind((String)Messages.errorReading, (Object)file2.getAbsolutePath()), (Throwable)e));
                }
                PublishUtil.copyFile(in, path3, file2.lastModified());
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void createZipFile(IModuleResource[] resources, IPath zipPath) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 263->267)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addZipEntries(ZipOutputStream zout, IModuleResource[] resources) throws Exception {
        int size = resources.length;
        int i = 0;
        while (i < size) {
            IModuleFolder mf;
            if (resources[i] instanceof IModuleFolder) {
                mf = (IModuleFolder)resources[i];
                IModuleResource[] res = mf.members();
                PublishUtil.addZipEntries(zout, res);
            } else {
                Object var12_12;
                IFile file;
                mf = (IModuleFile)resources[i];
                IPath path = mf.getModuleRelativePath().append(mf.getName());
                ZipEntry ze = new ZipEntry(path.toPortableString());
                InputStream in = null;
                long ts = 0L;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((file = (IFile)mf.getAdapter((Class)clazz)) != null) {
                    ts = file.getLocalTimeStamp();
                    in = file.getContents();
                } else {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.io.File");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    File file2 = (File)mf.getAdapter((Class)clazz2);
                    ts = file2.lastModified();
                    in = new FileInputStream(file2);
                }
                if (ts != -1L && ts != 0L) {
                    ze.setTime(ts);
                }
                zout.putNextEntry(ze);
                try {
                    int n = 0;
                    while (n > -1) {
                        n = in.read(buf);
                        if (n <= 0) continue;
                        zout.write(buf, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    in.close();
                    throw throwable;
                }
                {
                    var12_12 = null;
                }
                in.close();
                zout.closeEntry();
            }
            ++i;
        }
        return;
    }
}

