/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.emf2xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRenderer;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.ResourceSetWorkbenchEditSynchronizer;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.emf2xml.EMF2DOMSSEAdapter;
import org.eclipse.wst.xml.core.internal.emf2xml.UIResourceHandler;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class EMF2DOMSSERenderer
extends EMF2DOMRenderer
implements IModelStateListener,
IModelLifecycleListener {
    protected IDOMModel xmlModel;
    protected String xmlModelId;
    private IModelManager modelManager;
    protected Object aboutToChangeNode = null;
    protected boolean xmlModelReverted = false;
    protected boolean isBatchChanges = false;
    private boolean isSaving = false;

    protected boolean managesDOMAdapters() {
        return false;
    }

    protected EMF2DOMAdapter createRootDOMAdapter() {
        return new EMF2DOMSSEAdapter(this.getResource(), this.document, (EMF2DOMRenderer)this, this.getResource().getRootTranslator());
    }

    public void deRegisterAsModelStateListener() {
        if (this.xmlModel != null) {
            this.xmlModel.removeModelStateListener(this);
        }
    }

    public void deRegisterAsModelLifecycleListener() {
        if (this.xmlModel != null) {
            this.xmlModel.removeModelLifecycleListener(this);
        }
    }

    public IDOMModel getXMLModel() {
        return this.xmlModel;
    }

    public String getXMLModelId() {
        return this.xmlModelId;
    }

    public boolean isModified() {
        return this.getXMLModel() != null && this.getXMLModel().isDirty();
    }

    public void modelAboutToBeChanged(IStructuredModel model) {
        if (model.getStructuredDocument() != null) {
            this.aboutToChangeNode = model.getStructuredDocument().getFirstStructuredDocumentRegion();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modelChanged(IStructuredModel model) {
        if (this.isBatchChanges) {
            return;
        }
        try {
            block8: {
                if (this.aboutToChangeNode != null && model.getStructuredDocument() != null && model.getStructuredDocument().getFirstStructuredDocumentRegion() != this.aboutToChangeNode) {
                    this.modelAccessForWrite();
                    try {
                        this.xmlModelReverted = true;
                        this.resource.unload();
                        Object var2_4 = null;
                        if (this.getXMLModel() == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        if (this.getXMLModel() == null) throw throwable;
                        this.getXMLModel().releaseFromEdit();
                        throw throwable;
                    }
                    this.getXMLModel().releaseFromEdit();
                }
            }
            Object var4_7 = null;
            this.aboutToChangeNode = null;
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.aboutToChangeNode = null;
            throw throwable;
        }
    }

    public void accessForRead() {
        if (!this.resource.isNew()) {
            String id = this.getModelManagerId();
            this.getModelManager().getExistingModelForRead((Object)id);
        }
    }

    public void accessForWrite() {
        this.modelAccessForWrite();
    }

    private void modelAccessForWrite() {
        String id = this.getModelManagerId();
        this.getModelManager().getExistingModelForEdit((Object)id);
    }

    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        if (!isDirty && this.resource.isModified()) {
            this.resource.setModified(false);
            long stamp = WorkbenchResourceHelper.computeModificationStamp((ReferencedResource)this.resource);
            WorkbenchResourceHelper.setSynhronizationStamp((ReferencedResource)this.resource, (long)stamp);
            ResourceSetWorkbenchEditSynchronizer synchronizer = (ResourceSetWorkbenchEditSynchronizer)((ProjectResourceSet)this.resource.getResourceSet()).getSynchronizer();
            IFile aFile = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
            synchronizer.preSave(aFile);
        }
        if (isDirty) {
            this.resource.setModified(true);
        }
    }

    public void modelResourceDeleted(IStructuredModel model) {
    }

    public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
    }

    public void preDelete() {
        if (this.resource.isLoaded()) {
            this.deregisterFromXMLModel();
        }
    }

    public void preUnload() {
        this.deregisterFromXMLModel();
    }

    private void deregisterFromXMLModel() {
        EMF2DOMAdapter adapter;
        this.deRegisterAsModelStateListener();
        this.deRegisterAsModelLifecycleListener();
        try {
            this.getModelManager();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (this.xmlModel != null) {
            int writeCount = this.resource.getWriteCount();
            int readCount = this.resource.getReadCount();
            int i = 0;
            while (i < writeCount) {
                this.xmlModel.releaseFromEdit();
                ++i;
            }
            int ii = 0;
            while (ii < readCount) {
                this.xmlModel.releaseFromRead();
                ++ii;
            }
        }
        if ((adapter = (EMF2DOMAdapter)EcoreUtil.getAdapter((List)this.resource.eAdapters(), (Object)EMF2DOMAdapter.ADAPTER_CLASS)) != null) {
            adapter.removeAdapters(adapter.getNode());
        }
        this.xmlModel = null;
        this.xmlModelId = null;
    }

    public void registerAsModelStateListener() {
        this.xmlModel.addModelStateListener(this);
    }

    public void registerAsModelLifecycleListener() {
        this.xmlModel.addModelLifecycleListener(this);
    }

    public void setXMLModel(IDOMModel xmlModel) {
        this.deRegisterAsModelStateListener();
        this.deRegisterAsModelLifecycleListener();
        this.xmlModel = xmlModel;
        this.registerAsModelStateListener();
        this.registerAsModelLifecycleListener();
    }

    public void setXMLModelId(String id) {
        this.xmlModelId = id;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(OutputStream outputStream, Map options) throws IOException {
        try {
            this.isSaving = true;
            if (outputStream != null) {
                throw new RuntimeException(UIResourceHandler.getString("EMF2DOMSedRenderer_UI_0", new Object[]{((Object)((Object)this)).getClass().getName()}));
            }
            this.createDOMTreeIfNecessary();
            ResourceSetWorkbenchEditSynchronizer synchronizer = (ResourceSetWorkbenchEditSynchronizer)((ProjectResourceSet)this.resource.getResourceSet()).getSynchronizer();
            IFile aFile = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
            try {
                synchronizer.preSave(aFile);
                this.xmlModel.save(aFile);
            }
            catch (CoreException ex) {
                synchronizer.removeFromRecentlySavedList(aFile);
                org.eclipse.jem.util.logger.proxy.Logger.getLogger().logError((Throwable)ex);
            }
            this.cacheSynchronizationStamp();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.isSaving = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.isSaving = false;
            return;
        }
    }

    public boolean wasReverted() {
        return this.xmlModelReverted;
    }

    protected IModelManager getModelManager() {
        if (this.modelManager == null) {
            this.modelManager = StructuredModelManager.getModelManager();
        }
        return this.modelManager;
    }

    protected String getModelManagerId() {
        if (this.xmlModelId == null) {
            IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.getResource());
            this.xmlModelId = file != null ? this.getModelManager().calculateId(file) : this.resource.getURI() + Long.toString(System.currentTimeMillis());
        }
        return this.xmlModelId;
    }

    public void releaseFromRead() {
        if (this.xmlModel != null) {
            this.xmlModel.releaseFromRead();
        }
    }

    public void releaseFromWrite() {
        if (this.xmlModel != null) {
            this.xmlModel.releaseFromEdit();
        }
    }

    protected ResourceSet getResourceSet() {
        return this.resource == null ? null : this.resource.getResourceSet();
    }

    public boolean isShared() {
        if (this.getResourceSet() == null || this.xmlModel == null) {
            return false;
        }
        return this.xmlModel.isShared();
    }

    public boolean isSharedForWrite() {
        if (this.getResourceSet() == null || this.xmlModel == null) {
            return false;
        }
        return this.xmlModel.isSharedForEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createDocument() {
        TranslatorResource res = this.getResource();
        res.setDefaults();
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        InputStream is = DOMUtilities.createHeaderInputStream((String)res.getDoctype(), (String)res.getPublicId(), (String)res.getSystemId());
        if (is == null) {
            return;
        }
        try {
            block11: {
                try {
                    try {
                        ArrayList<IContainer> folders = new ArrayList<IContainer>();
                        IContainer container = file.getParent();
                        while (true) {
                            if (container == null || container.exists() || !(container instanceof IFolder)) break;
                            folders.add(container);
                            container = container.getParent();
                        }
                        IFolder folder = null;
                        int i = 0;
                        while (true) {
                            if (i >= folders.size()) {
                                file.create(is, true, null);
                                file.setLocal(true, 1, null);
                            }
                            folder = (IFolder)folders.get(i);
                            folder.create(true, true, null);
                            ++i;
                        }
                    }
                    catch (CoreException e1) {
                        org.eclipse.jem.util.logger.proxy.Logger.getLogger().logError((Throwable)e1);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                {
                    Object var8_12 = null;
                    if (is == null) break block11;
                }
                is.close();
            }
            this.initializeXMLModel(file, true);
            return;
        }
        catch (IOException ex) {
            org.eclipse.jem.util.logger.proxy.Logger.getLogger().logError(UIResourceHandler.getString("Unexpected_IO_exception_occurred_creating_xml_document_1_EXC_"));
            org.eclipse.jem.util.logger.proxy.Logger.getLogger().logError((Throwable)ex);
        }
    }

    protected void createDOMTreeIfNecessary() {
        if (this.needsToCreateDOM) {
            this.createDOMTree();
        }
    }

    private IDOMModel initializeXMLModel(IFile file, boolean forWrite) throws UnsupportedEncodingException, IOException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(file == null ? "null" : file.getFullPath().toOSString());
        }
        try {
            if (forWrite) {
                this.setXMLModel((IDOMModel)this.getModelManager().getModelForEdit(file));
            } else {
                this.setXMLModel((IDOMModel)this.getModelManager().getModelForRead(file));
            }
            this.setXMLModelId(this.getXMLModel().getId());
            this.needsToCreateDOM = false;
        }
        catch (CoreException e) {
            org.eclipse.jem.util.logger.proxy.Logger.getLogger().logError((Throwable)e);
            return null;
        }
        String id = this.getModelManager().calculateId(file);
        this.syncReferenceCounts(id, forWrite);
        if (this.xmlModel != null) {
            this.document = this.xmlModel.getDocument();
        }
        return this.xmlModel;
    }

    private void syncReferenceCounts(String id, boolean forWrite) {
        int editIndex = 0;
        int readIndex = 0;
        if (forWrite) {
            ++editIndex;
        } else {
            ++readIndex;
        }
        int writeCount = this.resource.getWriteCount();
        int readCount = this.resource.getReadCount();
        int i = writeCount;
        while (i > editIndex) {
            this.modelManager.getExistingModelForEdit((Object)id);
            --i;
        }
        i = readCount;
        while (i > readIndex) {
            this.modelManager.getExistingModelForRead((Object)id);
            --i;
        }
    }

    protected void loadDocument(InputStream in, Map options) throws IOException {
        if (in != null) {
            throw new RuntimeException(UIResourceHandler.getString("EMF2DOMSedRenderer_UI_1", new Object[]{((Object)((Object)this)).getClass().getName()}));
        }
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        this.initializeXMLModel(file, this.resource.getWriteCount() != 0);
        this.cacheSynchronizationStamp();
    }

    private void cacheSynchronizationStamp() {
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        if (file != null && this.xmlModel != null) {
            this.xmlModel.resetSynchronizationStamp((IResource)file);
        }
    }

    public void setBatchMode(boolean isBatch) {
        if (isBatch && this.isBatchChanges) {
            Logger.log(1, "setBatch was set to true when it was already true. This can be an inidcation of invalid calling order");
        }
        if (isBatch) {
            this.batchModeStart();
        } else {
            this.batchModeEnd();
        }
    }

    public void batchModeStart() {
        this.isBatchChanges = true;
        this.getXMLModel().aboutToChangeModel();
        this.setRootNodeAdapterNotificationEnabled(false);
    }

    public void batchModeEnd() {
        this.getXMLModel().changedModel();
        this.setRootNodeAdapterNotificationEnabled(true);
        this.isBatchChanges = false;
    }

    public boolean isBatchMode() {
        return this.isBatchChanges;
    }

    private void setRootNodeAdapterNotificationEnabled(boolean b) {
        EMF2DOMAdapter adapter;
        EObject root = this.resource.getRootObject();
        if (root != null && (adapter = (EMF2DOMAdapter)EcoreUtil.getExistingAdapter((Notifier)root, (Object)EMF2DOMAdapter.ADAPTER_CLASS)) != null) {
            adapter.setNotificationEnabled(b);
            if (b) {
                adapter.updateDOM();
            }
        }
    }

    public EMF2DOMAdapter getExistingDOMAdapter(Node node) {
        IDOMNode xNode = (IDOMNode)node;
        return (EMF2DOMSSEAdapter)xNode.getAdapterFor(EMF2DOMAdapter.ADAPTER_CLASS);
    }

    public void removeDOMAdapter(Node aNode, EMF2DOMAdapter anAdapter) {
        ((IDOMNode)aNode).removeAdapter((EMF2DOMSSEAdapter)anAdapter);
    }

    public void replaceDocumentType(String docTypeName, String publicId, String systemId) {
        if (this.document == null) {
            return;
        }
        DocumentTypeImpl docType = (DocumentTypeImpl)this.document.getDoctype();
        if (docType == null) {
            return;
        }
        if (publicId == null && systemId == null) {
            this.document.removeChild(docType);
        } else {
            docType.setPublicId(publicId);
            docType.setSystemId(systemId);
        }
    }

    public boolean useStreamsForIO() {
        return false;
    }

    public void processPostModelEvent(ModelLifecycleEvent event) {
    }

    public void processPreModelEvent(ModelLifecycleEvent event) {
        if (!this.isSaving && event.getType() == 1) {
            ResourceSetWorkbenchEditSynchronizer synchronizer = (ResourceSetWorkbenchEditSynchronizer)((ProjectResourceSet)this.resource.getResourceSet()).getSynchronizer();
            IFile aFile = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
            synchronizer.preSave(aFile);
        }
    }

    public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
    }

    public void modelReinitialized(IStructuredModel structuredModel) {
    }
}

