/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.PreferencesSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WebServiceClientTypeWidget;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.LabelsAndIds;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ServerWizardWidget
extends SimpleWidgetDataContributor {
    private WebServiceClientTypeWidget clientWidget_;
    private PreferencesSelectionWidget preferencesWidget_;
    private Listener statusListener_;
    private TypeRuntimeServer ids_;
    private LabelsAndIds labelIds_;
    private boolean displayPreferences_;
    private String INFOPOP_PWPR_PAGE = "PWPR0001";
    private String INFOPOP_PWPR_CHECKBOX_GENERATE_PROXY = "PWPR0005";
    private Button generateProxy_;
    private String INFOPOP_PWPR_COMBO_TYPE = "PWPR0010";
    private Combo webserviceType_;
    private String INFOPOP_PWPR_GROUP_SCENARIO_SERVICE = "PWPR0011";
    private Button startService_;
    private String INFOPOP_PWPR_CHECKBOX_INSTALL_SERVICE = "PWPR0017";
    private Button installService_;
    private String INFOPOP_PWPR_CHECKBOX_START_WEB_PROJECT = "PWPR0009";
    private String INFOPOP_PWPR_CHECKBOX_TEST_SERVICE = "PWPR0013";
    private Button testService_;
    private String INFOPOP_PWPR_CHECKBOX_MONITOR_SERVICE = "PWPR0014";
    private Button monitorService;
    private String INFOPOP_PWPR_CHECKBOX_LAUNCH_WS = "PWPR0012";
    private Button launchUddi_;

    public ServerWizardWidget(boolean displayPreferences) {
        this.displayPreferences_ = displayPreferences;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        String createPluginId = "org.eclipse.jst.ws.creation.ui";
        UIUtils utils = new UIUtils(createPluginId);
        this.statusListener_ = statusListener;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(pluginId) + "." + this.INFOPOP_PWPR_PAGE);
        Composite serverComposite = utils.createComposite(parent, 1);
        Group serviceGroup = utils.createGroup(serverComposite, ConsumptionUIMessages.GROUP_SCENARIO_SERVICE, ConsumptionUIMessages.TOOLTIP_PWPR_GROUP_SCENARIO_SERVICE, this.INFOPOP_PWPR_GROUP_SCENARIO_SERVICE, 2, 10, 10);
        this.webserviceType_ = utils.createCombo((Composite)serviceGroup, ConsumptionUIMessages.LABEL_WEBSERVICETYPE, ConsumptionUIMessages.TOOLTIP_PWPR_COMBO_TYPE, this.INFOPOP_PWPR_COMBO_TYPE, 2060);
        this.webserviceType_.addListener(24, statusListener);
        Composite buttonsGroup = utils.createComposite((Composite)serviceGroup, 1);
        GridData buttonGrid = new GridData();
        buttonGrid.horizontalSpan = 2;
        buttonsGroup.setLayoutData((Object)buttonGrid);
        this.installService_ = utils.createCheckbox(buttonsGroup, ConsumptionUIMessages.BUTTON_INSTALL_SERVICE_WEB_PROJECT, ConsumptionUIMessages.TOOLTIP_PWPR_CHECKBOX_INSTALL_SERVICE_WEB_PROJECT, this.INFOPOP_PWPR_CHECKBOX_INSTALL_SERVICE);
        this.installService_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ServerWizardWidget.this.handleInstallPressed();
            }
        });
        this.startService_ = utils.createCheckbox(buttonsGroup, ConsumptionUIMessages.BUTTON_START_WEB_PROJECT, ConsumptionUIMessages.TOOLTIP_PWPR_CHECKBOX_START_WEB_PROJECT, this.INFOPOP_PWPR_CHECKBOX_START_WEB_PROJECT);
        this.startService_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ServerWizardWidget.this.handleStartPressed();
            }
        });
        this.launchUddi_ = utils.createCheckbox(buttonsGroup, ConsumptionUIMessages.BUTTON_WS_PUBLISH, ConsumptionUIMessages.TOOLTIP_PWPR_CHECKBOX_LAUNCH_WS, this.INFOPOP_PWPR_CHECKBOX_LAUNCH_WS);
        Composite proxyComposite = utils.createComposite(serverComposite, 1, 5, 0);
        this.generateProxy_ = utils.createCheckbox(proxyComposite, ConsumptionUIMessages.BUTTON_GENERATE_PROXY, ConsumptionUIMessages.TOOLTIP_PWPR_CHECKBOX_GENERATE_PROXY, this.INFOPOP_PWPR_CHECKBOX_GENERATE_PROXY);
        this.generateProxy_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ServerWizardWidget.this.clientWidget_.enableWidget(ServerWizardWidget.this.generateProxy_.getSelection());
            }
        });
        this.clientWidget_ = new WebServiceClientTypeWidget();
        this.clientWidget_.addControls(serverComposite, statusListener);
        Composite testGroup = utils.createComposite(serverComposite, 1);
        this.testService_ = utils.createCheckbox(testGroup, ConsumptionUIMessages.CHECKBOX_TEST_WEBSERVICE, ConsumptionUIMessages.TOOLTIP_PWPR_CHECKBOX_TEST_SERVICE, this.INFOPOP_PWPR_CHECKBOX_TEST_SERVICE);
        this.monitorService = utils.createCheckbox(testGroup, ConsumptionUIMessages.CHECKBOX_MONITOR_WEBSERVICE, ConsumptionUIMessages.TOOLTIP_PWPR_CHECKBOX_MONITOR_SERVICE, this.INFOPOP_PWPR_CHECKBOX_MONITOR_SERVICE);
        if (this.displayPreferences_) {
            this.preferencesWidget_ = new PreferencesSelectionWidget();
            this.preferencesWidget_.addControls(serverComposite, statusListener);
        }
        return this;
    }

    private void handleInstallPressed() {
        boolean enabled = this.installService_.getSelection();
        if (!enabled) {
            this.startService_.setSelection(enabled);
        }
        this.startService_.setEnabled(enabled);
        this.handleStartPressed();
    }

    private void handleStartPressed() {
        boolean enabled = this.startService_.getSelection();
        this.testService_.setEnabled(enabled);
        this.monitorService.setEnabled(enabled);
        this.launchUddi_.setEnabled(enabled);
        this.generateProxy_.setEnabled(enabled);
        this.clientWidget_.enableWidget(this.getGenerateProxy().booleanValue());
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientWidget_.setTypeRuntimeServer(ids);
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.clientWidget_.getTypeRuntimeServer();
    }

    public void setInstallClient(Boolean install) {
        this.clientWidget_.setInstallClient(install);
    }

    public Boolean getInstallClient() {
        return this.clientWidget_.getInstallClient();
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        LabelsAndIds labelIds = WebServiceRuntimeExtensionUtils2.getServiceTypeLabels();
        int selection = 0;
        String[] serviceIds = labelIds.getIds_();
        String selectedId = ids.getTypeId();
        this.webserviceType_.removeListener(24, this.statusListener_);
        this.webserviceType_.setItems(labelIds.getLabels_());
        int index = 0;
        while (index < serviceIds.length) {
            if (selectedId.equals(serviceIds[index])) {
                selection = index;
                break;
            }
            ++index;
        }
        this.webserviceType_.select(selection);
        this.webserviceType_.addListener(24, this.statusListener_);
        this.ids_ = ids;
        this.labelIds_ = labelIds;
    }

    public TypeRuntimeServer getServiceTypeRuntimeServer() {
        int selectionIndex = this.webserviceType_.getSelectionIndex();
        this.ids_.setTypeId(this.labelIds_.getIds_()[selectionIndex]);
        return this.ids_;
    }

    public Boolean getStartService() {
        return new Boolean(this.startService_.getSelection() && this.installService_.getSelection());
    }

    public void setStartService(Boolean value) {
        this.startService_.setSelection(value.booleanValue());
    }

    public Boolean getInstallService() {
        return new Boolean(this.installService_.getSelection());
    }

    public void setInstallService(Boolean value) {
        this.installService_.setSelection(value.booleanValue());
    }

    public Boolean getTestService() {
        return new Boolean(this.testService_.getSelection() && this.startService_.getSelection());
    }

    public void setTestService(Boolean value) {
        this.testService_.setSelection(value.booleanValue());
    }

    public Boolean getMonitorService() {
        return new Boolean(this.monitorService.getSelection() && this.startService_.getSelection());
    }

    public void setMonitorService(Boolean value) {
        this.monitorService.setSelection(value.booleanValue());
    }

    public Boolean getPublishService() {
        return new Boolean(this.launchUddi_.getSelection() && this.startService_.getSelection());
    }

    public void setPublishService(Boolean value) {
        this.launchUddi_.setSelection(value.booleanValue());
    }

    public Boolean getGenerateProxy() {
        return new Boolean(this.generateProxy_.getSelection() && this.startService_.getSelection());
    }

    public void setGenerateProxy(Boolean value) {
        this.generateProxy_.setSelection(value.booleanValue());
    }

    public ResourceContext getResourceContext() {
        return this.preferencesWidget_.getResourceContext();
    }

    public void setResourceContext(ResourceContext context) {
        this.preferencesWidget_.setResourceContext(context);
    }

    public void internalize() {
        this.handleInstallPressed();
        this.handleStartPressed();
    }

    public IStatus getStatus() {
        IStatus status = Status.OK_STATUS;
        if (this.webserviceType_.getText().equals("")) {
            status = StatusUtils.errorStatus((String)"");
        }
        return status;
    }
}

