/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.wizard.J2EEImportPage;
import org.eclipse.jst.servlet.ui.internal.plugin.WEBUIMessages;
import org.eclipse.jst.servlet.ui.internal.wizard.AvailableWebLibProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class WebComponentImportWebLibsPage
extends J2EEImportPage {
    private Button deselectAllButton;
    private Button selectAllButton;
    protected WARFile warFile;
    public CheckboxTableViewer availableJARsViewer;
    public boolean utilJarSelectionChanged = false;

    public WebComponentImportWebLibsPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(WEBUIMessages.WEB_IMPORT_WEB_LIB_PG_TITLE);
        this.setDescription(WEBUIMessages.WEB_IMPORT_WEB_LIB_PG_DESC);
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("import_war_wiz"));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.createAvailableJarsList(composite);
        this.createButtonsGroup(composite);
        return composite;
    }

    protected void updateButtonEnablements() {
        this.utilJarSelectionChanged = true;
    }

    protected void createAvailableJarsList(Composite listGroup) {
        this.availableJARsViewer = CheckboxTableViewer.newCheckList((Composite)listGroup, (int)2816);
        GridData gData = new GridData(1808);
        gData.widthHint = 200;
        gData.heightHint = 80;
        this.availableJARsViewer.getControl().setLayoutData((Object)gData);
        AvailableWebLibProvider libsProvider = new AvailableWebLibProvider();
        this.availableJARsViewer.setContentProvider((IContentProvider)libsProvider);
        this.availableJARsViewer.setLabelProvider((IBaseLabelProvider)libsProvider);
        this.availableJARsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WebComponentImportWebLibsPage.this.availableJARCheckStateChanged(event);
            }
        });
        this.availableJARsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WebComponentImportWebLibsPage.this.updateButtonEnablements();
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.availableJARsViewer.getTable().setLayout((Layout)tableLayout);
        this.availableJARsViewer.getTable().setHeaderVisible(false);
        this.availableJARsViewer.getTable().setLinesVisible(false);
        this.model.addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if (event.getPropertyName().equals("WARImportDataModel.WEB_LIB_ARCHIVES_SELECTED")) {
                    WebComponentImportWebLibsPage.this.availableJARsViewer.setCheckedElements(((List)((DataModelWizardPage)WebComponentImportWebLibsPage.this).model.getProperty("WARImportDataModel.WEB_LIB_ARCHIVES_SELECTED")).toArray());
                }
            }
        });
    }

    private void handleDeselectAllButtonPressed() {
        ArrayList emptySelection = new ArrayList(2);
        this.model.setProperty("WARImportDataModel.WEB_LIB_ARCHIVES_SELECTED", emptySelection);
    }

    private void handleSelectAllButtonPressed() {
        ArrayList<Object> allSelection = new ArrayList<Object>(2);
        Object selection = null;
        int i = 0;
        while ((selection = this.availableJARsViewer.getElementAt(i)) != null) {
            allSelection.add(selection);
            ++i;
        }
        this.model.setProperty("WARImportDataModel.WEB_LIB_ARCHIVES_SELECTED", allSelection);
    }

    protected void createButtonsGroup(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1808));
        this.selectAllButton = new Button(buttonGroup, 8);
        this.selectAllButton.setText(WEBUIMessages.WAR_IMPORT_SELECT_ALL_LIBS_BUTTON);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 1;
        gd.heightHint = 22;
        gd.widthHint = 120;
        this.selectAllButton.setLayoutData((Object)gd);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebComponentImportWebLibsPage.this.handleSelectAllButtonPressed();
            }
        });
        this.deselectAllButton = new Button(buttonGroup, 8);
        this.deselectAllButton.setText(WEBUIMessages.WAR_IMPORT_DESELECT_ALL_LIBS_BUTTON);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = 22;
        gd.widthHint = 120;
        this.deselectAllButton.setLayoutData((Object)gd);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebComponentImportWebLibsPage.this.handleDeselectAllButtonPressed();
            }
        });
    }

    private void refreshEARFileIfNecessary() {
        if (this.isEARFileChanged()) {
            this.warFile = (WARFile)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            this.refresh();
        }
    }

    protected void setJARsCompositeEnabled(boolean enabled) {
        this.availableJARsViewer.getTable().setEnabled(enabled);
        this.availableJARsViewer.setAllChecked(false);
        this.availableJARsViewer.setAllGrayed(!enabled);
        this.selectAllButton.setEnabled(enabled);
        this.deselectAllButton.setEnabled(enabled);
    }

    private void refresh() {
        this.availableJARsViewer.setInput((Object)this.warFile);
    }

    public boolean isEARFileChanged() {
        return this.warFile != this.model.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
    }

    protected void enter() {
        super.enter();
        this.refreshEARFileIfNecessary();
    }

    public void availableJARCheckStateChanged(CheckStateChangedEvent event) {
        this.model.setProperty("WARImportDataModel.WEB_LIB_ARCHIVES_SELECTED", (Object)this.getJARsForProjects());
        this.validatePage();
    }

    public List getJARsForProjects() {
        this.refreshEARFileIfNecessary();
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(this.availableJARsViewer.getCheckedElements()));
        return result;
    }

    protected boolean isNullOrEmpty(String aString) {
        return aString == null || aString.length() == 0;
    }

    protected String[] getValidationPropertyNames() {
        return new String[0];
    }

    protected void restoreWidgetValues() {
    }

    public void storeDefaultSettings() {
    }
}

