/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.wsdl.ui.internal.util.flatui.FlatPageHeader;
import org.eclipse.wst.wsdl.ui.internal.util.flatui.WidgetFactory;
import org.eclipse.wst.wsdl.ui.internal.util.ui.BorderPainter;

public class FlatViewUtility
implements PaintListener {
    Color backgroundColor;
    Color foregroundColor;
    Color comboBackgroundColor;
    Color comboDisabledColor;
    static Color borderColor;
    private boolean headingVisible = true;
    private Image headingImage = null;
    private Composite headerControl = null;
    private int TITLE_VMARGIN = 5;
    private KeyboardHandler keyboardHandler;
    public static final int H_SCROLL_INCREMENT = 5;
    public static final int V_SCROLL_INCREMENT = 64;
    private int flatStyle = 0x800000;
    private int border = 0;
    private static Font font;
    static /* synthetic */ Class class$0;

    public FlatViewUtility() {
        Display display = Display.getCurrent();
        if (borderColor == null) {
            borderColor = new Color((Device)Display.getCurrent(), 195, 191, 179);
        }
        this.backgroundColor = display.getSystemColor(25);
        this.foregroundColor = display.getSystemColor(24);
        this.comboBackgroundColor = display.getSystemColor(25);
        this.comboDisabledColor = display.getSystemColor(22);
        this.keyboardHandler = new KeyboardHandler();
    }

    public FlatViewUtility(boolean isFlat) {
        this();
        this.setFlat(isFlat);
    }

    public void setFlat(boolean flat) {
        Display display = Display.getCurrent();
        if (flat) {
            this.flatStyle = 0x800000;
            this.backgroundColor = display.getSystemColor(25);
            this.foregroundColor = display.getSystemColor(24);
        } else {
            this.flatStyle = 0;
            this.border = 2048;
            this.backgroundColor = display.getSystemColor(22);
            this.foregroundColor = display.getSystemColor(21);
        }
    }

    public void setColor(Control c) {
        if (this.flatStyle == 0x800000) {
            c.setBackground(this.backgroundColor);
        }
    }

    public void paintControl(PaintEvent event) {
        Control c = (Control)event.widget;
        if (!c.isEnabled() && (c instanceof Text || c instanceof List || c instanceof CCombo)) {
            GC gc = event.gc;
            gc.setForeground(this.backgroundColor);
            gc.setForeground(borderColor);
        }
    }

    public static Font getFont() {
        if (font == null) {
            font = new Font((Device)Display.getCurrent(), "ms sans serif", 8, 0);
        }
        return font;
    }

    public static void setFont(Font newFont) {
        font = newFont;
    }

    public static void setComposite(Composite comp) {
    }

    public Composite createSimpleComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style | this.flatStyle);
        composite.setFont(FlatViewUtility.getFont());
        this.setColor((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        return composite;
    }

    public Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, this.flatStyle);
        composite.setFont(FlatViewUtility.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.setColor((Control)composite);
        if (this.flatStyle == 0x800000) {
            composite.addPaintListener((PaintListener)new BorderPainter());
        }
        return composite;
    }

    public Composite createComposite(Composite parent, int numColumns, boolean horizontalFill) {
        if (!horizontalFill) {
            this.createComposite(parent, numColumns);
        }
        Composite composite = new Composite(parent, this.flatStyle);
        composite.setFont(FlatViewUtility.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.setColor((Control)composite);
        if (this.flatStyle == 0x800000) {
            composite.addPaintListener((PaintListener)new BorderPainter());
        }
        return composite;
    }

    public Composite createComposite(Composite parent, int numColumns, boolean horizontalFill, boolean verticalFill) {
        if (!horizontalFill && !verticalFill) {
            this.createComposite(parent, numColumns);
        }
        Composite composite = new Composite(parent, this.flatStyle);
        composite.setFont(FlatViewUtility.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        this.setColor((Control)composite);
        if (this.flatStyle == 0x800000) {
            composite.addPaintListener((PaintListener)new BorderPainter());
        }
        return composite;
    }

    public SashForm createSashForm(Composite parent, int style) {
        SashForm sashForm = new SashForm(parent, style | this.flatStyle);
        this.setColor((Control)sashForm);
        return sashForm;
    }

    public PageBook createPageBook(Composite parent, int style) {
        PageBook pageBook = new PageBook(parent, style | this.flatStyle);
        this.setColor((Control)pageBook);
        if (this.flatStyle == 0x800000) {
            pageBook.addPaintListener((PaintListener)new BorderPainter());
        }
        return pageBook;
    }

    public Label createHeadingLabel(Composite parent, String text, Color bg) {
        return this.createHeadingLabel(parent, text, bg, 0);
    }

    public Label createHeadingLabel(Composite parent, String text, Color bg, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        this.setColor((Control)label);
        if (this.flatStyle == 0x800000) {
            label.setForeground(this.foregroundColor);
        }
        label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return label;
    }

    public Label createHorizontalFiller(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0x4000 | this.flatStyle);
        this.setColor((Control)label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    public Label createLabel(Composite parent, int style, String text) {
        Label label = new Label(parent, style | this.flatStyle);
        this.setColor((Control)label);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0x4000 | this.flatStyle);
        this.setColor((Control)label);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public Label createLabel(Composite parent, String text, int alignment) {
        Label label = new Label(parent, 0x4000 | this.flatStyle);
        label.setText(text);
        this.setColor((Control)label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = alignment;
        label.setLayoutData((Object)data);
        return label;
    }

    public Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8 | this.flatStyle);
        button.setText(label);
        this.setColor((Control)button);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        button.addKeyListener((KeyListener)this.keyboardHandler);
        return button;
    }

    public Table createTable(Composite parent) {
        Table table = new Table(parent, 0x804 | this.flatStyle);
        this.setColor((Control)table);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)data);
        return table;
    }

    public Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 0x10 | this.flatStyle);
        button.setText(label);
        this.setColor((Control)button);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        button.addKeyListener((KeyListener)this.keyboardHandler);
        return button;
    }

    public Button createCheckBox(Composite parent, String label) {
        Button button = new Button(parent, 0x20 | this.flatStyle);
        button.setText(label);
        this.setColor((Control)button);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    public Combo createComboBox(Composite parent) {
        return this.createComboBox(parent, true);
    }

    public Combo createComboBox(Composite parent, boolean isReadOnly) {
        int style = isReadOnly ? 8 : 4;
        Combo combo = new Combo(parent, style | this.flatStyle | this.border);
        this.setColor((Control)combo);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)data);
        return combo;
    }

    public CCombo createCComboBox(Composite parent) {
        return this.createCComboBox(parent, true);
    }

    public CCombo createCComboBox(Composite parent, boolean isReadOnly) {
        int style = isReadOnly ? 8 : 4;
        CCombo combo = new CCombo(parent, style | this.flatStyle | this.border);
        combo.setBackground(this.comboBackgroundColor);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            combo.addPaintListener((PaintListener)this);
        }
        return combo;
    }

    public List createListBox(Composite parent, int width, boolean isMultiSelect) {
        int style = isMultiSelect ? 2 : 4;
        List list = new List(parent, style | this.flatStyle | this.border);
        this.setColor((Control)list);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = width;
        list.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            list.addPaintListener((PaintListener)this);
        }
        return list;
    }

    public List createListBox(Composite parent, int width, boolean isMultiSelect, boolean verticalFill) {
        int style = isMultiSelect ? 2 : 4;
        List list = new List(parent, style | this.flatStyle | this.border);
        this.setColor((Control)list);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = verticalFill;
        data.widthHint = width;
        list.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            list.addPaintListener((PaintListener)this);
        }
        return list;
    }

    public List createListBox(Composite parent, int style) {
        List list = new List(parent, style | this.flatStyle | this.border);
        this.setColor((Control)list);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        list.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            list.addPaintListener((PaintListener)this);
        }
        return list;
    }

    public Text createTextField(Composite parent) {
        Text text = new Text(parent, 4 | this.flatStyle | this.border);
        this.setColor((Control)text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            text.addPaintListener((PaintListener)this);
        }
        text.addKeyListener((KeyListener)this.keyboardHandler);
        return text;
    }

    public Text createTextField(Composite parent, int width) {
        Text text = new Text(parent, 4 | this.flatStyle | this.border);
        this.setColor((Control)text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = width;
        text.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            text.addPaintListener((PaintListener)this);
        }
        text.addKeyListener((KeyListener)this.keyboardHandler);
        return text;
    }

    public Text createTextField(Composite parent, int width, int style) {
        Text text = new Text(parent, style | 4 | this.flatStyle | this.border);
        this.setColor((Control)text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = width;
        text.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            text.addPaintListener((PaintListener)this);
        }
        return text;
    }

    public Text createWrappedMultiTextField(Composite parent, int width, int numLines, boolean verticalFill) {
        Text text = new Text(parent, 0x242 | this.flatStyle | this.border);
        this.setColor((Control)text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (verticalFill) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        data.widthHint = width;
        FontData[] fontData = FlatViewUtility.getFont().getFontData();
        data.heightHint = numLines * fontData[0].getHeight();
        text.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            text.addPaintListener((PaintListener)this);
        }
        return text;
    }

    public Text createMultiTextField(Composite parent, int width, int height, boolean verticalFill) {
        Text text = new Text(parent, 0x302 | this.flatStyle | this.border);
        this.setColor((Control)text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (verticalFill) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        data.widthHint = width;
        data.heightHint = height;
        text.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            text.addPaintListener((PaintListener)this);
        }
        return text;
    }

    public Text createMultiTextField(Composite parent, boolean verticalFill) {
        Text text = new Text(parent, 0x302 | this.flatStyle | this.border);
        this.setColor((Control)text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (verticalFill) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        text.setLayoutData((Object)data);
        if (this.flatStyle == 0x800000) {
            text.addPaintListener((PaintListener)this);
        }
        return text;
    }

    public Group createGroup(Composite parent, int numColumns, String text, boolean verticalFill) {
        Group group = new Group(parent, 0x10 | this.flatStyle);
        group.setText(text);
        this.setColor((Control)group);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (verticalFill) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        if (this.flatStyle == 0x800000) {
            group.addPaintListener((PaintListener)new BorderPainter());
        }
        return group;
    }

    public Group createGroup(Composite parent, int numColumns, String text, boolean verticalFill, int alignment) {
        Group group = new Group(parent, 0x10 | this.flatStyle);
        group.setText(text);
        this.setColor((Control)group);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = alignment;
        if (verticalFill) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        if (this.flatStyle == 0x800000) {
            group.addPaintListener((PaintListener)new BorderPainter());
        }
        return group;
    }

    public Label createVerticalFiller(Composite parent, int verticalSpan) {
        Label label = new Label(parent, 0x4000 | this.flatStyle);
        label.setFont(FlatViewUtility.getFont());
        this.setColor((Control)label);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.verticalSpan = verticalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    public Composite createFlatPageHeader(Composite parent, String title) {
        Image bgImage = this.createDefaultImage();
        return this.createFlatPageHeader(parent, bgImage, title);
    }

    public Composite createFlatPageHeader(Composite parent, Image bgImage, String title) {
        FlatPageHeader header = new FlatPageHeader(parent, 0);
        header.setLayout(new PageLayout());
        header.setBackgroundImage(bgImage);
        header.setText(title);
        WidgetFactory factory = new WidgetFactory();
        Composite formParent = factory.createComposite((Composite)header);
        this.createPageContent(formParent);
        this.headerControl = header;
        return formParent;
    }

    public void updateFlatPageHeaderTitle(String title) {
        ((FlatPageHeader)this.headerControl).setText(title);
    }

    private void createPageContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
    }

    private int getTitleHeight() {
        int imageHeight = 0;
        if (this.headingImage != null && !SWT.getPlatform().equals("motif")) {
            imageHeight = this.headingImage.getBounds().height;
        }
        GC gc = new GC((Drawable)this.headerControl);
        gc.setFont(JFaceResources.getHeaderFont());
        FontMetrics fm = gc.getFontMetrics();
        int fontHeight = fm.getHeight();
        gc.dispose();
        int height = fontHeight + this.TITLE_VMARGIN + this.TITLE_VMARGIN;
        return Math.max(height, imageHeight);
    }

    private Image createDefaultImage() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ImageDescriptor.createFromFile((Class)clazz, (String)"icons/page_banner.gif").createImage();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    class PageLayout
    extends Layout {
        PageLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Control client = composite.getChildren()[0];
            Point csize = client.computeSize(-1, -1, flushCache);
            if (FlatViewUtility.this.headingVisible) {
                csize.y += FlatViewUtility.this.getTitleHeight();
            }
            return csize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            Control client = composite.getChildren()[0];
            int theight = FlatViewUtility.this.headingVisible ? FlatViewUtility.this.getTitleHeight() : 0;
            client.setBounds(clientArea.x, clientArea.y + theight, clientArea.width, clientArea.height - theight);
        }
    }

    public class KeyboardHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            Widget w = e.widget;
            if (w instanceof Control) {
                this.processKey(e.keyCode, (Control)w);
            }
        }

        private void scrollVertical(ScrolledComposite scomp, boolean up) {
            this.scroll(scomp, 0, up ? -64 : 64);
        }

        private void scrollHorizontal(ScrolledComposite scomp, boolean left) {
            this.scroll(scomp, left ? -5 : 5, 0);
        }

        private void scrollPage(ScrolledComposite scomp, boolean up) {
            Rectangle clientArea = scomp.getClientArea();
            int increment = up ? -clientArea.height : clientArea.height;
            this.scroll(scomp, 0, increment);
        }

        private void scroll(ScrolledComposite scomp, int xoffset, int yoffset) {
            Point origin = scomp.getOrigin();
            Point contentSize = scomp.getContent().getSize();
            int xorigin = origin.x + xoffset;
            int yorigin = origin.y + yoffset;
            xorigin = Math.max(xorigin, 0);
            xorigin = Math.min(xorigin, contentSize.x - 1);
            yorigin = Math.max(yorigin, 0);
            yorigin = Math.min(yorigin, contentSize.y - 1);
            scomp.setOrigin(xorigin, yorigin);
        }

        protected ScrolledComposite getScrolledComposite(Control c) {
            Composite parent = c.getParent();
            while (parent != null) {
                if (parent instanceof ScrolledComposite) {
                    return (ScrolledComposite)parent;
                }
                parent = parent.getParent();
            }
            return null;
        }

        protected void processKey(int keyCode, Control c) {
            ScrolledComposite scomp = this.getScrolledComposite(c);
            if (scomp != null) {
                switch (keyCode) {
                    case 0x1000002: {
                        this.scrollVertical(scomp, false);
                        break;
                    }
                    case 0x1000001: {
                        this.scrollVertical(scomp, true);
                        break;
                    }
                    case 0x1000003: {
                        this.scrollHorizontal(scomp, true);
                        break;
                    }
                    case 0x1000004: {
                        this.scrollHorizontal(scomp, false);
                        break;
                    }
                    case 0x1000005: {
                        this.scrollPage(scomp, true);
                        break;
                    }
                    case 0x1000006: {
                        this.scrollPage(scomp, false);
                    }
                }
            }
        }
    }
}

