/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public abstract class BufferedCanvas
extends Canvas {
    private static final boolean USE_DOUBLE_BUFFER = true;
    Image fBuffer;

    public BufferedCanvas(Composite parent, int flags) {
        super(parent, flags + 262144);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                BufferedCanvas.this.doubleBufferPaint(event.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BufferedCanvas.this.fBuffer != null) {
                    BufferedCanvas.this.fBuffer.dispose();
                    BufferedCanvas.this.fBuffer = null;
                }
            }
        });
    }

    public void repaint() {
        if (!this.isDisposed()) {
            GC gc = new GC((Drawable)this);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doubleBufferPaint(GC dest) {
        Point size = this.getSize();
        if (size.x <= 1 || size.y <= 1) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.doPaint(gc);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            gc.dispose();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        gc.dispose();
        dest.drawImage(this.fBuffer, 0, 0);
    }

    public abstract void doPaint(GC var1);
}

