/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.PluginRecord;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.palette.AbstractModelFactory;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;
import org.eclipse.wst.common.snippets.internal.util.CommonXML;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModelFactoryForUser
extends AbstractModelFactory {
    private static ModelFactoryForUser instance = null;

    public static synchronized ModelFactoryForUser getInstance() {
        if (instance == null) {
            instance = new ModelFactoryForUser();
        }
        return instance;
    }

    protected void addCategory(SnippetDefinitions definitions, Element categoryElement) {
        SnippetPaletteDrawer category = this.createCategory(categoryElement);
        if (category != null) {
            this.assignSource(category, definitions, categoryElement);
            String stateString = categoryElement.getAttribute("initial_state");
            int state = 1;
            if (stateString != null && stateString.length() > 0) {
                try {
                    state = Integer.parseInt(stateString);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            category.setInitialState(state);
            definitions.getCategories().add(category);
            if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
                System.out.println("Plugin reader creating category " + category.getId());
            }
            NodeList children = categoryElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child != null && child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase("item")) {
                    this.addChild(definitions, (Element)child);
                }
                ++i;
            }
        }
    }

    protected void addChild(SnippetDefinitions definitions, Element child) {
        SnippetPaletteItem item = this.createItem(child);
        if (item != null) {
            this.assignSource(item, definitions, child);
            definitions.getItems().add(item);
            if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
                System.out.println("Plugin reader creating item " + item.getId());
            }
        }
    }

    protected void assignSource(ISnippetsEntry entry, SnippetDefinitions definitions, Element element) {
        PluginRecord pluginRecord;
        if (entry instanceof ISnippetItem) {
            SnippetPaletteItem item = (SnippetPaletteItem)entry;
            item.setSourceType("USER");
            item.setUserModificationPermission(15);
            pluginRecord = this.createPluginRecord(definitions, element);
            if (pluginRecord != null) {
                item.setSourceDescriptor(pluginRecord);
                ((PaletteEntry)entry).setUserModificationPermission(3);
                item.setSourceType("PLUGINS");
            } else if (element.getAttribute("shared").equals("shared")) {
                item.setSourceType("WORKSPACE");
            }
        }
        if (entry instanceof ISnippetCategory) {
            SnippetPaletteDrawer drawer = (SnippetPaletteDrawer)entry;
            drawer.setSourceType("USER");
            ((PaletteEntry)entry).setUserModificationPermission(15);
            pluginRecord = this.createPluginRecord(definitions, element);
            if (pluginRecord != null) {
                drawer.setSourceDescriptor(pluginRecord);
                ((PaletteEntry)entry).setUserModificationPermission(3);
                drawer.setSourceType("PLUGINS");
            } else if (element.getAttribute("shared").equals("shared")) {
                drawer.setSourceType("WORKSPACE");
            }
        }
    }

    public SnippetPaletteDrawer createCategory(Object source) {
        SnippetPaletteDrawer drawer = super.createCategory(source);
        return drawer;
    }

    protected String createContent(Node item) {
        String content = this.readCDATAofChild(item, "content");
        String systemEOL = System.getProperty("line.separator");
        if (!"\n".equals(systemEOL)) {
            content = StringUtils.replace(content, "\n", systemEOL);
        }
        return content;
    }

    protected String createDescription(Node entryElement) {
        return this.readCDATAofChild(entryElement, "description");
    }

    protected PluginRecord createPluginRecord(SnippetDefinitions definitions, Element element) {
        String pluginName = element.getAttribute("plugin");
        String pluginVersion = element.getAttribute("version");
        PluginRecord record = null;
        if (pluginName.length() > 0 && pluginVersion.length() > 0) {
            record = new PluginRecord();
            record.setPluginName(pluginName);
            record.setPluginVersion(pluginVersion);
        }
        return record;
    }

    protected String[] getDefaultFilters() {
        return new String[]{"*"};
    }

    public String getFilename() {
        String name = null;
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.snippets");
            name = String.valueOf(Platform.getStateLocation((Bundle)bundle).toString()) + "/user.xml";
        }
        catch (Exception exception) {
            name = "/user.xml";
        }
        return name;
    }

    protected String getID(Object source) {
        if (source instanceof Element) {
            return ((Element)source).getAttribute("id");
        }
        return null;
    }

    public SnippetDefinitions load(String filename) {
        SnippetDefinitions definitions = new SnippetDefinitions();
        Document document = null;
        try {
            DocumentBuilder builder = CommonXML.getDocumentBuilder();
            if (builder != null) {
                FileInputStream fis = new FileInputStream(filename);
                document = builder.parse(new InputSource(fis));
            } else {
                Logger.log(4, "Couldn't obtain a DocumentBuilder");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            document = null;
        }
        catch (IOException e) {
            Logger.logException("Could not load user items", e);
            return definitions;
        }
        catch (SAXException e) {
            Logger.logException("Could not load user items", e);
            return definitions;
        }
        if (document == null) {
            return definitions;
        }
        Element library = document.getDocumentElement();
        if (library == null || !library.getNodeName().equals("snippets")) {
            return definitions;
        }
        this.loadDefinitions(definitions, library);
        this.connectItemsAndCategories(definitions);
        return definitions;
    }

    public SnippetDefinitions loadCurrent() {
        return this.load(this.getFilename());
    }

    protected void loadDefinitions(SnippetDefinitions definitions, Node library) {
        NodeList children = library.getChildNodes();
        int length = children.getLength();
        Node child = null;
        int i = 0;
        while (i < length) {
            child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("item")) {
                    this.addChild(definitions, (Element)child);
                } else if (child.getNodeName().equals("category")) {
                    this.addCategory(definitions, (Element)child);
                }
            }
            ++i;
        }
    }

    private Object[] nodesToArray(NodeList list) {
        Object[] objects = new Object[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            objects[i] = list.item(i);
            ++i;
        }
        return objects;
    }

    protected String readCDATAofChild(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(childName)) {
                NodeList descriptionChildren = child.getChildNodes();
                int j = 0;
                while (j < descriptionChildren.getLength()) {
                    Node descriptionChild = descriptionChildren.item(j);
                    if (descriptionChild.getNodeType() == 4) {
                        return descriptionChild.getNodeValue();
                    }
                    ++j;
                }
                return "";
            }
            ++i;
        }
        return "";
    }

    protected void setProperties(SnippetPaletteDrawer category, Object source) {
        if (!(source instanceof Element)) {
            return;
        }
        Element element = (Element)source;
        this.setProperty(category, "smallicon", (Object)element.getAttribute("smallicon"));
        this.setProperty(category, "id", (Object)element.getAttribute("id"));
        this.setProperty(category, "label", (Object)element.getAttribute("label"));
        this.setProperty(category, "largeicon", (Object)element.getAttribute("largeicon"));
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeName().equals("description")) {
                this.setProperty(category, "description", (Object)this.createDescription(element));
            }
            ++i;
        }
        String filtersAttr = element.getAttribute("filters");
        String[] filters = null;
        filters = filtersAttr != null ? StringUtils.asArray(element.getAttribute("filters")) : this.getDefaultFilters();
        this.setProperty(category, "filters", (Object)filters);
    }

    protected void setProperties(SnippetPaletteItem item, Object source) {
        if (!(source instanceof Element)) {
            return;
        }
        Element element = (Element)source;
        this.setProperty(item, "category", (Object)element.getAttribute("category"));
        this.setProperty(item, "class", (Object)element.getAttribute("class"));
        this.setProperty(item, "editorclass", (Object)element.getAttribute("editorclass"));
        this.setProperty(item, "smallicon", (Object)element.getAttribute("smallicon"));
        this.setProperty(item, "id", (Object)element.getAttribute("id"));
        this.setProperty(item, "label", (Object)element.getAttribute("label"));
        this.setProperty(item, "largeicon", (Object)element.getAttribute("largeicon"));
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            ISnippetVariable var;
            if (children.item(i).getNodeName().equals("description")) {
                this.setProperty(item, "description", (Object)this.createDescription(element));
            } else if (children.item(i).getNodeName().equals("content")) {
                this.setProperty(item, "content", (Object)this.createContent(element));
            } else if (children.item(i).getNodeName().equals("variables")) {
                Iterator variables = this.createVariables(this.nodesToArray(children.item(i).getChildNodes())).iterator();
                while (variables.hasNext()) {
                    item.addVariable((ISnippetVariable)variables.next());
                }
            } else if (children.item(i).getNodeName().equals("variable") && (var = this.createVariable(children.item(i))) != null) {
                item.addVariable(var);
            }
            ++i;
        }
    }

    protected void setProperties(SnippetVariable variable, Object source) {
        if (!(source instanceof Element)) {
            return;
        }
        Element element = (Element)source;
        this.setProperty(variable, "default", (Object)element.getAttribute("default"));
        this.setProperty(variable, "description", (Object)element.getAttribute("description"));
        if (variable.getDescription() == null || variable.getDescription().length() == 0) {
            variable.setDescription(this.createDescription(element));
        }
        this.setProperty(variable, "id", (Object)element.getAttribute("id"));
        this.setProperty(variable, "name", (Object)element.getAttribute("name"));
    }
}

