/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.core.editor;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.wst.rdb.data.internal.core.common.Output;
import org.eclipse.wst.rdb.data.internal.core.editor.AbstractRowData;
import org.eclipse.wst.rdb.data.internal.core.editor.ITableData;
import org.eclipse.wst.rdb.data.internal.core.editor.Messages;
import org.eclipse.wst.rdb.data.internal.core.editor.StmtLog;
import org.eclipse.wst.rdb.data.internal.core.editor.TableDataImpl;
import org.eclipse.wst.rdb.data.internal.core.editor.TableDataSaveStatus;

public class RowDataImpl
extends AbstractRowData {
    protected TableDataImpl table;

    public RowDataImpl(TableDataImpl table, int state, Object[] data) {
        super(state, data);
        this.table = table;
    }

    public ITableData getTable() {
        return this.table;
    }

    public void save(TableDataSaveStatus status, Output output) throws SQLException, IOException {
        switch (this.state) {
            case 1: {
                this.doUpdate(status, output);
                break;
            }
            case 3: {
                this.doInsert(status, output);
                break;
            }
            case 2: {
                this.doDelete(status, output);
            }
        }
    }

    protected void doInsert(TableDataSaveStatus status, Output output) throws SQLException, IOException {
        Vector exprs = this.computeValuesClause();
        String q = "insert into " + this.table.getQualifiedTableName();
        q = String.valueOf(q) + this.formatClause("(", this.computeInsertColList(exprs), ", ", ")");
        q = String.valueOf(q) + this.formatClause(" values(", exprs, ", ", ")");
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        StmtLog stmtLog = new StmtLog(q);
        this.setValuesClauseArguments(pst, stmtLog);
        output.write(stmtLog.toString());
        pst.executeUpdate();
        pst.close();
        ++status.inserted;
    }

    protected Vector computeInsertColList(Vector exprs) {
        Vector<String> cols = new Vector<String>();
        int i = 0;
        while (i < exprs.size()) {
            if (exprs.elementAt(i) != null) {
                cols.add(this.table.getQuotedColumnName(i));
            }
            ++i;
        }
        if (cols.size() == this.table.getColumnCount()) {
            return new Vector();
        }
        return cols;
    }

    protected void doUpdate(TableDataSaveStatus status, Output output) throws SQLException, IOException {
        String q = "update " + this.table.getQualifiedTableName();
        q = String.valueOf(q) + this.formatClause(" set ", this.computeSetClause(), ", ", "");
        q = String.valueOf(q) + this.formatClause(" where ", this.computeWhereClause(), " and ", "");
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        StmtLog stmtLog = new StmtLog(q);
        this.setSetClauseArguments(pst, stmtLog);
        this.setWhereClauseArguments(pst, stmtLog);
        output.write(stmtLog.toString());
        int n = pst.executeUpdate();
        pst.close();
        status.updated += n;
        if (n != 1) {
            status.duplicateRow = true;
        }
    }

    protected void doDelete(TableDataSaveStatus status, Output output) throws SQLException, IOException {
        String q = "delete from " + this.table.getQualifiedTableName();
        q = String.valueOf(q) + this.formatClause(" where ", this.computeWhereClause(), " and ", "");
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        StmtLog stmtLog = new StmtLog(q);
        this.setWhereClauseArguments(pst, stmtLog);
        output.write(stmtLog.toString());
        int n = pst.executeUpdate();
        pst.close();
        status.deleted += n;
        if (n != 1) {
            status.duplicateRow = true;
        }
    }

    public void doRefresh(int col, boolean snippet) throws SQLException, IOException, Exception {
        if (this.state == 3) {
            return;
        }
        String q = "select " + this.table.getQuotedColumnName(col);
        q = String.valueOf(q) + " from " + this.table.getQualifiedTableName();
        q = String.valueOf(q) + this.formatClause(" where ", this.computeWhereClause(), " and ", "");
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        StmtLog stmtLog = new StmtLog(q);
        this.setWhereClauseArguments(pst, stmtLog);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            Object o = this.table.getColumnDataAccessor(col).read(rs, 0, this.table.getColumnType(col), snippet);
            if (this.newData[col] == this.oldData[col]) {
                this.newData[col] = o;
            }
            this.oldData[col] = o;
            if (rs.next()) {
                throw new Exception(String.valueOf(stmtLog.toString()) + Messages.getString("RowDataImpl.refreshTooManyRows"));
            }
        } else {
            throw new Exception(String.valueOf(stmtLog.toString()) + Messages.getString("RowDataImpl.RefreshNoRow"));
        }
        rs.close();
        pst.close();
    }

    protected Vector computeValuesClause() {
        Vector<String> exprs = new Vector<String>();
        int col = 0;
        while (col < this.newData.length) {
            exprs.add(this.table.getColumnDataAccessor(col).getValuesExpr(this.newData[col]));
            ++col;
        }
        return exprs;
    }

    protected void setValuesClauseArguments(PreparedStatement pst, StmtLog stmtLog) throws SQLException, IOException {
        int col = 0;
        while (col < this.newData.length) {
            String[] args = this.table.getColumnDataAccessor(col).writeValuesExprArgs(pst, stmtLog.getArgsCount(), this.newData[col], this.table.getColumnType(col));
            stmtLog.addArgs(args);
            ++col;
        }
    }

    protected Vector computeSetClause() {
        Vector<String> assignments = new Vector<String>();
        int col = 0;
        while (col < this.newData.length) {
            if (this.oldData[col] != this.newData[col]) {
                assignments.add(this.table.getColumnDataAccessor(col).getSetAss(this.newData[col]));
            }
            ++col;
        }
        return assignments;
    }

    protected void setSetClauseArguments(PreparedStatement pst, StmtLog stmtLog) throws SQLException, IOException {
        int col = 0;
        while (col < this.newData.length) {
            if (this.oldData[col] != this.newData[col]) {
                String[] args = this.table.getColumnDataAccessor(col).writeSetAssArgs(pst, stmtLog.getArgsCount(), this.newData[col], this.table.getColumnType(col));
                stmtLog.addArgs(args);
            }
            ++col;
        }
    }

    protected Vector computeWhereClause() {
        Vector<String> conds = new Vector<String>();
        int[] keyColumns = this.table.getKeyColumns();
        int i = 0;
        while (i < keyColumns.length) {
            conds.add(this.table.getColumnDataAccessor(keyColumns[i]).getWhereCond(this.oldData[keyColumns[i]]));
            ++i;
        }
        return conds;
    }

    protected void setWhereClauseArguments(PreparedStatement pst, StmtLog stmtLog) throws SQLException, IOException {
        int[] keyColumns = this.table.getKeyColumns();
        int i = 0;
        while (i < keyColumns.length) {
            int col = keyColumns[i];
            String[] args = this.table.getColumnDataAccessor(col).writeWhereCondArgs(pst, stmtLog.getArgsCount(), this.oldData[col], this.table.getColumnType(col));
            stmtLog.addArgs(args);
            ++i;
        }
    }

    protected String formatClause(String start, Vector elements, String sep, String end) {
        StringBuffer sb = new StringBuffer();
        sb.append(start);
        boolean first = true;
        int i = 0;
        while (i < elements.size()) {
            String s = (String)elements.elementAt(i);
            if (s != null) {
                if (!first) {
                    sb.append(sep);
                }
                sb.append(s);
                first = false;
            }
            ++i;
        }
        if (first) {
            return "";
        }
        sb.append(end);
        return sb.toString();
    }
}

