/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationConstants;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public final class ConfigurationManager
implements ConfigurationConstants {
    private static ConfigurationManager inst = null;

    private ConfigurationManager() {
    }

    public static ConfigurationManager getManager() {
        if (inst == null) {
            inst = new ConfigurationManager();
        }
        return inst;
    }

    public String getValidator(IMarker marker) {
        Object attrib;
        block7: {
            block6: {
                if (marker == null) {
                    return null;
                }
                try {
                    if (marker.getType().equals("org.eclipse.wst.validation.problemmarker")) break block6;
                    return null;
                }
                catch (CoreException exc) {
                    Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceIdentifier("InternalPreferenceManager.getValidator(IMarker)");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    return null;
                }
            }
            attrib = marker.getAttribute("owner");
            if (attrib != null) break block7;
            return null;
        }
        return attrib.toString();
    }

    public boolean isValidationMarker(IMarker marker) {
        if (marker == null) {
            return false;
        }
        try {
            return marker.getType().equals("org.eclipse.wst.validation.problemmarker");
        }
        catch (CoreException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("InternalPreferenceManager.isValidationMarker(IMarker)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return false;
        }
    }

    public void removeAllValidationMarkers(IProject project) {
        block3: {
            if (project == null || !project.isOpen()) {
                return;
            }
            try {
                project.deleteMarkers("org.eclipse.wst.validation.problemmarker", false, 2);
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("WorkbenchMonitor.removeAllValidationMarkers(IProject)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public GlobalConfiguration getGlobalConfiguration() throws InvocationTargetException {
        IWorkspaceRoot root = ValidationConfiguration.getRoot();
        GlobalConfiguration gp = null;
        try {
            gp = (GlobalConfiguration)root.getSessionProperty(USER_PREFERENCE);
            if (gp == null) {
                gp = new GlobalConfiguration(root);
                gp.getVersion();
                gp.load();
                gp.passivate();
            }
            return gp;
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{root.getName()}));
        }
    }

    public ProjectConfiguration getProjectConfiguration(IProject project) throws InvocationTargetException {
        ProjectConfiguration prjp = null;
        try {
            prjp = (ProjectConfiguration)project.getSessionProperty(USER_PREFERENCE);
            if (prjp == null || !prjp.getResource().exists()) {
                prjp = new ProjectConfiguration(project);
                prjp.getVersion();
                prjp.load();
                prjp.passivate();
            }
            return prjp;
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{project.getName()}));
        }
    }

    public ProjectConfiguration getProjectConfigurationWithoutMigrate(IProject project) throws InvocationTargetException {
        ProjectConfiguration prjp = null;
        try {
            prjp = (ProjectConfiguration)project.getSessionProperty(USER_PREFERENCE);
            if (prjp == null || !prjp.getResource().exists()) {
                prjp = new ProjectConfiguration(project);
                prjp.getVersion();
                prjp.load();
                prjp.passivate();
            }
            return prjp;
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{project.getName()}));
        }
    }

    public void resetProjectNature(IProject project) throws InvocationTargetException {
        this.resetProjectNature(this.getProjectConfiguration(project));
    }

    protected void resetProjectNature(ProjectConfiguration prjp) throws InvocationTargetException {
        prjp.resetProjectNature();
    }

    public void closing(IProject project) {
        block3: {
            try {
                if (this.isMigrated(project)) {
                    ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                    prjp.store();
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("InternalPreferenceManager::closing(" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block3;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public void deleting(IProject project) {
    }

    public void opening(IProject project) {
    }

    public boolean isGlobalMigrated() throws InvocationTargetException {
        IWorkspaceRoot root = ValidationConfiguration.getRoot();
        if (root == null) {
            return false;
        }
        try {
            GlobalConfiguration gp = (GlobalConfiguration)root.getSessionProperty(USER_PREFERENCE);
            if (gp != null) {
                return gp.isVersionCurrent();
            }
            String serializedPrjp = root.getPersistentProperty(USER_PREFERENCE);
            if (serializedPrjp != null) {
                gp = new GlobalConfiguration(root);
                gp.getVersion();
                return gp.isVersionCurrent();
            }
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{root.getName()}));
        }
        return false;
    }

    public boolean isMigrated(IProject project) throws InvocationTargetException {
        if (project == null) {
            return false;
        }
        try {
            if (project.isAccessible()) {
                ProjectConfiguration prjp = (ProjectConfiguration)project.getSessionProperty(USER_PREFERENCE);
                if (prjp != null) {
                    return prjp.isVersionCurrent();
                }
                String serializedPrjp = project.getPersistentProperty(USER_PREFERENCE);
                if (serializedPrjp != null) {
                    prjp = new ProjectConfiguration(project);
                    prjp.getVersion();
                    return prjp.isVersionCurrent();
                }
            }
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{project.getName()}));
        }
        return false;
    }
}

