/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.NotificationManager;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.AliasManager;
import org.eclipse.core.internal.resources.CharsetManager;
import org.eclipse.core.internal.resources.ComputeProjectOrder;
import org.eclipse.core.internal.resources.ContentDescriptionManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.NatureManager;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.internal.resources.PathVariableManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ResourcesCompatibilityHelper;
import org.eclipse.core.internal.resources.RootInfo;
import org.eclipse.core.internal.resources.Rules;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspacePreferences;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.StringPoolJob;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceLock;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.TeamHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;

public class Workspace
extends PlatformObject
implements IWorkspace,
ICoreConstants {
    public static boolean DEBUG = false;
    protected static final String REFRESH_ON_STARTUP = "-refresh";
    protected WorkspacePreferences description;
    protected LocalMetaArea localMetaArea;
    protected boolean openFlag = false;
    protected ElementTree tree;
    protected ElementTree operationTree;
    protected SaveManager saveManager;
    protected BuildManager buildManager;
    protected NatureManager natureManager;
    protected NotificationManager notificationManager;
    protected FileSystemResourceManager fileSystemManager;
    protected PathVariableManager pathVariableManager;
    protected IPropertyManager propertyManager;
    protected MarkerManager markerManager;
    protected ContentDescriptionManager contentDescriptionManager;
    protected WorkManager _workManager;
    protected AliasManager aliasManager;
    protected CharsetManager charsetManager;
    protected RefreshManager refreshManager;
    protected long nextNodeId = 1L;
    protected long nextMarkerId = 0L;
    protected Synchronizer synchronizer;
    protected IProject[] buildOrder = null;
    protected IWorkspaceRoot defaultRoot = new WorkspaceRoot((IPath)Path.ROOT, this);
    protected final HashSet lifecycleListeners = new HashSet(10);
    private IResourceRuleFactory ruleFactory;
    protected boolean shouldValidate = true;
    protected IFileModificationValidator validator = null;
    protected IMoveDeleteHook moveDeleteHook = null;
    protected TeamHook teamHook = null;
    protected Thread treeLocked = null;
    protected boolean crashed = false;
    private StringPoolJob stringPoolJob;

    public Workspace() {
        this.localMetaArea = new LocalMetaArea();
        this.tree = new ElementTree();
        this.tree.immutable();
        this.treeLocked = Thread.currentThread();
        this.tree.setTreeData(this.newElement(8));
    }

    protected void aboutToBuild(Object source, int trigger) {
        this.broadcastPostChange();
        this.broadcastBuildEvent(source, 8, trigger);
    }

    public void addLifecycleListener(ILifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    public void addResourceChangeListener(IResourceChangeListener listener) {
        this.notificationManager.addListener(listener, 7);
    }

    public void addResourceChangeListener(IResourceChangeListener listener, int eventMask) {
        this.notificationManager.addListener(listener, eventMask);
    }

    public ISavedState addSaveParticipant(Plugin plugin, ISaveParticipant participant) throws CoreException {
        Assert.isNotNull(plugin, "Plugin must not be null");
        Assert.isNotNull(participant, "Participant must not be null");
        return this.saveManager.addParticipant(plugin, participant);
    }

    public void beginOperation(boolean createNewTree) throws CoreException {
        WorkManager workManager = this.getWorkManager();
        workManager.incrementNestedOperations();
        if (!workManager.isBalanced()) {
            Assert.isTrue(false, "Operation was not prepared.");
        }
        if (workManager.getPreparedOperationDepth() > 1) {
            if (createNewTree && this.tree.isImmutable()) {
                this.newWorkingTree();
            }
            return;
        }
        this.operationTree = this.tree;
        if (createNewTree && this.tree.isImmutable()) {
            this.newWorkingTree();
        }
    }

    public void broadcastPostChange() {
        ResourceChangeEvent event = new ResourceChangeEvent(this, 1, 0, null);
        this.notificationManager.broadcastChanges(this.tree, event, true);
    }

    public void broadcastBuildEvent(Object source, int type, int buildTrigger) {
        ResourceChangeEvent event = new ResourceChangeEvent(source, type, buildTrigger, null);
        this.notificationManager.broadcastChanges(this.tree, event, false);
    }

    protected void broadcastEvent(LifecycleEvent event) throws CoreException {
        Iterator it = this.lifecycleListeners.iterator();
        while (it.hasNext()) {
            ILifecycleListener listener = (ILifecycleListener)it.next();
            listener.handleEvent(event);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(int trigger, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        ISchedulingRule rule = this.getRuleFactory().buildRule();
        try {
            monitor.beginTask(null, Policy.opWork);
            try {
                this.prepareOperation(rule, monitor);
                this.beginOperation(true);
                this.aboutToBuild(this, trigger);
                this.getBuildManager().build(trigger, Policy.subMonitorFor(monitor, Policy.opWork));
                this.broadcastBuildEvent(this, 16, trigger);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.tree.isImmutable()) {
                    this.newWorkingTree();
                }
                this.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (this.tree.isImmutable()) {
                    this.newWorkingTree();
                }
                this.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        monitor.done();
    }

    private boolean canCreateExtensions() {
        return Platform.getBundle((String)"org.eclipse.osgi").getState() != 16;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkpoint(boolean build) {
        try {
            ISchedulingRule rule = this.getWorkManager().getNotifyRule();
            try {
                this.prepareOperation(rule, null);
                this.beginOperation(true);
                this.broadcastPostChange();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.endOperation(rule, build, null);
                throw throwable;
            }
            {
                Object var3_6 = null;
                this.endOperation(rule, build, null);
                return;
            }
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }

    public static boolean clear(java.io.File root) {
        boolean result = Workspace.clearChildren(root);
        try {
            if (root.exists()) {
                result &= root.delete();
            }
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    public static boolean clearChildren(java.io.File root) {
        String[] list;
        boolean result = true;
        if (root.isDirectory() && (list = root.list()) != null) {
            int i = 0;
            while (i < list.length) {
                result &= Workspace.clear(new java.io.File(root, list[i]));
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(IProgressMonitor monitor) throws CoreException {
        if (!this.isOpen()) {
            return;
        }
        monitor = Policy.monitorFor(monitor);
        try {
            String msg = Messages.resources_closing_0;
            int rootCount = this.tree.getChildCount((IPath)Path.ROOT);
            monitor.beginTask(msg, rootCount + 2);
            monitor.subTask(msg);
            try {
                if (this.stringPoolJob != null) {
                    this.stringPoolJob.cancel();
                }
                this.saveManager.shutdown(null);
                this.prepareOperation(this.getRoot(), monitor);
                this.notificationManager.shutdown(null);
                this.beginOperation(true);
                IProject[] projects = this.getRoot().getProjects();
                int i = 0;
                while (true) {
                    block9: {
                        if (i < projects.length) break block9;
                        this.deleteResource(this.getRoot());
                        this.openFlag = false;
                        break;
                    }
                    this.broadcastEvent(LifecycleEvent.newEvent(1, projects[i]));
                    monitor.worked(1);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.shutdown(Policy.subMonitorFor(monitor, 2, 2));
                throw throwable;
            }
            {
                Object var6_8 = null;
                this.shutdown(Policy.subMonitorFor(monitor, 2, 2));
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Platform.getJobManager().endRule((ISchedulingRule)this.getRoot());
            monitor.done();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        Platform.getJobManager().endRule((ISchedulingRule)this.getRoot());
        monitor.done();
    }

    public IProject[][] computePrerequisiteOrder(IProject[] targets) {
        return this.computePrerequisiteOrder1(targets);
    }

    private IProject[][] computePrerequisiteOrder1(IProject[] projects) {
        IProject project;
        IWorkspace.ProjectOrder r = this.computeProjectOrder(projects);
        if (!r.hasCycles) {
            return new IProject[][]{r.projects, new IProject[0]};
        }
        HashSet<IProject> bad = new HashSet<IProject>();
        HashSet<IProject> keepers = new HashSet<IProject>(Arrays.asList(r.projects));
        int i = 0;
        while (i < r.knots.length) {
            IProject[] knot = r.knots[i];
            int j = 0;
            while (j < knot.length) {
                project = knot[j];
                if (keepers.contains(project)) {
                    bad.add(project);
                }
                ++j;
            }
            ++i;
        }
        IProject[] result2 = new IProject[bad.size()];
        bad.toArray(result2);
        LinkedList<IProject> p = new LinkedList<IProject>();
        p.addAll(Arrays.asList(r.projects));
        ListIterator it = p.listIterator();
        while (it.hasNext()) {
            project = (IProject)it.next();
            if (!bad.contains(project)) continue;
            it.remove();
        }
        IProject[] result1 = new IProject[p.size()];
        p.toArray(result1);
        return new IProject[][]{result1, result2};
    }

    public IWorkspace.ProjectOrder computeProjectOrder(IProject[] projects) {
        IWorkspace.ProjectOrder fullProjectOrder = this.computeFullProjectOrder();
        int accessibleCount = 0;
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                ++accessibleCount;
            }
            ++i;
        }
        if (accessibleCount == fullProjectOrder.projects.length) {
            return fullProjectOrder;
        }
        HashSet<IProject> keepers = new HashSet<IProject>(Arrays.asList(projects));
        ArrayList<IProject> reducedProjects = new ArrayList<IProject>(fullProjectOrder.projects.length);
        int i2 = 0;
        while (i2 < fullProjectOrder.projects.length) {
            IProject project = fullProjectOrder.projects[i2];
            if (keepers.contains(project)) {
                reducedProjects.add(project);
            }
            ++i2;
        }
        IProject[] p1 = new IProject[reducedProjects.size()];
        reducedProjects.toArray(p1);
        ArrayList<IProject[]> reducedKnots = new ArrayList<IProject[]>(fullProjectOrder.knots.length);
        int i3 = 0;
        while (i3 < fullProjectOrder.knots.length) {
            IProject[] knot = fullProjectOrder.knots[i3];
            ArrayList<IProject> x = new ArrayList<IProject>(knot.length);
            int j = 0;
            while (j < knot.length) {
                IProject project = knot[j];
                if (keepers.contains(project)) {
                    x.add(project);
                }
                ++j;
            }
            if (x.size() > 1) {
                reducedKnots.add(x.toArray(new IProject[x.size()]));
            }
            ++i3;
        }
        IProject[][] k1 = new IProject[reducedKnots.size()][];
        reducedKnots.toArray((T[])k1);
        return new IWorkspace.ProjectOrder(p1, k1.length > 0, k1);
    }

    private IWorkspace.ProjectOrder computeFullProjectOrder() {
        TreeSet<Project> allAccessibleProjects = new TreeSet<Project>(new Comparator(){

            public int compare(Object x, Object y) {
                IProject px = (IProject)x;
                IProject py = (IProject)y;
                return py.getName().compareTo(px.getName());
            }
        });
        IProject[] allProjects = this.getRoot().getProjects();
        ArrayList<IProject[]> edges = new ArrayList<IProject[]>(allProjects.length);
        int i = 0;
        while (i < allProjects.length) {
            ProjectDescription desc;
            Project project = (Project)allProjects[i];
            if (project.isAccessible() && (desc = project.internalGetDescription()) != null) {
                IProject[] refs = desc.getAllReferences(false);
                allAccessibleProjects.add(project);
                int j = 0;
                while (j < refs.length) {
                    IProject ref = refs[j];
                    if (ref.isAccessible() && !ref.equals(project)) {
                        edges.add(new IProject[]{project, ref});
                    }
                    ++j;
                }
            }
            ++i;
        }
        IWorkspace.ProjectOrder fullProjectOrder = ComputeProjectOrder.computeProjectOrder(allAccessibleProjects, edges);
        return fullProjectOrder;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus copy(IResource[] resources, IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        IStatus iStatus;
        block22: {
            IStatus iStatus2;
            block20: {
                monitor = Policy.monitorFor(monitor);
                try {
                    int opWork = Math.max(resources.length, 1);
                    int totalWork = 100 * opWork / Policy.opWork;
                    String message = Messages.resources_copying_0;
                    monitor.beginTask(message, totalWork);
                    Assert.isLegal(resources != null);
                    if (resources.length == 0) {
                        iStatus2 = Status.OK_STATUS;
                        Object var17_10 = null;
                        break block20;
                    }
                    resources = (IResource[])resources.clone();
                    IPath parentPath = null;
                    message = Messages.resources_copyProblem;
                    MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, message, null);
                    try {
                        try {
                            this.prepareOperation(this.getRoot(), monitor);
                            this.beginOperation(true);
                            int i = 0;
                            while (i < resources.length) {
                                block21: {
                                    Policy.checkCanceled(monitor);
                                    IResource resource = resources[i];
                                    if (resource == null || Workspace.isDuplicate(resources, i)) {
                                        monitor.worked(1);
                                    } else {
                                        if (parentPath == null) {
                                            parentPath = resource.getFullPath().removeLastSegments(1);
                                        }
                                        if (parentPath.equals((Object)resource.getFullPath().removeLastSegments(1))) {
                                            try {
                                                IPath destinationPath = destination.append(resource.getName());
                                                IStatus requirements = ((Resource)resource).checkCopyRequirements(destinationPath, resource.getType(), updateFlags);
                                                if (requirements.isOK()) {
                                                    try {
                                                        resource.copy(destinationPath, updateFlags, Policy.subMonitorFor(monitor, 1));
                                                    }
                                                    catch (CoreException e) {
                                                        status.merge(e.getStatus());
                                                    }
                                                    break block21;
                                                }
                                                monitor.worked(1);
                                                status.merge(requirements);
                                            }
                                            catch (CoreException e) {
                                                monitor.worked(1);
                                                status.merge(e.getStatus());
                                            }
                                        } else {
                                            monitor.worked(1);
                                            message = NLS.bind((String)Messages.resources_notChild, (Object)resources[i].getFullPath(), (Object)parentPath);
                                            status.merge((IStatus)new ResourceStatus(76, resources[i].getFullPath(), message));
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (OperationCanceledException e) {
                            this.getWorkManager().operationCanceled();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_23 = null;
                        this.endOperation(this.getRoot(), true, Policy.subMonitorFor(monitor, totalWork - opWork));
                        throw throwable;
                    }
                    {
                        Object var15_24 = null;
                    }
                    this.endOperation(this.getRoot(), true, Policy.subMonitorFor(monitor, totalWork - opWork));
                    if (status.matches(4)) {
                        throw new ResourceException((IStatus)status);
                    }
                    iStatus = status.isOK() ? Status.OK_STATUS : status;
                    break block22;
                }
                catch (Throwable throwable) {
                    Object var17_12 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return iStatus2;
        }
        Object var17_11 = null;
        monitor.done();
        return iStatus;
    }

    public IStatus copy(IResource[] resources, IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        return this.copy(resources, destination, updateFlags, monitor);
    }

    protected void copyTree(IResource source, IPath destination, int depth, int updateFlags, boolean keepSyncInfo) throws CoreException {
        IResource destinationResource = this.getRoot().findMember(destination, true);
        if (destinationResource == null) {
            int destinationType = source.getType() == 1 ? 1 : (destination.segmentCount() == 1 ? 4 : 2);
            destinationResource = this.newResource(destination, destinationType);
        }
        ResourceInfo sourceInfo = ((Resource)source).getResourceInfo(true, false);
        if (destinationResource.getType() != source.getType()) {
            sourceInfo = (ResourceInfo)sourceInfo.clone();
            sourceInfo.setType(destinationResource.getType());
        }
        ResourceInfo newInfo = this.createResource(destinationResource, sourceInfo, false, false, keepSyncInfo);
        long nodeid = ((Resource)source).getResourceInfo(true, false).getNodeId();
        newInfo.setNodeId(nodeid);
        ResourceInfo oldInfo = ((Resource)source).getResourceInfo(true, false);
        newInfo.setFlags(newInfo.getFlags() | oldInfo.getFlags() & 2);
        newInfo.clear(393216);
        if (source.isLinked()) {
            LinkDescription linkDescription;
            if ((updateFlags & 0x20) != 0) {
                newInfo.set(65536);
                linkDescription = new LinkDescription(destinationResource, source.getRawLocation());
            } else {
                newInfo.clear(65536);
                linkDescription = null;
            }
            Project project = (Project)destinationResource.getProject();
            project.internalGetDescription().setLinkLocation(destinationResource.getName(), linkDescription);
            project.writeDescription(updateFlags);
        }
        if (depth == 0 || source.getType() == 1) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = ((IContainer)source).members(2);
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            IPath childPath = destination.append(child.getName());
            this.copyTree(child, childPath, depth, updateFlags, keepSyncInfo);
            ++i;
        }
    }

    public int countResources(IPath root, int depth, final boolean phantom) {
        if (!this.tree.includes(root)) {
            return 0;
        }
        switch (depth) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1 + this.tree.getChildCount(root);
            }
            case 2: {
                final int[] count = new int[1];
                IElementContentVisitor visitor = new IElementContentVisitor(){

                    public boolean visitElement(ElementTree aTree, IPathRequestor requestor, Object elementContents) {
                        if (phantom || !((ResourceInfo)elementContents).isSet(8)) {
                            count[0] = count[0] + 1;
                        }
                        return true;
                    }
                };
                new ElementTreeIterator(this.tree, root).iterate(visitor);
                return count[0];
            }
        }
        return 0;
    }

    public ResourceInfo createResource(IResource resource, ResourceInfo info, boolean phantom, boolean overwrite, boolean keepSyncInfo) throws CoreException {
        info = info == null ? this.newElement(resource.getType()) : (ResourceInfo)info.clone();
        ResourceInfo original = this.getResourceInfo(resource.getFullPath(), true, false);
        if (phantom) {
            info.set(8);
            info.clearModificationStamp();
        }
        if (original == null) {
            if (!keepSyncInfo) {
                info.setSyncInfo(null);
            }
            this.tree.createElement(resource.getFullPath(), info);
        } else if (overwrite || !phantom && original.isSet(8)) {
            if (!keepSyncInfo) {
                info.setSyncInfo(original.getSyncInfo(true));
            }
            info.set(4096);
            this.tree.setElementData(resource.getFullPath(), info);
        } else {
            String message = NLS.bind((String)Messages.resources_mustNotExist, (Object)resource.getFullPath());
            throw new ResourceException(367, resource.getFullPath(), message, null);
        }
        return info;
    }

    public ResourceInfo createResource(IResource resource, boolean phantom) throws CoreException {
        return this.createResource(resource, null, phantom, false, false);
    }

    public static WorkspaceDescription defaultWorkspaceDescription() {
        return new WorkspaceDescription("Workspace");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus delete(IResource[] resources, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            int opWork = Math.max(resources.length, 1);
            int totalWork = 100 * opWork / Policy.opWork;
            String message = Messages.resources_deleting_0;
            monitor.beginTask(message, totalWork);
            message = Messages.resources_deleteProblem;
            MultiStatus result = new MultiStatus("org.eclipse.core.resources", 566, message, null);
            if (resources.length == 0) {
                MultiStatus multiStatus = result;
                Object var15_9 = null;
                monitor.done();
                return multiStatus;
            }
            resources = (IResource[])resources.clone();
            try {
                this.prepareOperation(this.getRoot(), monitor);
                this.beginOperation(true);
                int i = 0;
                while (true) {
                    block14: {
                        if (i >= resources.length) {
                            if (!result.matches(4)) break;
                            throw new ResourceException((IStatus)result);
                        }
                        Policy.checkCanceled(monitor);
                        Resource resource = (Resource)resources[i];
                        if (resource == null) {
                            monitor.worked(1);
                        } else {
                            try {
                                resource.delete(updateFlags, Policy.subMonitorFor(monitor, 1));
                            }
                            catch (CoreException e) {
                                ResourceInfo info = resource.getResourceInfo(false, false);
                                if (!resource.exists(resource.getFlags(info), false)) break block14;
                                message = NLS.bind((String)Messages.resources_couldnotDelete, (Object)resource.getFullPath());
                                result.merge((IStatus)new ResourceStatus(273, resource.getFullPath(), message));
                                result.merge(e.getStatus());
                            }
                        }
                    }
                    ++i;
                }
                MultiStatus multiStatus = result;
                Object var12_18 = null;
                this.endOperation(this.getRoot(), true, Policy.subMonitorFor(monitor, totalWork - opWork));
                Object var15_10 = null;
                monitor.done();
                return multiStatus;
            }
            catch (OperationCanceledException e) {
                this.getWorkManager().operationCanceled();
                throw e;
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                this.endOperation(this.getRoot(), true, Policy.subMonitorFor(monitor, totalWork - opWork));
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var15_11 = null;
            monitor.done();
            throw throwable;
        }
    }

    public IStatus delete(IResource[] resources, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        return this.delete(resources, updateFlags |= 2, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteMarkers(IMarker[] markers) throws CoreException {
        Assert.isNotNull(markers);
        if (markers.length == 0) {
            return;
        }
        markers = (IMarker[])markers.clone();
        try {
            this.prepareOperation(null, null);
            this.beginOperation(true);
            int i = 0;
            while (i < markers.length) {
                if (markers[i] != null && markers[i].getResource() != null) {
                    this.markerManager.removeMarker(markers[i].getResource(), markers[i].getId());
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.endOperation(null, false, null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.endOperation(null, false, null);
    }

    void deleteResource(IResource resource) {
        IPath path = resource.getFullPath();
        if (path.equals((Object)Path.ROOT)) {
            IProject[] children = this.getRoot().getProjects();
            int i = 0;
            while (i < children.length) {
                this.tree.deleteElement(children[i].getFullPath());
                ++i;
            }
        } else {
            this.tree.deleteElement(path);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endOperation(ISchedulingRule rule, boolean build, IProgressMonitor monitor) throws CoreException {
        WorkManager workManager = this.getWorkManager();
        if (workManager.checkInFailed(rule)) {
            return;
        }
        boolean hasTreeChanges = false;
        boolean depthOne = false;
        try {
            workManager.setBuild(build);
            boolean bl = depthOne = workManager.getPreparedOperationDepth() == 1;
            if (!this.notificationManager.shouldNotify() && !depthOne) {
                this.notificationManager.requestNotify();
                Object var9_7 = null;
                workManager.checkOut(rule);
                return;
            }
            try {
                this.notificationManager.beginNotify();
                Assert.isTrue(workManager.getPreparedOperationDepth() > 0, "Mismatched begin/endOperation");
                workManager.rebalanceNestedOperations();
                hasTreeChanges = workManager.shouldBuild();
                if (hasTreeChanges) {
                    hasTreeChanges = this.operationTree != null && ElementTree.hasChanges(this.tree, this.operationTree, ResourceComparator.getBuildComparator(), true);
                }
                this.broadcastPostChange();
                this.saveManager.snapshotIfNeeded(hasTreeChanges);
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (depthOne) {
                    this.tree.immutable();
                    this.operationTree = null;
                    throw throwable;
                }
                this.newWorkingTree();
                throw throwable;
            }
            {
                Object var7_12 = null;
                if (depthOne) {
                    this.tree.immutable();
                    this.operationTree = null;
                } else {
                    this.newWorkingTree();
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            workManager.checkOut(rule);
            throw throwable;
        }
        {
            Object var9_9 = null;
            workManager.checkOut(rule);
            if (!depthOne) return;
            this.buildManager.endTopLevel(hasTreeChanges);
            return;
        }
    }

    protected void flushBuildOrder() {
        if (this.description.getBuildOrder(false) == null) {
            this.buildOrder = null;
        }
    }

    public void forgetSavedTree(String pluginId) {
        Assert.isNotNull(pluginId, "PluginId must not be null");
        this.saveManager.forgetSavedTree(pluginId);
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public BuildManager getBuildManager() {
        return this.buildManager;
    }

    public IProject[] getBuildOrder() {
        if (this.buildOrder != null) {
            return this.buildOrder;
        }
        String[] order = this.description.getBuildOrder(false);
        if (order != null) {
            ArrayList<IProject> projectList = new ArrayList<IProject>(order.length);
            int i = 0;
            while (i < order.length) {
                IProject project = this.getRoot().getProject(order[i]);
                if (project.isAccessible()) {
                    projectList.add(project);
                }
                ++i;
            }
            this.buildOrder = new IProject[projectList.size()];
            projectList.toArray(this.buildOrder);
        } else {
            this.buildOrder = this.computeFullProjectOrder().projects;
        }
        return this.buildOrder;
    }

    public CharsetManager getCharsetManager() {
        return this.charsetManager;
    }

    public ContentDescriptionManager getContentDescriptionManager() {
        return this.contentDescriptionManager;
    }

    public Map getDanglingReferences() {
        IProject[] projects = this.getRoot().getProjects();
        HashMap<IProject, IProject[]> result = new HashMap<IProject, IProject[]>(projects.length);
        int i = 0;
        while (i < projects.length) {
            Project project = (Project)projects[i];
            if (project.isAccessible()) {
                IProject[] refs = project.internalGetDescription().getReferencedProjects(false);
                ArrayList<IProject> dangling = new ArrayList<IProject>(refs.length);
                int j = 0;
                while (j < refs.length) {
                    if (!refs[i].exists()) {
                        dangling.add(refs[i]);
                    }
                    ++j;
                }
                if (!dangling.isEmpty()) {
                    result.put(projects[i], dangling.toArray(new IProject[dangling.size()]));
                }
            }
            ++i;
        }
        return result;
    }

    public IWorkspaceDescription getDescription() {
        WorkspaceDescription workingCopy = Workspace.defaultWorkspaceDescription();
        this.description.copyTo(workingCopy);
        return workingCopy;
    }

    public ElementTree getElementTree() {
        return this.tree;
    }

    public FileSystemResourceManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public MarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public LocalMetaArea getMetaArea() {
        return this.localMetaArea;
    }

    protected IMoveDeleteHook getMoveDeleteHook() {
        if (this.moveDeleteHook == null) {
            this.initializeMoveDeleteHook();
        }
        return this.moveDeleteHook;
    }

    public IProjectNatureDescriptor getNatureDescriptor(String natureId) {
        return this.natureManager.getNatureDescriptor(natureId);
    }

    public IProjectNatureDescriptor[] getNatureDescriptors() {
        return this.natureManager.getNatureDescriptors();
    }

    public NatureManager getNatureManager() {
        return this.natureManager;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public IPathVariableManager getPathVariableManager() {
        return this.pathVariableManager;
    }

    public IPropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public RefreshManager getRefreshManager() {
        return this.refreshManager;
    }

    public ResourceInfo getResourceInfo(IPath path, boolean phantom, boolean mutable) {
        try {
            if (path.segmentCount() == 0) {
                ResourceInfo info = (ResourceInfo)this.tree.getTreeData();
                Assert.isNotNull(info, "Tree root info must never be null");
                return info;
            }
            ResourceInfo result = null;
            if (!this.tree.includes(path)) {
                return null;
            }
            result = mutable ? (ResourceInfo)this.tree.openElementData(path) : (ResourceInfo)this.tree.getElementData(path);
            if (result != null && !phantom && result.isSet(8)) {
                return null;
            }
            return result;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public IWorkspaceRoot getRoot() {
        return this.defaultRoot;
    }

    public IResourceRuleFactory getRuleFactory() {
        if (this.ruleFactory == null) {
            this.ruleFactory = new Rules(this);
        }
        return this.ruleFactory;
    }

    public SaveManager getSaveManager() {
        return this.saveManager;
    }

    public ISynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    protected TeamHook getTeamHook() {
        if (this.teamHook == null) {
            this.initializeTeamHook();
        }
        return this.teamHook;
    }

    public WorkManager getWorkManager() throws CoreException {
        if (this._workManager == null) {
            String message = Messages.resources_shutdown;
            throw new ResourceException(new ResourceStatus(566, null, message));
        }
        return this._workManager;
    }

    protected void initializeValidator() {
        block5: {
            this.shouldValidate = false;
            if (!this.canCreateExtensions()) {
                return;
            }
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "fileModificationValidator");
            if (configs == null || configs.length == 0) {
                return;
            }
            if (configs.length > 1) {
                ResourceStatus status = new ResourceStatus(4, 1, null, Messages.resources_oneValidator, null);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                return;
            }
            try {
                IConfigurationElement config = configs[0];
                this.validator = (IFileModificationValidator)config.createExecutableExtension("class");
                this.shouldValidate = true;
            }
            catch (CoreException e) {
                if (!this.canCreateExtensions()) break block5;
                ResourceStatus status = new ResourceStatus(4, 1, null, Messages.resources_initValidator, e);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void initializeMoveDeleteHook() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [5 : 167->171)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void initializeTeamHook() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [5 : 168->172)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public WorkspaceDescription internalGetDescription() {
        return this.description;
    }

    public boolean isAutoBuilding() {
        return this.description.isAutoBuilding();
    }

    private static boolean isDuplicate(Object[] array, int position) {
        if (array == null || position >= array.length) {
            return false;
        }
        int j = position - 1;
        while (j >= 0) {
            if (array[j].equals(array[position])) {
                return true;
            }
            --j;
        }
        return false;
    }

    public boolean isOpen() {
        return this.openFlag;
    }

    protected boolean isOverlapping(IPath location1, IPath location2, boolean bothDirections) {
        IPath one = location1;
        IPath two = location2;
        if (!CoreFileSystemLibrary.isCaseSensitive()) {
            one = new Path(location1.toOSString().toLowerCase());
            two = new Path(location2.toOSString().toLowerCase());
        }
        return one.isPrefixOf(two) || bothDirections && two.isPrefixOf(one);
    }

    public boolean isTreeLocked() {
        return this.treeLocked == Thread.currentThread();
    }

    protected void linkTrees(IPath path, ElementTree[] newTrees) {
        this.tree = this.tree.mergeDeltaChain(path, newTrees);
    }

    public IProjectDescription loadProjectDescription(IPath path) throws CoreException {
        ProjectDescription result = null;
        IOException e = null;
        try {
            result = new ProjectDescriptionReader().read(path);
            if (result != null) {
                IPath user = path.removeLastSegments(1);
                IPath platform = Platform.getLocation().append(result.getName());
                if (!user.toFile().equals(platform.toFile())) {
                    result.setLocation(user);
                }
            }
        }
        catch (IOException ex) {
            e = ex;
        }
        if (result == null || e != null) {
            String message = NLS.bind((String)Messages.resources_errorReadProject, (Object)path.toOSString());
            Status status = new Status(4, "org.eclipse.core.resources", 567, message, (Throwable)e);
            throw new ResourceException((IStatus)status);
        }
        return result;
    }

    public IProjectDescription loadProjectDescription(InputStream stream) throws CoreException {
        ProjectDescription result = null;
        Throwable e = null;
        result = new ProjectDescriptionReader().read(new InputSource(stream));
        if (result == null || e != null) {
            String message = NLS.bind((String)Messages.resources_errorReadProject, (Object)stream.toString());
            Status status = new Status(4, "org.eclipse.core.resources", 567, message, e);
            throw new ResourceException((IStatus)status);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus move(IResource[] resources, IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        IStatus iStatus;
        block22: {
            IStatus iStatus2;
            block20: {
                monitor = Policy.monitorFor(monitor);
                try {
                    int opWork = Math.max(resources.length, 1);
                    int totalWork = 100 * opWork / Policy.opWork;
                    String message = Messages.resources_moving_0;
                    monitor.beginTask(message, totalWork);
                    Assert.isLegal(resources != null);
                    if (resources.length == 0) {
                        iStatus2 = Status.OK_STATUS;
                        Object var16_10 = null;
                        break block20;
                    }
                    resources = (IResource[])resources.clone();
                    IPath parentPath = null;
                    message = Messages.resources_moveProblem;
                    MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, message, null);
                    try {
                        try {
                            this.prepareOperation(this.getRoot(), monitor);
                            this.beginOperation(true);
                            int i = 0;
                            while (i < resources.length) {
                                block21: {
                                    Policy.checkCanceled(monitor);
                                    Resource resource = (Resource)resources[i];
                                    if (resource == null || Workspace.isDuplicate(resources, i)) {
                                        monitor.worked(1);
                                    } else {
                                        if (parentPath == null) {
                                            parentPath = resource.getFullPath().removeLastSegments(1);
                                        }
                                        if (parentPath.equals((Object)resource.getFullPath().removeLastSegments(1))) {
                                            try {
                                                IStatus requirements = resource.checkMoveRequirements(destination.append(resource.getName()), resource.getType(), updateFlags);
                                                if (requirements.isOK()) {
                                                    try {
                                                        resource.move(destination.append(resource.getName()), updateFlags, Policy.subMonitorFor(monitor, 1));
                                                    }
                                                    catch (CoreException e) {
                                                        status.merge(e.getStatus());
                                                    }
                                                    break block21;
                                                }
                                                monitor.worked(1);
                                                status.merge(requirements);
                                            }
                                            catch (CoreException e) {
                                                monitor.worked(1);
                                                status.merge(e.getStatus());
                                            }
                                        } else {
                                            monitor.worked(1);
                                            message = NLS.bind((String)Messages.resources_notChild, (Object)resource.getFullPath(), (Object)parentPath);
                                            status.merge((IStatus)new ResourceStatus(76, resource.getFullPath(), message));
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (OperationCanceledException e) {
                            this.getWorkManager().operationCanceled();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_22 = null;
                        this.endOperation(this.getRoot(), true, Policy.subMonitorFor(monitor, totalWork - opWork));
                        throw throwable;
                    }
                    {
                        Object var14_23 = null;
                    }
                    this.endOperation(this.getRoot(), true, Policy.subMonitorFor(monitor, totalWork - opWork));
                    if (status.matches(4)) {
                        throw new ResourceException((IStatus)status);
                    }
                    iStatus = status.isOK() ? Status.OK_STATUS : status;
                    break block22;
                }
                catch (Throwable throwable) {
                    Object var16_12 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return iStatus2;
        }
        Object var16_11 = null;
        monitor.done();
        return iStatus;
    }

    public IStatus move(IResource[] resources, IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        return this.move(resources, destination, updateFlags |= 2, monitor);
    }

    void move(Resource source, IPath destination, int depth, int updateFlags, boolean keepSyncInfo) throws CoreException {
        this.copyTree(source, destination, depth, updateFlags, keepSyncInfo);
        source.fixupAfterMoveSource();
    }

    protected ResourceInfo newElement(int type) {
        ResourceInfo result = null;
        switch (type) {
            case 1: 
            case 2: {
                result = new ResourceInfo();
                break;
            }
            case 4: {
                result = new ProjectInfo();
                break;
            }
            case 8: {
                result = new RootInfo();
            }
        }
        result.setNodeId(this.nextNodeId());
        this.updateModificationStamp(result);
        result.setType(type);
        return result;
    }

    public IProjectDescription newProjectDescription(String projectName) {
        ProjectDescription result = new ProjectDescription();
        result.setName(projectName);
        return result;
    }

    public Resource newResource(IPath path, int type) {
        switch (type) {
            case 2: {
                if (path.segmentCount() < 2) {
                    String message = "Path must include project and resource name: " + path.toString();
                    Assert.isLegal(false, message);
                }
                return new Folder(path.makeAbsolute(), this);
            }
            case 1: {
                if (path.segmentCount() < 2) {
                    String message = "Path must include project and resource name: " + path.toString();
                    Assert.isLegal(false, message);
                }
                return new File(path.makeAbsolute(), this);
            }
            case 4: {
                return (Resource)((Object)this.getRoot().getProject(path.lastSegment()));
            }
            case 8: {
                return (Resource)((Object)this.getRoot());
            }
        }
        Assert.isLegal(false);
        return null;
    }

    public ElementTree newWorkingTree() {
        this.tree = this.tree.newEmptyDelta();
        return this.tree;
    }

    protected long nextMarkerId() {
        return this.nextMarkerId++;
    }

    public long nextNodeId() {
        return this.nextNodeId++;
    }

    public IStatus open(IProgressMonitor monitor) throws CoreException {
        String message = Messages.resources_workspaceOpen;
        Assert.isTrue(!this.isOpen(), message);
        if (!this.getMetaArea().hasSavedWorkspace()) {
            message = Messages.resources_readWorkspaceMeta;
            throw new ResourceException(567, Platform.getLocation(), message, null);
        }
        this.description = new WorkspacePreferences();
        WorkspaceDescription oldDescription = this.getMetaArea().readOldWorkspace();
        if (oldDescription != null) {
            this.description.copyFrom(oldDescription);
            ResourcesPlugin.getPlugin().savePluginPreferences();
        }
        this.localMetaArea.locationFor(this.getRoot()).toFile().mkdirs();
        IProgressMonitor nullMonitor = Policy.monitorFor(null);
        this.startup(nullMonitor);
        this.notificationManager.startup(null);
        this.openFlag = true;
        if (this.crashed || this.refreshRequested()) {
            try {
                this.getRoot().refreshLocal(2, null);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            catch (RuntimeException e) {
                return new ResourceStatus(566, (IPath)Path.ROOT, Messages.resources_errorMultiRefresh, e);
            }
        }
        this.stringPoolJob = new StringPoolJob();
        this.stringPoolJob.addStringPoolParticipant(this.saveManager, this.getRoot());
        return Status.OK_STATUS;
    }

    public void prepareOperation(ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
        if (rule != null) {
            this.buildManager.interrupt();
        }
        this.getWorkManager().checkIn(rule, monitor);
        if (!this.isOpen()) {
            String message = Messages.resources_workspaceClosed;
            throw new ResourceException(76, null, message, null);
        }
    }

    protected boolean refreshRequested() {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase(REFRESH_ON_STARTUP)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeResourceChangeListener(IResourceChangeListener listener) {
        this.notificationManager.removeListener(listener);
    }

    public void removeSaveParticipant(Plugin plugin) {
        Assert.isNotNull(plugin, "Plugin must not be null");
        this.saveManager.removeParticipant(plugin);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IWorkspaceRunnable action, ISchedulingRule rule, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, 100);
            int depth = -1;
            boolean avoidNotification = (options & 1) != 0;
            try {
                try {
                    this.prepareOperation(rule, monitor);
                    this.beginOperation(true);
                    if (avoidNotification) {
                        avoidNotification = this.notificationManager.beginAvoidNotify();
                    }
                    depth = this.getWorkManager().beginUnprotected();
                    action.run(Policy.subMonitorFor(monitor, Policy.opWork, 4));
                }
                catch (OperationCanceledException e) {
                    this.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (avoidNotification) {
                    this.notificationManager.endAvoidNotify();
                }
                if (depth >= 0) {
                    this.getWorkManager().endUnprotected(depth);
                }
                this.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (avoidNotification) {
                    this.notificationManager.endAvoidNotify();
                }
                if (depth >= 0) {
                    this.getWorkManager().endUnprotected(depth);
                }
                this.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        monitor.done();
    }

    public void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        this.run(action, this.defaultRoot, 1, monitor);
    }

    public IStatus save(boolean full, IProgressMonitor monitor) throws CoreException {
        ResourceStatus resourceStatus;
        if (full) {
            if (this.getWorkManager().isLockAlreadyAcquired()) {
                String message = Messages.resources_saveOp;
                throw new ResourceException(76, null, message, new IllegalStateException());
            }
            return this.saveManager.save(1, null, monitor);
        }
        try {
            this.prepareOperation(this.getRoot(), monitor);
            this.beginOperation(false);
            this.saveManager.requestSnapshot();
            String message = Messages.resources_snapRequest;
            resourceStatus = new ResourceStatus(0, message);
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.endOperation(this.getRoot(), false, null);
            throw throwable;
        }
        this.endOperation(this.getRoot(), false, null);
        return resourceStatus;
    }

    public void setCrashed(boolean value) {
        this.crashed = value;
        if (this.crashed) {
            String msg = "A workspace crash was detected. The previous session did not exit normally.";
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new ResourceStatus(10035, msg));
            if (Policy.DEBUG) {
                System.out.println(msg);
            }
        }
    }

    public void setDescription(IWorkspaceDescription value) {
        WorkspaceDescription newDescription = (WorkspaceDescription)value;
        String[] newOrder = newDescription.getBuildOrder(false);
        if (this.description.getBuildOrder(false) != null || newOrder != null) {
            this.buildOrder = null;
        }
        this.description.copyFrom(newDescription);
        ResourcesPlugin.getPlugin().savePluginPreferences();
    }

    public void setTreeLocked(boolean locked) {
        this.treeLocked = locked ? Thread.currentThread() : null;
    }

    public void setWorkspaceLock(WorkspaceLock lock) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void shutdown(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            IManager[] managers = new IManager[]{this.buildManager, this.propertyManager, this.pathVariableManager, this.charsetManager, this.fileSystemManager, this.markerManager, this._workManager, this.aliasManager, this.refreshManager, this.contentDescriptionManager};
            monitor.beginTask(null, managers.length);
            String message = Messages.resources_shutdownProblems;
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, message, null);
            int i = 0;
            while (true) {
                if (i >= managers.length) {
                    this.buildManager = null;
                    this.notificationManager = null;
                    this.propertyManager = null;
                    this.pathVariableManager = null;
                    this.fileSystemManager = null;
                    this.markerManager = null;
                    this.synchronizer = null;
                    this.saveManager = null;
                    this._workManager = null;
                    this.aliasManager = null;
                    this.refreshManager = null;
                    this.charsetManager = null;
                    this.contentDescriptionManager = null;
                    if (status.isOK()) break;
                    throw new CoreException((IStatus)status);
                }
                IManager manager = managers[i];
                if (manager == null) {
                    monitor.worked(1);
                } else {
                    try {
                        manager.shutdown(Policy.subMonitorFor(monitor, 1));
                    }
                    catch (Exception e) {
                        message = Messages.resources_shutdownProblems;
                        status.add((IStatus)new Status(4, "org.eclipse.core.resources", 566, message, (Throwable)e));
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
    }

    public String[] sortNatureSet(String[] natureIds) {
        return this.natureManager.sortNatureSet(natureIds);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startup(IProgressMonitor monitor) throws CoreException {
        try {
            this._workManager = new WorkManager(this);
            this._workManager.startup(null);
            this.fileSystemManager = new FileSystemResourceManager(this);
            this.fileSystemManager.startup(monitor);
            this.pathVariableManager = new PathVariableManager();
            this.pathVariableManager.startup(null);
            this.natureManager = new NatureManager();
            this.natureManager.startup(null);
            this.buildManager = new BuildManager(this, this.getWorkManager().getLock());
            this.buildManager.startup(null);
            this.notificationManager = new NotificationManager(this);
            this.notificationManager.startup(null);
            this.markerManager = new MarkerManager(this);
            this.markerManager.startup(null);
            this.synchronizer = new Synchronizer(this);
            this.refreshManager = new RefreshManager(this);
            this.saveManager = new SaveManager(this);
            this.saveManager.startup(null);
            this.refreshManager.startup(null);
            this.aliasManager = new AliasManager(this);
            this.aliasManager.startup(null);
            this.propertyManager = ResourcesCompatibilityHelper.createPropertyManager();
            this.propertyManager.startup(monitor);
            this.charsetManager = new CharsetManager(this);
            this.charsetManager.startup(null);
            this.contentDescriptionManager = new ContentDescriptionManager();
            this.contentDescriptionManager.startup(null);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.treeLocked = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.treeLocked = null;
            return;
        }
    }

    public String toDebugString() {
        final StringBuffer buffer = new StringBuffer("\nDump of " + this.toString() + ":\n");
        buffer.append("  parent: " + this.tree.getParent());
        IElementContentVisitor visitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree aTree, IPathRequestor requestor, Object elementContents) {
                buffer.append("\n  " + requestor.requestPath() + ": " + elementContents);
                return true;
            }
        };
        new ElementTreeIterator(this.tree, (IPath)Path.ROOT).iterate(visitor);
        return buffer.toString();
    }

    public void updateModificationStamp(ResourceInfo info) {
        info.incrementModificationStamp();
    }

    public IStatus validateEdit(final IFile[] files, final Object context) {
        if (!this.shouldValidate) {
            String message = Messages.resources_readOnly2;
            MultiStatus result = new MultiStatus("org.eclipse.core.resources", 279, message, null);
            int i = 0;
            while (i < files.length) {
                if (files[i].isReadOnly()) {
                    IPath filePath = files[i].getFullPath();
                    message = NLS.bind((String)Messages.resources_readOnly, (Object)filePath);
                    result.add((IStatus)new ResourceStatus(279, filePath, message));
                }
                ++i;
            }
            return result.getChildren().length == 0 ? Status.OK_STATUS : result;
        }
        if (this.validator == null) {
            this.initializeValidator();
        }
        if (this.validator == null) {
            return Status.OK_STATUS;
        }
        final IStatus[] status = new IStatus[1];
        ISafeRunnable body = new ISafeRunnable(){

            public void run() throws Exception {
                status[0] = Workspace.this.validator.validateEdit(files, context);
            }

            public void handleException(Throwable exception) {
                status[0] = new ResourceStatus(4, null, Messages.resources_errorValidator, exception);
            }
        };
        Platform.run((ISafeRunnable)body);
        return status[0];
    }

    public IStatus validateLinkLocation(IResource resource, IPath unresolvedLocation) {
        IPath testLocation;
        if (ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("description.disableLinking")) {
            String message = NLS.bind((String)Messages.links_workspaceVeto, (Object)resource.getName());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        IContainer parent = resource.getParent();
        if (parent == null || parent.getType() != 4) {
            String message = NLS.bind((String)Messages.links_parentNotProject, (Object)resource.getName());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        if (!parent.isAccessible()) {
            String message = NLS.bind((String)Messages.links_parentNotAccessible, (Object)resource.getFullPath());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        IPath location = this.getPathVariableManager().resolvePath(unresolvedLocation);
        String[] natureIds = ((Project)parent).internalGetDescription().getNatureIds();
        IStatus result = this.getNatureManager().validateLinkCreation(natureIds);
        if (!result.isOK()) {
            return result;
        }
        result = resource.getType() == 1 ? this.getTeamHook().validateCreateLink((IFile)resource, 0, location) : this.getTeamHook().validateCreateLink((IFolder)resource, 0, location);
        if (!result.isOK()) {
            return result;
        }
        if (location.isEmpty()) {
            String message = Messages.links_noPath;
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        int segmentCount = location.segmentCount();
        int i = 0;
        while (i < segmentCount) {
            result = this.validateName(location.segment(i), resource.getType());
            if (!result.isOK()) {
                return result;
            }
            ++i;
        }
        if (location.isAbsolute() && location.getDevice() == null) {
            location = new Path(location.toFile().getAbsolutePath());
        }
        if (this.isOverlapping(location, testLocation = this.getMetaArea().getLocation(), true)) {
            String message = NLS.bind((String)Messages.links_invalidLocation, (Object)location.toOSString());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        testLocation = resource.getProject().getLocation();
        if (testLocation != null && this.isOverlapping(location, testLocation, false)) {
            String message = NLS.bind((String)Messages.links_locationOverlapsProject, (Object)location.toOSString());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        if (!location.isAbsolute()) {
            String message = NLS.bind((String)Messages.pathvar_undefined, (Object)location.toOSString(), (Object)location.segment(0));
            return new ResourceStatus(333, resource.getFullPath(), message);
        }
        IProject[] projects = this.getRoot().getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            IProject project = projects[i2];
            ProjectDescription desc = ((Project)project).internalGetDescription();
            testLocation = desc.getLocation();
            if (testLocation != null && this.isOverlapping(location, testLocation, true)) {
                String message = NLS.bind((String)Messages.links_overlappingResource, (Object)location.toOSString());
                return new ResourceStatus(235, resource.getFullPath(), message);
            }
            if (project.isOpen()) {
                IResource[] children = null;
                try {
                    children = project.members();
                }
                catch (CoreException coreException) {}
                if (children != null) {
                    int j = 0;
                    while (j < children.length) {
                        if (children[j].isLinked() && (testLocation = children[j].getLocation()) != null && this.isOverlapping(location, testLocation, true)) {
                            String message = NLS.bind((String)Messages.links_overlappingResource, (Object)location.toOSString());
                            return new ResourceStatus(235, resource.getFullPath(), message);
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateName(String segment, int type) {
        if (segment == null) {
            String message = Messages.resources_nameNull;
            return new ResourceStatus(77, null, message);
        }
        if (segment.length() == 0) {
            String message = Messages.resources_nameEmpty;
            return new ResourceStatus(77, null, message);
        }
        char[] chars = OS.INVALID_RESOURCE_CHARACTERS;
        int i = 0;
        while (i < chars.length) {
            if (segment.indexOf(chars[i]) != -1) {
                String message = NLS.bind((String)Messages.resources_invalidCharInName, (Object)String.valueOf(chars[i]), (Object)segment);
                return new ResourceStatus(77, null, message);
            }
            ++i;
        }
        if (!OS.isNameValid(segment)) {
            String message = NLS.bind((String)Messages.resources_invalidName, (Object)segment);
            return new ResourceStatus(77, null, message);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateNatureSet(String[] natureIds) {
        return this.natureManager.validateNatureSet(natureIds);
    }

    public IStatus validatePath(String path, int type) {
        if (path == null) {
            String message = Messages.resources_pathNull;
            return new ResourceStatus(77, null, message);
        }
        return this.validatePath(Path.fromOSString((String)path), type, false);
    }

    public IStatus validatePath(IPath path, int type, boolean lastSegmentOnly) {
        if (path == null) {
            String message = Messages.resources_pathNull;
            return new ResourceStatus(77, null, message);
        }
        if (path.getDevice() != null) {
            String message = NLS.bind((String)Messages.resources_invalidCharInPath, (Object)String.valueOf(':'), (Object)path);
            return new ResourceStatus(77, null, message);
        }
        if (path.isRoot()) {
            String message = Messages.resources_invalidRoot;
            return new ResourceStatus(77, null, message);
        }
        if (!path.isAbsolute()) {
            String message = NLS.bind((String)Messages.resources_mustBeAbsolute, (Object)path);
            return new ResourceStatus(77, null, message);
        }
        int numberOfSegments = path.segmentCount();
        if ((type & 4) != 0) {
            if (numberOfSegments == 1) {
                return this.validateName(path.segment(0), 4);
            }
            if (type == 4) {
                String message = NLS.bind((String)Messages.resources_projectPath, (Object)path);
                return new ResourceStatus(77, null, message);
            }
        }
        if ((type & 3) != 0) {
            if (numberOfSegments < 2) {
                String message = NLS.bind((String)Messages.resources_resourcePath, (Object)path);
                return new ResourceStatus(77, null, message);
            }
            int fileFolderType = type &= 0xFFFFFFFB;
            int segmentCount = path.segmentCount();
            if (lastSegmentOnly) {
                return this.validateName(path.segment(segmentCount - 1), fileFolderType);
            }
            IStatus status = this.validateName(path.segment(0), 4);
            if (!status.isOK()) {
                return status;
            }
            int i = 1;
            while (i < segmentCount) {
                status = this.validateName(path.segment(i), fileFolderType);
                if (!status.isOK()) {
                    return status;
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
        String message = NLS.bind((String)Messages.resources_invalidPath, (Object)path);
        return new ResourceStatus(77, null, message);
    }

    public IStatus validateProjectLocation(IProject context, IPath unresolvedLocation) {
        IPath defaultDefaultLocation;
        if (unresolvedLocation == null) {
            return Status.OK_STATUS;
        }
        IPath location = this.getPathVariableManager().resolvePath(unresolvedLocation);
        int segmentCount = location.segmentCount();
        int i = 0;
        while (i < segmentCount) {
            IStatus result = this.validateName(location.segment(i), 4);
            if (!result.isOK()) {
                return result;
            }
            ++i;
        }
        if (!location.isAbsolute()) {
            String message = location.segmentCount() > 0 ? NLS.bind((String)Messages.pathvar_undefined, (Object)location.toOSString(), (Object)location.segment(0)) : Messages.links_noPath;
            return new ResourceStatus(379, null, message);
        }
        if (location.getDevice() == null) {
            location = new Path(location.toFile().getAbsolutePath());
        }
        if (this.isOverlapping(location, defaultDefaultLocation = Platform.getLocation(), true)) {
            String message = NLS.bind((String)Messages.resources_overlapWorkspace, (Object)location.toOSString(), (Object)defaultDefaultLocation.toOSString());
            return new ResourceStatus(77, null, message);
        }
        IProject[] projects = this.getRoot().getProjects();
        int j = 0;
        while (j < projects.length) {
            IProject project = projects[j];
            ProjectDescription desc = ((Project)project).internalGetDescription();
            IPath definedLocalLocation = desc.getLocation();
            if (!(definedLocalLocation == null || project.equals(context) && definedLocalLocation.equals((Object)location) || !this.isOverlapping(location, definedLocalLocation, true))) {
                String message = NLS.bind((String)Messages.resources_overlapProject, (Object)location.toOSString(), (Object)project.getName());
                return new ResourceStatus(77, null, message);
            }
            ++j;
        }
        if (context.exists() && context.isOpen()) {
            IResource[] children = null;
            try {
                children = context.members();
            }
            catch (CoreException coreException) {}
            if (children != null) {
                int i2 = 0;
                while (i2 < children.length) {
                    IPath testLocation;
                    if (children[i2].isLinked() && (testLocation = children[i2].getLocation()) != null && this.isOverlapping(testLocation, location, false)) {
                        String message = NLS.bind((String)Messages.links_locationOverlapsLink, (Object)location.toOSString());
                        return new ResourceStatus(235, context.getFullPath(), message);
                    }
                    ++i2;
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected void validateSave(final IFile file) throws CoreException {
        if (!this.shouldValidate) {
            return;
        }
        if (this.validator == null) {
            this.initializeValidator();
        }
        if (this.validator == null) {
            return;
        }
        final IStatus[] status = new IStatus[1];
        ISafeRunnable body = new ISafeRunnable(){

            public void run() throws Exception {
                status[0] = Workspace.this.validator.validateSave(file);
            }

            public void handleException(Throwable exception) {
                status[0] = new ResourceStatus(4, null, Messages.resources_errorValidator, exception);
            }
        };
        Platform.run((ISafeRunnable)body);
        if (!status[0].isOK()) {
            throw new ResourceException(status[0]);
        }
    }
}

