/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.toc.HrefUtil;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.util.ResourceLocator;
import org.osgi.framework.Bundle;

public class DirectoryToc {
    private String dir;
    private Map extraTopics;
    private String locale;

    protected DirectoryToc(TocFile tocFile) {
        this(tocFile.getPluginID(), tocFile.getLocale(), tocFile.getExtraDir());
    }

    private DirectoryToc(String pluginID, String locale, String directory) {
        this.locale = locale;
        this.dir = HrefUtil.normalizeDirectoryHref(pluginID, directory);
    }

    public Map getExtraTopics() {
        if (this.extraTopics == null) {
            this.extraTopics = this.createExtraTopics();
            this.dir = null;
        }
        return this.extraTopics;
    }

    private Map createExtraTopics() {
        HashMap<String, ExtraTopic> ret = new HashMap<String, ExtraTopic>();
        String pluginID = HrefUtil.getPluginIDFromHref(this.dir);
        if (pluginID == null) {
            return ret;
        }
        Bundle pluginDesc = Platform.getBundle((String)pluginID);
        if (pluginDesc == null || pluginDesc.getState() == 2 || pluginDesc.getState() == 1) {
            return ret;
        }
        String directory = HrefUtil.getResourcePathFromHref(this.dir);
        if (directory == null) {
            directory = "";
        }
        Path iPath = new Path("$nl$/doc.zip");
        HashMap<String, String> override = new HashMap<String, String>(1);
        override.put("$nl$", this.locale);
        URL url = Platform.find((Bundle)pluginDesc, (IPath)iPath, override);
        if (url == null) {
            url = Platform.find((Bundle)pluginDesc, (IPath)new Path("doc.zip"));
        }
        if (url != null) {
            ret.putAll(this.createExtraTopicsFromZip(pluginID, directory, url));
        }
        Set paths = ResourceLocator.findTopicPaths(pluginDesc, directory, this.locale);
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            String href = "/" + pluginID + "/" + (String)it.next();
            ret.put(href, new ExtraTopic(href));
        }
        return ret;
    }

    private Map createExtraTopicsFromZip(String pluginID, String directory, URL url) {
        URL realZipURL;
        Map ret = new HashMap(0);
        try {
            realZipURL = Platform.asLocalURL((URL)Platform.resolve((URL)url));
            if (realZipURL.toExternalForm().startsWith("jar:")) {
                return ret;
            }
        }
        catch (IOException ioe) {
            HelpPlugin.logError("IOException occurred, when resolving URL " + url.toString() + ".", ioe);
            return ret;
        }
        try {
            ZipFile zipFile = new ZipFile(realZipURL.getFile());
            ret = this.createExtraTopicsFromZipFile(pluginID, zipFile, directory);
            zipFile.close();
        }
        catch (IOException ioe) {
            HelpPlugin.logError("IOException occurred, when accessing Zip file " + realZipURL.getFile() + ".  File might not be locally available.", ioe);
            return new HashMap(0);
        }
        return ret;
    }

    private Map createExtraTopicsFromZipFile(String pluginID, ZipFile zipFile, String directory) {
        String constantHrefSegment = "/" + pluginID + "/";
        HashMap<String, ExtraTopic> ret = new HashMap<String, ExtraTopic>();
        Enumeration<? extends ZipEntry> entriesEnum = zipFile.entries();
        while (entriesEnum.hasMoreElements()) {
            ZipEntry zEntry = entriesEnum.nextElement();
            if (zEntry.isDirectory()) continue;
            String docName = zEntry.getName();
            int l = directory.length();
            if (l != 0 && (docName.length() <= l || docName.charAt(l) != '/' || !directory.equals(docName.substring(0, l)))) continue;
            String href = String.valueOf(constantHrefSegment) + docName;
            ret.put(href, new ExtraTopic(href));
        }
        return ret;
    }

    class ExtraTopic
    implements ITopic {
        private String topicHref;

        public ExtraTopic(String href) {
            this.topicHref = href;
        }

        public String getHref() {
            return this.topicHref;
        }

        public String getLabel() {
            return this.topicHref;
        }

        public ITopic[] getSubtopics() {
            return new ITopic[0];
        }
    }
}

