/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.toc.Anchor;
import org.eclipse.help.internal.toc.Link;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocNode;
import org.eclipse.help.internal.toc.Topic;
import org.eclipse.help.internal.util.FastStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class TocFileParser
extends DefaultHandler {
    protected TocBuilder builder;
    protected FastStack elementStack;
    protected TocFile tocFile;
    static SAXParserFactory factory = SAXParserFactory.newInstance();
    private static XMLParserPool parserPool = new XMLParserPool();

    public TocFileParser(TocBuilder builder) {
        this.builder = builder;
    }

    public void error(SAXParseException ex) throws SAXException {
        HelpPlugin.logError("Error parsing Table of Contents file, " + this.getErrorDetails(ex), null);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        HelpPlugin.logError("Failed to parse Table of Contents file, " + this.getErrorDetails(ex), ex);
    }

    protected String getErrorDetails(SAXParseException ex) {
        String param0 = ex.getSystemId();
        Integer param1 = new Integer(ex.getLineNumber());
        Integer param2 = new Integer(ex.getColumnNumber());
        String param3 = ex.getMessage();
        String message = MessageFormat.format("URL: {0} at line: {1,number,integer}, column: {2,number,integer}.\r\n{3}", param0, param1, param2, param3);
        return message;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(TocFile tocFile) {
        this.tocFile = tocFile;
        this.elementStack = new FastStack();
        InputStream is = tocFile.getInputStream();
        if (is == null) {
            return;
        }
        InputSource inputSource = new InputSource(is);
        String file = "/" + tocFile.getPluginID() + "/" + tocFile.getHref();
        inputSource.setSystemId(file);
        try {
            SAXParser parser = parserPool.obtainParser();
            try {
                parser.parse(inputSource, (DefaultHandler)this);
                is.close();
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                parserPool.releaseParser(parser);
                throw throwable;
            }
            {
                Object var6_11 = null;
                parserPool.releaseParser(parser);
                return;
            }
        }
        catch (ParserConfigurationException pce) {
            HelpPlugin.logError("SAXParser implementation could not be loaded.", pce);
            return;
        }
        catch (SAXException se) {
            HelpPlugin.logError("Error loading Table of Contents file " + file + ".", se);
            return;
        }
        catch (IOException ioe) {
            HelpPlugin.logError("Error loading Table of Contents file " + file + ".", ioe);
        }
    }

    public final void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        TocNode node = null;
        if (qName.equals("toc")) {
            node = new Toc(this.tocFile, atts);
            this.tocFile.setToc((Toc)node);
        } else if (qName.equals("topic")) {
            node = new Topic(this.tocFile, atts);
        } else if (qName.equals("link")) {
            node = new Link(this.tocFile, atts);
        } else if (qName.equals("anchor")) {
            node = new Anchor(this.tocFile, atts);
        } else {
            return;
        }
        if (!this.elementStack.empty()) {
            ((TocNode)this.elementStack.peek()).addChild(node);
        }
        this.elementStack.push(node);
        node.build(this.builder);
    }

    public final void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.elementStack.pop();
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource source = new InputSource(new ByteArrayInputStream(new byte[0]));
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }

    static class XMLParserPool {
        private ArrayList pool = new ArrayList();

        XMLParserPool() {
        }

        SAXParser obtainParser() throws ParserConfigurationException, SAXException {
            int free = this.pool.size();
            SAXParser p = free > 0 ? (SAXParser)this.pool.remove(free - 1) : factory.newSAXParser();
            return p;
        }

        void releaseParser(SAXParser parser) {
            this.pool.add(parser);
        }
    }
}

