/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.navigator.internal.groups.NavigatorGroup;
import org.eclipse.wst.common.navigator.internal.groups.NavigatorGroupActivityHelper;
import org.eclipse.wst.common.navigator.internal.groups.NavigatorGroupExtensionReader;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;

public class NavigatorGroupContentProvider
implements INavigatorContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    protected boolean groupingEnabled = true;
    protected List cachedGroupList;
    protected Map projectToLastKnownParentMap = new WeakHashMap();
    private Viewer viewer;

    public INavigatorContentExtension getContainingExtension() {
        return null;
    }

    public NavigatorGroupContentProvider() {
    }

    public NavigatorGroupContentProvider(INavigatorContentExtension containingExtension) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            if (!this.isGroupingEnabled()) {
                return this.getAllProjects();
            }
            this.cachedGroupList = NavigatorGroupActivityHelper.getEnabledGroups();
            return this.cachedGroupList.toArray();
        }
        if (parentElement instanceof NavigatorGroup) {
            NavigatorGroup navGroup = (NavigatorGroup)parentElement;
            Object[] projects = null;
            projects = navGroup.getNatureID() != null && !navGroup.getNatureID().equals("nongrouped") ? this.getProjectsIfBestNatureID(navGroup.getNatureID(), NavigatorGroupExtensionReader.getInstance().getKnownGroupNatureIDs()) : this.getNonGroupedProjects();
            this.updateLastKnownParent((IProject[])projects, navGroup);
            return projects;
        }
        return new Object[0];
    }

    private IProject[] getNonGroupedProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        List knownGroupNatureIds = NavigatorGroupExtensionReader.getInstance().getKnownGroupNatureIDs();
        IProject[] projects = this.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            boolean isGrouped = false;
            int j = 0;
            while (j < knownGroupNatureIds.size()) {
                String natureID = (String)knownGroupNatureIds.get(j);
                if (this.isBestNatureForProject(project, natureID, knownGroupNatureIds)) {
                    isGrouped = true;
                    break;
                }
                ++j;
            }
            if (!isGrouped) {
                result.add(project);
            }
            ++i;
        }
        IProject[] resultProjects = new IProject[result.size()];
        result.toArray(resultProjects);
        return resultProjects;
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            if (this.isGroupingEnabled()) {
                IProject project = (IProject)element;
                if (this.getProjectToLastKnownParentMap().get(project) != null) {
                    return this.getProjectToLastKnownParentMap().get(project);
                }
                NavigatorGroup parent = this.getBestNavigatorGroupParent(project);
                this.getProjectToLastKnownParentMap().put(project, parent);
                return parent;
            }
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return null;
    }

    public NavigatorGroup getBestNavigatorGroupParent(IProject project) {
        List knownGroupNatureIds = NavigatorGroupExtensionReader.getInstance().getKnownGroupNatureIDs();
        String bestNature = this.getBestNatureForProject(project, knownGroupNatureIds);
        if (bestNature != null) {
            return NavigatorGroupExtensionReader.getInstance().getNavigatorGroup(bestNature);
        }
        return NavigatorGroupExtensionReader.getInstance().getDefaultNavigatorGroup();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            return ((IProject)element).isOpen();
        }
        return true;
    }

    public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        this.viewer = aViewer;
        IWorkspace oldWorkspace = null;
        IWorkspace newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = (IWorkspace)oldInput;
        } else if (oldInput instanceof IContainer) {
            oldWorkspace = ((IContainer)oldInput).getWorkspace();
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = (IWorkspace)newInput;
        } else if (newInput instanceof IContainer) {
            newWorkspace = ((IContainer)newInput).getWorkspace();
        }
        if (oldWorkspace != newWorkspace) {
            if (oldWorkspace != null) {
                oldWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newWorkspace != null) {
                newWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }
    }

    private boolean isBestNatureForProject(IProject project, String natureID, List natureList) {
        String[] projectNatures = null;
        try {
            projectNatures = project.getDescription().getNatureIds();
        }
        catch (Exception exception) {}
        if (projectNatures == null || projectNatures.length == 0) {
            return false;
        }
        int i = 0;
        while (i < projectNatures.length) {
            if (projectNatures[i].equals(natureID)) {
                return true;
            }
            if (natureList.contains(projectNatures[i])) break;
            ++i;
        }
        return false;
    }

    private String getBestNatureForProject(IProject project, List natureList) {
        String[] projectNatures = null;
        try {
            projectNatures = project.getDescription().getNatureIds();
        }
        catch (Exception exception) {
            return null;
        }
        if (projectNatures == null && projectNatures.length == 0) {
            return null;
        }
        int i = 0;
        while (i < projectNatures.length) {
            if (natureList.contains(projectNatures[i])) {
                return projectNatures[i];
            }
            ++i;
        }
        return null;
    }

    private IProject[] getProjectsIfBestNatureID(String natureID, List natureList) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = this.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            if (this.isBestNatureForProject(projects[i], natureID, natureList)) {
                result.add(projects[i]);
            }
            ++i;
        }
        IProject[] resultProjects = new IProject[result.size()];
        result.toArray(resultProjects);
        return resultProjects;
    }

    private IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public boolean isGroupingEnabled() {
        return this.groupingEnabled;
    }

    public void setGroupingEnabled(boolean groupingEnabled) {
        this.groupingEnabled = groupingEnabled;
    }

    public void dispose() {
        if (this.viewer != null) {
            IWorkspace workspace = null;
            Object obj = this.viewer.getInput();
            if (obj instanceof IWorkspace) {
                workspace = (IWorkspace)obj;
            } else if (obj instanceof IContainer) {
                workspace = ((IContainer)obj).getWorkspace();
            }
            if (workspace != null) {
                workspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public List getCachedGroupList() {
        return this.cachedGroupList;
    }

    public void setCachedGroupList(List cachedGroupList) {
        this.cachedGroupList = cachedGroupList;
    }

    protected Map getProjectToLastKnownParentMap() {
        return this.projectToLastKnownParentMap;
    }

    public void updateLastKnownParent(IProject project) {
        this.updateLastKnownParent(project, this.getBestNavigatorGroupParent(project));
    }

    private void updateLastKnownParent(IProject project, NavigatorGroup bestNavigatorGroupParent) {
        this.getProjectToLastKnownParentMap().put(project, bestNavigatorGroupParent);
    }

    private void updateLastKnownParent(IProject[] projects, NavigatorGroup navGroup) {
        int i = 0;
        while (i < projects.length) {
            this.updateLastKnownParent(projects[i], navGroup);
            ++i;
        }
    }

    public void resourceChanged(IResourceChangeEvent anEvent) {
        IResourceDelta delta = anEvent.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(2, WorkbenchNavigatorPlugin.PLUGIN_ID, 0, e.getLocalizedMessage(), (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processDelta(IResourceDelta aDelta, IProject aProject) {
        if (!(this.viewer instanceof AbstractTreeViewer)) return;
        AbstractTreeViewer treeViewer = (AbstractTreeViewer)this.viewer;
        treeViewer.getControl().setRedraw(false);
        try {
            switch (aDelta.getKind()) {
                case 2: {
                    treeViewer.remove((Object)aProject);
                    break;
                }
                case 1: {
                    treeViewer.add(this.getParent(aProject), (Object)aProject);
                    break;
                }
                case 4: {
                    boolean projectOpenStateChanged;
                    boolean natureMayHaveChanged = (aDelta.getFlags() & 0x80000) != 0 && (aDelta.getFlags() & 0x20000) == 0;
                    boolean bl = projectOpenStateChanged = (aDelta.getFlags() & 0x4000) != 0;
                    if (natureMayHaveChanged || projectOpenStateChanged) {
                        NavigatorGroup newParent;
                        Object oldParent = this.getParent(aProject);
                        if (oldParent != (newParent = this.getBestNavigatorGroupParent(aProject))) {
                            this.updateLastKnownParent(aProject);
                            treeViewer.remove((Object)aProject);
                            treeViewer.add((Object)newParent, (Object)aProject);
                        }
                        treeViewer.refresh((Object)aProject, true);
                    }
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            treeViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        treeViewer.getControl().setRedraw(true);
    }

    public boolean visit(IResourceDelta aDelta) throws CoreException {
        final IResourceDelta finalDelta = aDelta;
        IResource resource = finalDelta.getResource();
        if (resource != null && resource.getType() == 4) {
            final IProject project = (IProject)resource;
            if (Display.getCurrent() != null) {
                this.processDelta(finalDelta, project);
            } else {
                new UIJob("Update the Navigator Content Viewer Job"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        NavigatorGroupContentProvider.this.processDelta(finalDelta, project);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            return false;
        }
        return true;
    }
}

