/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.groups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.wst.common.navigator.internal.groups.NavigatorGroup;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class NavigatorGroupExtensionReader
extends RegistryReader {
    private static NavigatorGroupExtensionReader INSTANCE = new NavigatorGroupExtensionReader();
    public static final String EXTENSION_NAME = "NavigatorGroup";
    public static final String EXTENSION_ID = "navigatorGroup";
    public static final String GROUP_DISPLAY_ATTR = "displayName";
    public static final String GROUP_NATURE_ID_ATTR = "natureID";
    public static final String GROUP_ICON_ATTR = "icon";
    public static final String GROUP_EXCLUDE = "exclude";
    public static final String SORT_ORDER = "sortOrder";
    public static final String NON_GROUPED_ID = "nongrouped";
    private List navigatorGroupsList = new ArrayList();
    private List nonExcludedGroupsList = new ArrayList();
    private List knownGroupNatureIds = null;
    private static boolean initialized;

    public NavigatorGroupExtensionReader() {
        super(WorkbenchNavigatorPlugin.PLUGIN_ID, EXTENSION_NAME);
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(EXTENSION_ID)) {
            return false;
        }
        String displayName = element.getAttribute(GROUP_DISPLAY_ATTR);
        String natureID = element.getAttribute(GROUP_NATURE_ID_ATTR);
        String icon = element.getAttribute(GROUP_ICON_ATTR);
        String exclude = element.getAttribute(GROUP_EXCLUDE);
        String sortOrderString = element.getAttribute(SORT_ORDER);
        final String localID = element.getDeclaringExtension().getSimpleIdentifier();
        final String pluginID = element.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
        int sortOrder = sortOrderString != null ? Integer.parseInt(sortOrderString.trim()) : Integer.MAX_VALUE;
        NavigatorGroup navGroup = new NavigatorGroup(pluginID, displayName, natureID, icon, exclude, sortOrder, new IPluginContribution(){

            public String getLocalId() {
                return localID;
            }

            public String getPluginId() {
                return pluginID;
            }
        });
        this.navigatorGroupsList.add(navGroup);
        if (exclude == null || !exclude.equals("true")) {
            this.nonExcludedGroupsList.add(navGroup);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigatorGroupExtensionReader getInstance() {
        if (NavigatorGroupExtensionReader.isInitialized()) {
            return INSTANCE;
        }
        NavigatorGroupExtensionReader navigatorGroupExtensionReader = INSTANCE;
        synchronized (navigatorGroupExtensionReader) {
            if (!NavigatorGroupExtensionReader.isInitialized()) {
                INSTANCE.readRegistry();
                initialized = true;
            }
        }
        return INSTANCE;
    }

    public NavigatorGroup getDefaultNavigatorGroup() {
        NavigatorGroup group = null;
        List navGroups = this.getNavigatorGroupsList();
        int i = 0;
        while (i < navGroups.size()) {
            group = (NavigatorGroup)navGroups.get(i);
            if (group.getNatureID() != null && group.getNatureID().equals(NON_GROUPED_ID)) {
                return group;
            }
            ++i;
        }
        return null;
    }

    public List getNavigatorGroupsList() {
        return this.navigatorGroupsList;
    }

    public List getKnownGroupNatureIDs() {
        if (this.knownGroupNatureIds == null) {
            this.knownGroupNatureIds = new ArrayList();
            int i = 0;
            while (i < this.navigatorGroupsList.size()) {
                NavigatorGroup group = (NavigatorGroup)this.navigatorGroupsList.get(i);
                if (group.getNatureID() != null && !this.knownGroupNatureIds.contains(group.getNatureID())) {
                    this.knownGroupNatureIds.add(group.getNatureID());
                }
                ++i;
            }
            if (this.knownGroupNatureIds.size() == 0) {
                this.knownGroupNatureIds = Collections.EMPTY_LIST;
            }
        }
        return this.knownGroupNatureIds;
    }

    public List getNonExcludedGroupsList() {
        return this.nonExcludedGroupsList;
    }

    public NavigatorGroup getNavigatorGroup(String natureID) {
        int i = 0;
        while (i < this.navigatorGroupsList.size()) {
            NavigatorGroup navGroup = (NavigatorGroup)this.navigatorGroupsList.get(i);
            if (navGroup != null && navGroup.getNatureID() != null && navGroup.getNatureID().equals(natureID)) {
                return navGroup;
            }
            ++i;
        }
        return null;
    }

    protected static boolean isInitialized() {
        return initialized;
    }
}

