/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;

public class ClasspathComputer {
    public static void setClasspath(IProject project, IPluginModelBase model) throws CoreException {
        IClasspathEntry[] entries = ClasspathComputer.getClasspath(project, model, false);
        JavaCore.create((IProject)project).setRawClasspath(entries, null);
    }

    public static IClasspathEntry[] getClasspath(IProject project, IPluginModelBase model, boolean clear) throws CoreException {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        ClasspathComputer.addSourceAndLibraries(project, model, clear, result);
        result.add(ClasspathUtilCore.createJREEntry());
        result.add(ClasspathUtilCore.createContainerEntry());
        IClasspathEntry[] entries = result.toArray(new IClasspathEntry[result.size()]);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IJavaModelStatus validation = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])entries, (IPath)javaProject.getOutputLocation());
        if (!validation.isOK()) {
            PDECore.logErrorMessage(validation.getMessage());
            throw new CoreException((IStatus)validation);
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    private static void addSourceAndLibraries(IProject project, IPluginModelBase model, boolean clear, ArrayList result) throws CoreException {
        HashSet<IPath> paths = new HashSet<IPath>();
        if (!clear) {
            IClasspathEntry[] entries = JavaCore.create((IProject)project).getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 3 && entry.getPath().segmentCount() > 1 && paths.add(entry.getPath())) {
                    result.add(entry);
                }
                ++i;
            }
        }
        IBuild build = ClasspathComputer.getBuild(project);
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IBuildEntry buildEntry;
            IBuildEntry iBuildEntry = buildEntry = build == null ? null : build.getEntry("source." + libraries[i].getName());
            if (buildEntry != null) {
                ClasspathComputer.addSourceFolder(buildEntry, project, paths, result);
            } else if (libraries[i].getName().equals(".")) {
                ClasspathComputer.addJARdPlugin(project, ClasspathComputer.getFilename(model), result);
            } else {
                ClasspathComputer.addLibraryEntry(project, libraries[i], libraries[i].isExported(), result);
            }
            ++i;
        }
        if (libraries.length == 0) {
            if (build != null) {
                IBuildEntry buildEntry;
                IBuildEntry iBuildEntry = buildEntry = build == null ? null : build.getEntry("source..");
                if (buildEntry != null) {
                    ClasspathComputer.addSourceFolder(buildEntry, project, paths, result);
                }
            } else if (ClasspathComputer.isBundle(model)) {
                ClasspathComputer.addJARdPlugin(project, ClasspathComputer.getFilename(model), result);
            }
        }
    }

    private static void addSourceFolder(IBuildEntry buildEntry, IProject project, HashSet paths, ArrayList result) throws CoreException {
        String[] folders = buildEntry.getTokens();
        int j = 0;
        while (j < folders.length) {
            String folder = folders[j];
            IPath path = project.getFullPath().append(folder);
            if (paths.add(path)) {
                if (project.findMember(folder) == null) {
                    CoreUtility.createFolder(project.getFolder(folder));
                }
                result.add(JavaCore.newSourceEntry((IPath)path));
            }
            ++j;
        }
    }

    public static String getFilename(IPluginModelBase model) {
        StringBuffer buffer = new StringBuffer();
        String id = model.getPluginBase().getId();
        if (id != null) {
            buffer.append(id);
        }
        buffer.append("_");
        String version = model.getPluginBase().getVersion();
        if (version != null) {
            buffer.append(version);
        }
        buffer.append(".jar");
        return buffer.toString();
    }

    protected static IBuild getBuild(IProject project) throws CoreException {
        IFile buildFile = project.getFile("build.properties");
        IBuildModel buildModel = null;
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        return buildModel != null ? buildModel.getBuild() : null;
    }

    private static void addLibraryEntry(IProject project, IPluginLibrary library, boolean exported, ArrayList result) {
        String name = ClasspathUtilCore.expandLibraryName(library.getName());
        IResource jarFile = project.findMember(name);
        if (jarFile != null) {
            IResource resource = project.findMember(ClasspathComputer.getSourceZipName(name));
            if (resource == null) {
                resource = project.findMember(new Path(ClasspathComputer.getSourceZipName(name)).lastSegment());
            }
            IPath srcAttachment = resource != null ? resource.getFullPath() : null;
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)jarFile.getFullPath(), (IPath)srcAttachment, null, (boolean)exported);
            if (!result.contains(entry)) {
                result.add(entry);
            }
        }
    }

    private static void addJARdPlugin(IProject project, String filename, ArrayList result) {
        String name = ClasspathUtilCore.expandLibraryName(filename);
        IResource jarFile = project.findMember(name);
        if (jarFile != null) {
            IResource resource = project.findMember(ClasspathComputer.getSourceZipName(name));
            IPath srcAttachment = resource != null ? resource.getFullPath() : jarFile.getFullPath();
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)jarFile.getFullPath(), (IPath)srcAttachment, null, (boolean)true);
            if (!result.contains(entry)) {
                result.add(entry);
            }
        }
    }

    public static String getSourceZipName(String libraryName) {
        int dot = libraryName.lastIndexOf(46);
        return dot != -1 ? String.valueOf(libraryName.substring(0, dot)) + "src.zip" : libraryName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBundle(IPluginModelBase model) {
        ZipFile jarFile;
        block12: {
            boolean bl;
            if (model instanceof IBundlePluginModelBase) {
                return true;
            }
            if (model.getUnderlyingResource() != null) return false;
            File file = new File(model.getInstallLocation());
            if (file.isDirectory()) {
                return new File(file, "META-INF/MANIFEST.MF").exists();
            }
            jarFile = null;
            try {
                try {
                    jarFile = new ZipFile(file, 1);
                    bl = jarFile.getEntry("META-INF/MANIFEST.MF") != null;
                    Object var3_4 = null;
                }
                catch (IOException iOException) {
                    break block12;
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    if (jarFile == null) throw throwable;
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (jarFile == null) return bl;
            jarFile.close();
            return bl;
        }
        Object var3_6 = null;
        try {}
        catch (IOException iOException) {
            return false;
        }
        if (jarFile == null) return false;
        jarFile.close();
        return false;
    }
}

