/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArgumentsInfo
extends ProductObject
implements IArgumentsInfo {
    private static final long serialVersionUID = 1L;
    private String fProgramArgs = "";
    private String fVMArgs = "";

    public ArgumentsInfo(IProductModel model) {
        super(model);
    }

    public void setProgramArguments(String args) {
        String old = this.fProgramArgs;
        this.fProgramArgs = args;
        if (this.isEditable()) {
            this.firePropertyChanged("programArgs", old, this.fProgramArgs);
        }
    }

    public String getProgramArguments() {
        return this.fProgramArgs;
    }

    public void setVMArguments(String args) {
        String old = args;
        this.fVMArgs = args;
        if (this.isEditable()) {
            this.firePropertyChanged("vmArgs", old, this.fVMArgs);
        }
    }

    public String getVMArguments() {
        return this.fVMArgs;
    }

    public void parse(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("programArgs")) {
                    this.fProgramArgs = this.getText(child);
                } else if (child.getNodeName().equals("vmArgs")) {
                    this.fVMArgs = this.getText(child);
                }
            }
            ++i;
        }
    }

    private String getText(Node node) {
        node.normalize();
        Node text = node.getFirstChild();
        if (text != null && text.getNodeType() == 3) {
            return text.getNodeValue();
        }
        return "";
    }

    public void write(String indent, PrintWriter writer) {
        writer.println(String.valueOf(indent) + "<launcherArgs>");
        if (this.fProgramArgs.length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "programArgs" + ">" + this.getWritableString(this.fProgramArgs) + "</" + "programArgs" + ">");
        }
        if (this.fVMArgs.length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "vmArgs" + ">" + this.getWritableString(this.fVMArgs) + "</" + "vmArgs" + ">");
        }
        writer.println(String.valueOf(indent) + "</launcherArgs>");
    }
}

