/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;

public abstract class ChangeSetCollector {
    private ListenerList listeners = new ListenerList();
    private Set sets = new HashSet();

    private Object[] getListeners() {
        return this.listeners.getListeners();
    }

    protected void fireNameChangedEvent(final ChangeSet set) {
        if (this.contains(set)) {
            Object[] listeners = this.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.nameChanged(set);
                    }
                });
                ++i;
            }
        }
    }

    protected void fireDefaultChangedEvent(final ChangeSet oldSet, final ChangeSet defaultSet) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.defaultSetChanged(oldSet, defaultSet);
                }
            });
            ++i;
        }
    }

    public void add(final ChangeSet set) {
        if (!this.contains(set)) {
            this.sets.add(set);
            set.getSyncInfoSet().addSyncSetChangedListener(this.getChangeSetChangeListener());
            Object[] listeners = this.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.setAdded(set);
                    }
                });
                ++i;
            }
        }
    }

    public void remove(final ChangeSet set) {
        if (this.contains(set)) {
            set.getSyncInfoSet().removeSyncSetChangedListener(this.getChangeSetChangeListener());
            this.sets.remove(set);
            Object[] listeners = this.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.setRemoved(set);
                    }
                });
                ++i;
            }
        }
    }

    protected abstract ISyncInfoSetChangeListener getChangeSetChangeListener();

    public boolean contains(ChangeSet set) {
        return this.sets.contains(set);
    }

    public void addListener(IChangeSetChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IChangeSetChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public ChangeSet[] getSets() {
        return this.sets.toArray(new ChangeSet[this.sets.size()]);
    }

    public void dispose() {
    }

    protected void fireResourcesChangedEvent(final ChangeSet changeSet, final IResource[] allAffectedResources) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.resourcesChanged(changeSet, allAffectedResources);
                }
            });
            ++i;
        }
    }

    protected ChangeSet getChangeSet(SyncInfoSet set) {
        Iterator iter = this.sets.iterator();
        while (iter.hasNext()) {
            ChangeSet changeSet = (ChangeSet)iter.next();
            if (changeSet.getSyncInfoSet() != set) continue;
            return changeSet;
        }
        return null;
    }
}

