/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;

public class WSDL11ValidatorDelegate {
    private String validatorClassname = null;
    private String resourceBundle = null;
    private ClassLoader classLoader = null;
    private IWSDL11Validator validator = null;

    public WSDL11ValidatorDelegate(String validatorClassname, String resourceBundle) {
        this.validatorClassname = validatorClassname;
        this.resourceBundle = resourceBundle;
    }

    public WSDL11ValidatorDelegate(String validatorClassname, String resourceBundle, ClassLoader classLoader) {
        this(validatorClassname, resourceBundle);
        this.classLoader = classLoader;
    }

    public IWSDL11Validator getValidator() {
        if (this.validator == null) {
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
            try {
                Class<?> validatorClass = this.classLoader != null ? this.classLoader.loadClass(this.validatorClassname) : Class.forName(this.validatorClassname);
                this.validator = (IWSDL11Validator)validatorClass.newInstance();
                if (this.resourceBundle != null) {
                    ResourceBundle validatorBundle = ResourceBundle.getBundle(this.resourceBundle, Locale.getDefault(), this.classLoader);
                    this.validator.setResourceBundle(validatorBundle);
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println(e);
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
            }
            catch (InstantiationException e) {
                System.err.println(e);
            }
        }
        return this.validator;
    }
}

