/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.DefaultVersionComparator;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.IndexedSet;
import org.eclipse.wst.common.project.facet.core.internal.VersionMatchExpr;
import org.osgi.framework.Bundle;

public abstract class Versionable {
    private static final Comparator DEFAULT_VERSION_COMPARATOR = new DefaultVersionComparator();
    protected final IndexedSet versions = new IndexedSet();
    private String versionComparatorClass;
    private Comparator versionComparator;

    public abstract String getPluginId();

    public Set getVersions() {
        return this.versions.getUnmodifiable();
    }

    public Set getVersions(String expr) throws CoreException {
        VersionMatchExpr prepared = new VersionMatchExpr(this, expr);
        HashSet<IVersion> result = new HashSet<IVersion>();
        Iterator itr = this.versions.iterator();
        while (itr.hasNext()) {
            IVersion ver = (IVersion)itr.next();
            if (!prepared.evaluate(ver)) continue;
            result.add(ver);
        }
        return result;
    }

    public IVersion getVersionInternal(String version) {
        return (IVersion)this.versions.get(version);
    }

    public boolean hasVersion(String version) {
        return this.versions.containsKey(version);
    }

    public List getSortedVersions(boolean ascending) throws VersionFormatException, CoreException {
        ArrayList list = new ArrayList(this.versions);
        IVersionAdapter adapter = this.getVersionAdapter();
        Collections.sort(list, this.getVersionComparator(ascending, adapter));
        return list;
    }

    public Comparator getVersionComparator() throws CoreException {
        return this.getVersionComparator(true, null);
    }

    protected Comparator getVersionComparator(boolean ascending, final IVersionAdapter adapter) throws CoreException {
        Comparator base;
        Comparator comp;
        if (this.versionComparatorClass == null) {
            comp = DEFAULT_VERSION_COMPARATOR;
        } else {
            if (this.versionComparator == null) {
                Bundle bundle = Platform.getBundle((String)this.getPluginId());
                try {
                    Class cl = bundle.loadClass(this.versionComparatorClass);
                    this.versionComparator = (Comparator)cl.newInstance();
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)Resources.failedToCreate, (Object)this.versionComparatorClass);
                    IStatus st = FacetCorePlugin.createErrorStatus(msg, e);
                    throw new CoreException(st);
                }
            }
            comp = this.versionComparator;
        }
        if (adapter != null) {
            base = comp;
            comp = new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    String ver1 = adapter.adapt(obj1);
                    String ver2 = adapter.adapt(obj2);
                    return base.compare(ver1, ver2);
                }
            };
        }
        if (!ascending) {
            base = comp;
            comp = new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    return base.compare(obj1, obj2) * -1;
                }
            };
        }
        return comp;
    }

    public void setVersionComparator(String clname) {
        this.versionComparatorClass = clname;
    }

    public abstract String createVersionNotFoundErrMsg(String var1);

    protected abstract IVersionAdapter getVersionAdapter();

    protected static interface IVersionAdapter {
        public String adapt(Object var1);
    }

    private static final class Resources
    extends NLS {
        public static String failedToCreate;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.Versionable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.Versionable$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

