/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IListener;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.IndexedSet;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl;
import org.eclipse.wst.common.project.facet.core.internal.VersionMatchExpr;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.Runtime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponentVersion;

public final class RuntimeManagerImpl {
    private static final String EXTENSION_ID = "runtimes";
    private static final String BRIDGES_EXTENSION_ID = "runtimeBridges";
    private static final String DEFAULT_FACETS_EXTENSION_ID = "defaultFacets";
    private static final IndexedSet runtimeComponentTypes = new IndexedSet();
    private static final IndexedSet runtimes = new IndexedSet();
    private static final List mappings = new ArrayList();
    private static final Map bridges = new HashMap();
    private static final List defaultFacets = new ArrayList();
    private static final Set listeners = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        RuntimeManagerImpl.readMetadata();
        RuntimeManagerImpl.readBridgesExtensions();
        RuntimeManagerImpl.readDefaultFacetsExtensions();
    }

    private RuntimeManagerImpl() {
    }

    public static Set getRuntimeComponentTypes() {
        return runtimeComponentTypes.getUnmodifiable();
    }

    public static boolean isRuntimeComponentTypeDefined(String id) {
        return runtimeComponentTypes.containsKey(id);
    }

    public static IRuntimeComponentType getRuntimeComponentType(String id) {
        IRuntimeComponentType rc = (IRuntimeComponentType)runtimeComponentTypes.get(id);
        if (rc == null) {
            String msg = "Could not find runtime component type " + id + ".";
            throw new IllegalArgumentException(msg);
        }
        return rc;
    }

    public static IRuntimeComponent createRuntimeComponent(IRuntimeComponentVersion rcv, Map properties) {
        RuntimeComponent rc = new RuntimeComponent();
        rc.setRuntimeComponentVersion(rcv);
        if (properties != null) {
            Iterator itr = properties.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                rc.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getRuntimes() {
        IndexedSet indexedSet = runtimes;
        synchronized (indexedSet) {
            RuntimeManagerImpl.bridge();
            return (Set)runtimes.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getRuntimes(Set facets) {
        IndexedSet indexedSet = runtimes;
        synchronized (indexedSet) {
            RuntimeManagerImpl.bridge();
            HashSet<IRuntime> result = new HashSet<IRuntime>();
            Iterator itr1 = runtimes.iterator();
            while (itr1.hasNext()) {
                IRuntime r = (IRuntime)itr1.next();
                boolean supports = true;
                Iterator itr2 = facets.iterator();
                while (itr2.hasNext()) {
                    if (r.supports((IProjectFacetVersion)itr2.next())) continue;
                    supports = false;
                    break;
                }
                if (!supports) continue;
                result.add(r);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRuntimeDefined(String name) {
        IndexedSet indexedSet = runtimes;
        synchronized (indexedSet) {
            RuntimeManagerImpl.bridge();
            return runtimes.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRuntime getRuntime(String name) {
        IndexedSet indexedSet = runtimes;
        synchronized (indexedSet) {
            RuntimeManagerImpl.bridge();
            IRuntime runtime = (IRuntime)runtimes.get(name);
            if (runtime == null) {
                String msg = "Could not find runtime " + name + ".";
                throw new IllegalArgumentException(msg);
            }
            return runtime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRuntime defineRuntime(String name, List components, Map properties) {
        IndexedSet indexedSet = runtimes;
        synchronized (indexedSet) {
            Runtime r = new Runtime();
            r.setName(name);
            Iterator<Object> itr = components.iterator();
            while (itr.hasNext()) {
                r.addRuntimeComponent((IRuntimeComponent)itr.next());
            }
            if (properties != null) {
                itr = properties.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = (Map.Entry)itr.next();
                    r.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            runtimes.add(r.getName(), r);
            RuntimeManagerImpl.notifyRuntimeListeners();
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRuntime(IRuntime runtime) {
        IndexedSet indexedSet = runtimes;
        synchronized (indexedSet) {
            if (runtimes.delete(runtime.getName())) {
                RuntimeManagerImpl.notifyRuntimeListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRuntimeListener(IListener listener) {
        Set set = listeners;
        synchronized (set) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRuntimeListener(IListener listener) {
        Set set = listeners;
        synchronized (set) {
            listeners.remove(listener);
        }
    }

    private static void notifyRuntimeListeners() {
        Iterator itr = listeners.iterator();
        while (itr.hasNext()) {
            try {
                ((IListener)itr.next()).handle();
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
        }
    }

    static Set getSupportedFacets(List composition) {
        HashSet result = new HashSet();
        Iterator itr1 = composition.iterator();
        while (itr1.hasNext()) {
            IRuntimeComponent rc = (IRuntimeComponent)itr1.next();
            Iterator itr2 = mappings.iterator();
            while (itr2.hasNext()) {
                Mapping m = (Mapping)itr2.next();
                try {
                    result.addAll(m.getSupportedFacets(rc));
                }
                catch (CoreException e) {
                    FacetCorePlugin.log(e.getStatus());
                }
                catch (VersionFormatException e) {
                    FacetCorePlugin.log(e);
                }
            }
        }
        return result;
    }

    static Set getDefaultFacets(IRuntimeComponentVersion rcv) {
        HashSet result = new HashSet();
        Iterator itr = defaultFacets.iterator();
        while (itr.hasNext()) {
            DefaultFacetsEntry dfe = (DefaultFacetsEntry)itr.next();
            try {
                if (!dfe.match(rcv)) continue;
                result.addAll(dfe.facets);
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static void bridge() {
        modified = false;
        itr1 = RuntimeManagerImpl.bridges.entrySet().iterator();
        block4: while (itr1.hasNext()) {
            block9: {
                entry = itr1.next();
                brid = (String)entry.getKey();
                br = (IRuntimeBridge)entry.getValue();
                existing = new HashMap<String, BridgedRuntime>();
                itr2 = RuntimeManagerImpl.runtimes.iterator();
                while (itr2.hasNext()) {
                    obj = itr2.next();
                    if (!(obj instanceof BridgedRuntime) || !(bridged = (BridgedRuntime)obj).getBridgeId().equals(brid)) continue;
                    existing.put(bridged.getNativeRuntimeId(), bridged);
                }
                try {
                    exported = br.getExportedRuntimeNames();
                    break block9;
                }
                catch (CoreException e) {
                    FacetCorePlugin.log((Exception)e);
                    itr2 = existing.values().iterator();
                    ** while (itr2.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    RuntimeManagerImpl.runtimes.remove(((IRuntime)itr2).getName());
                    modified = true;
                    continue;
lbl26:
                    // 1 sources

                    continue block4;
                }
            }
            itr2 = existing.values().iterator();
            while (itr2.hasNext()) {
                r = (BridgedRuntime)itr2.next();
                if (exported.contains(r.getNativeRuntimeId())) continue;
                RuntimeManagerImpl.runtimes.delete(r.getName());
                modified = true;
            }
            itr2 = exported.iterator();
            while (itr2.hasNext()) {
                id = (String)itr2.next();
                if (existing.containsKey(id)) continue;
                try {
                    stub = br.bridge(id);
                    r = new BridgedRuntime(brid, id, stub);
                    r.setName(RuntimeManagerImpl.createUniqueRuntimeName(id));
                    RuntimeManagerImpl.runtimes.add(r.getName(), r);
                    modified = true;
                }
                catch (CoreException e) {
                    FacetCorePlugin.log((Exception)e);
                }
            }
            if (!modified) continue;
            RuntimeManagerImpl.notifyRuntimeListeners();
        }
    }

    private static String createUniqueRuntimeName(String suggestion) {
        String name = suggestion;
        int i = 1;
        while (runtimes.contains(name)) {
            name = String.valueOf(suggestion) + " (" + i + ")";
            ++i;
        }
        return name;
    }

    private static void readMetadata() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.core", EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                cfgels.add(elements[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        int n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("runtime-component-type")) {
                RuntimeManagerImpl.readRuntimeComponentType(config);
            }
            ++i;
        }
        i = 0;
        n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("runtime-component-version")) {
                RuntimeManagerImpl.readRuntimeComponentVersion(config);
            }
            ++i;
        }
        i = 0;
        n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("adapter")) {
                RuntimeManagerImpl.readAdapter(config);
            }
            ++i;
        }
        i = 0;
        n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("supported")) {
                RuntimeManagerImpl.readMapping(config);
            }
            ++i;
        }
    }

    private static void readRuntimeComponentType(IConfigurationElement config) {
        String id = config.getAttribute("id");
        if (id == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, "id");
            return;
        }
        RuntimeComponentType rct = new RuntimeComponentType();
        rct.setId(id);
        rct.setPluginId(config.getDeclaringExtension().getNamespace());
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("version-comparator")) {
                String clname = child.getAttribute("class");
                if (clname == null) {
                    RuntimeManagerImpl.reportMissingAttribute(child, "class");
                    return;
                }
                rct.setVersionComparator(clname);
            }
            ++i;
        }
        runtimeComponentTypes.add(id, rct);
    }

    private static void readRuntimeComponentVersion(IConfigurationElement config) {
        String type = config.getAttribute("type");
        if (type == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, "type");
            return;
        }
        String ver = config.getAttribute("version");
        if (ver == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, "version");
            return;
        }
        RuntimeComponentType rct = (RuntimeComponentType)runtimeComponentTypes.get(type);
        if (rct == null) {
            String msg = NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)config.getNamespace(), (Object)type);
            FacetCorePlugin.log(msg);
            return;
        }
        RuntimeComponentVersion rcv = new RuntimeComponentVersion();
        rcv.setRuntimeComponentType(rct);
        rcv.setVersionString(ver);
        rcv.setPluginId(config.getDeclaringExtension().getNamespace());
        rct.addVersion(rcv);
    }

    private static void readAdapter(IConfigurationElement config) {
        IRuntimeComponentType rctype = null;
        IRuntimeComponentVersion rcversion = null;
        String factory = null;
        ArrayList<String> types = new ArrayList<String>();
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("runtime-component")) {
                String id = child.getAttribute("id");
                if (id == null) {
                    RuntimeManagerImpl.reportMissingAttribute(child, "id");
                    return;
                }
                if (!RuntimeManagerImpl.isRuntimeComponentTypeDefined(id)) {
                    String msg = NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)child.getNamespace(), (Object)id);
                    FacetCorePlugin.log(msg);
                    return;
                }
                rctype = RuntimeManagerImpl.getRuntimeComponentType(id);
                String version = child.getAttribute("version");
                if (version != null) {
                    if (!rctype.hasVersion(version)) {
                        Object[] params = new String[]{config.getNamespace(), id, version};
                        String msg = NLS.bind((String)Resources.runtimeComponentVersionNotDefined, (Object[])params);
                        FacetCorePlugin.log(msg);
                        return;
                    }
                    rcversion = rctype.getVersion(version);
                }
            } else if (childName.equals("factory")) {
                factory = child.getAttribute("class");
                if (factory == null) {
                    RuntimeManagerImpl.reportMissingAttribute(child, "class");
                    return;
                }
            } else if (childName.equals("type")) {
                String type = child.getAttribute("class");
                if (type == null) {
                    RuntimeManagerImpl.reportMissingAttribute(child, "class");
                    return;
                }
                types.add(type);
            }
            ++i;
        }
        Set<Object> versions = rcversion == null ? rctype.getVersions() : Collections.singleton(rcversion);
        String plugin = config.getDeclaringExtension().getNamespace();
        Iterator<Object> itr1 = versions.iterator();
        while (itr1.hasNext()) {
            RuntimeComponentVersion rcv = itr1.next();
            Iterator itr2 = types.iterator();
            while (itr2.hasNext()) {
                rcv.addAdapterFactory((String)itr2.next(), plugin, factory);
            }
        }
    }

    private static void readMapping(IConfigurationElement config) {
        Mapping m = new Mapping();
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            VersionMatchExpr expr;
            String v;
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("facet")) {
                IProjectFacet f = RuntimeManagerImpl.readProjectFacetRef(child);
                if (f == null) {
                    return;
                }
                v = child.getAttribute("version");
                expr = null;
                if (v != null) {
                    try {
                        expr = new VersionMatchExpr(f, v);
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log(e.getStatus());
                        return;
                    }
                }
                m.facets.put(f, expr);
            } else if (childName.equals("runtime-component") && child.getAttribute("any") == null) {
                IRuntimeComponentType rct = RuntimeManagerImpl.readRuntimeComponentTypeRef(child);
                if (rct == null) {
                    return;
                }
                v = child.getAttribute("version");
                expr = null;
                if (v != null) {
                    try {
                        expr = new VersionMatchExpr(rct, v);
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log(e.getStatus());
                        return;
                    }
                }
                m.runtimeComponents.put(rct, expr);
            }
            ++i;
        }
        mappings.add(m);
    }

    private static void readBridgesExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.core", BRIDGES_EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                cfgels.add(elements[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        int n = cfgels.size();
        while (i < n) {
            block12: {
                IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
                if (config.getName().equals("bridge")) {
                    Object br;
                    String id = config.getAttribute("id");
                    if (id == null) {
                        RuntimeManagerImpl.reportMissingAttribute(config, "id");
                        return;
                    }
                    String clname = config.getAttribute("class");
                    if (clname == null) {
                        RuntimeManagerImpl.reportMissingAttribute(config, "class");
                        return;
                    }
                    String pluginId = config.getNamespace();
                    try {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        br = FacetCorePlugin.instantiate(pluginId, clname, clazz);
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log((Exception)((Object)e));
                        break block12;
                    }
                    bridges.put(id, br);
                }
            }
            ++i;
        }
    }

    private static void readDefaultFacetsExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.core", DEFAULT_FACETS_EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                cfgels.add(elements[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        int n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("default-facets")) {
                RuntimeManagerImpl.readDefaultFacets(config);
            }
            ++i;
        }
    }

    private static void readDefaultFacets(IConfigurationElement config) {
        DefaultFacetsEntry dfe = new DefaultFacetsEntry();
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("runtime-component")) {
                dfe.rct = RuntimeManagerImpl.readRuntimeComponentTypeRef(child);
                if (dfe.rct == null) {
                    return;
                }
                String v = child.getAttribute("version");
                if (v != null) {
                    try {
                        dfe.rcvexpr = new VersionMatchExpr(dfe.rct, v);
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log(e.getStatus());
                        return;
                    }
                }
            } else if (childName.equals("facet")) {
                IProjectFacet f = RuntimeManagerImpl.readProjectFacetRef(child);
                if (f == null) {
                    return;
                }
                String ver = child.getAttribute("version");
                if (ver == null) {
                    RuntimeManagerImpl.reportMissingAttribute(child, "version");
                    return;
                }
                if (!f.hasVersion(ver)) {
                    Object[] args = new String[]{config.getNamespace(), f.getId(), ver};
                    String msg = NLS.bind((String)ProjectFacetsManagerImpl.Resources.facetVersionNotDefined, (Object[])args);
                    FacetCorePlugin.log(msg);
                    return;
                }
                dfe.facets.add(f.getVersion(ver));
            }
            ++i;
        }
        if (dfe.rct == null) {
            return;
        }
        defaultFacets.add(dfe);
    }

    private static IRuntimeComponentType readRuntimeComponentTypeRef(IConfigurationElement config) {
        String id = config.getAttribute("id");
        if (id == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, "id");
            return null;
        }
        if (!RuntimeManagerImpl.isRuntimeComponentTypeDefined(id)) {
            String msg = NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)config.getNamespace(), (Object)id);
            FacetCorePlugin.log(msg);
            return null;
        }
        return RuntimeManagerImpl.getRuntimeComponentType(id);
    }

    private static IProjectFacet readProjectFacetRef(IConfigurationElement config) {
        String id = config.getAttribute("id");
        if (id == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, "id");
            return null;
        }
        if (!ProjectFacetsManager.isProjectFacetDefined(id)) {
            String msg = NLS.bind((String)ProjectFacetsManagerImpl.Resources.facetNotDefined, (Object)config.getNamespace(), (Object)id);
            FacetCorePlugin.log(msg);
            return null;
        }
        return ProjectFacetsManager.getProjectFacet(id);
    }

    private static void reportMissingAttribute(IConfigurationElement el, String attribute) {
        Object[] params = new String[]{el.getNamespace(), el.getName(), attribute};
        String msg = NLS.bind((String)Resources.missingAttribute, (Object[])params);
        FacetCorePlugin.log(msg);
    }

    private static final class Mapping {
        public final Map facets = new HashMap();
        public final Map runtimeComponents = new HashMap();

        private Mapping() {
        }

        private Set getSupportedFacets(IRuntimeComponent rc) throws CoreException {
            VersionMatchExpr expr;
            IRuntimeComponentType rct = rc.getRuntimeComponentType();
            IRuntimeComponentVersion rcv = rc.getRuntimeComponentVersion();
            if (this.runtimeComponents.containsKey(rct) ? (expr = (VersionMatchExpr)this.runtimeComponents.get(rct)) != null && !expr.evaluate((IVersion)((Object)rcv)) : !this.runtimeComponents.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            HashSet<IProjectFacetVersion> result = new HashSet<IProjectFacetVersion>();
            Iterator itr1 = this.facets.entrySet().iterator();
            while (itr1.hasNext()) {
                Map.Entry entry = itr1.next();
                IProjectFacet f = (IProjectFacet)entry.getKey();
                VersionMatchExpr expr2 = (VersionMatchExpr)entry.getValue();
                Iterator itr2 = f.getVersions().iterator();
                while (itr2.hasNext()) {
                    IProjectFacetVersion fv = (IProjectFacetVersion)itr2.next();
                    if (expr2 != null && !expr2.evaluate((IVersion)((Object)fv))) continue;
                    result.add(fv);
                }
            }
            return result;
        }
    }

    private static final class DefaultFacetsEntry {
        public IRuntimeComponentType rct;
        public VersionMatchExpr rcvexpr;
        public final Set facets = new HashSet();

        private DefaultFacetsEntry() {
        }

        public boolean match(IRuntimeComponentVersion rcv) throws CoreException {
            if (rcv.getRuntimeComponentType() != this.rct) {
                return false;
            }
            return this.rcvexpr.evaluate((IVersion)((Object)rcv));
        }
    }

    public static final class Resources
    extends NLS {
        public static String missingAttribute;
        public static String runtimeComponentTypeNotDefined;
        public static String runtimeComponentVersionNotDefined;
        public static String runtimeComponentVersionNotDefinedNoPlugin;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeManagerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeManagerImpl$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }
    }
}

