/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogProcedure;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogTable;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogUserDefinedFunction;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogView;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.routines.SQLRoutinesPackage;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.SchemaImpl;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class DerbyCatalogSchema
extends SchemaImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257285846544429880L;
    private boolean tablesLoaded = false;
    private boolean routineLoaded = false;

    public synchronized void refresh() {
        this.tablesLoaded = false;
        this.routineLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getTables() {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tables;
    }

    public EList getRoutines() {
        if (!this.routineLoaded) {
            this.loadRoutines();
        }
        return this.routines;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getTables();
        } else if (id == 13) {
            this.getRoutines();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadTables() {
        boolean hasFilter;
        ConnectionFilter viewFilter;
        if (this.tablesLoaded) {
            return;
        }
        EList tableList = super.getTables();
        Object[] oldList = tableList.toArray();
        tableList.clear();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        ConnectionInfo connectionInfo = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo((SQLObject)this.getDatabase());
        ConnectionFilter tableFilter = connectionInfo.getFilter(String.valueOf(this.getName()) + "::" + "DatatoolsTableFilterPredicate");
        if (tableFilter == null) {
            tableFilter = connectionInfo.getFilter("DatatoolsTableFilterPredicate");
        }
        if ((viewFilter = connectionInfo.getFilter(String.valueOf(this.getName()) + "::" + "DatatoolsViewFilterPredicate")) == null) {
            viewFilter = connectionInfo.getFilter("DatatoolsViewFilterPredicate");
        }
        String filterStr = "";
        boolean bl = hasFilter = tableFilter != null || viewFilter != null;
        if (hasFilter) {
            filterStr = tableFilter != null ? String.valueOf(filterStr) + "TABLENAME " + tableFilter.getPredicate() + " AND TABLETYPE='T' OR TABLETYPE='S'" : String.valueOf(filterStr) + "TABLETYPE='T' OR TABLETYPE='S'";
            if (viewFilter != null) {
                if (filterStr.length() > 0) {
                    filterStr = String.valueOf(filterStr) + " OR ";
                }
                filterStr = String.valueOf(filterStr) + "TABLENAME " + viewFilter.getPredicate() + " AND TABLETYPE='V' ";
            } else {
                filterStr = String.valueOf(filterStr) + " OR TABLETYPE='V' ";
            }
            filterStr = " AND (" + filterStr;
            filterStr = String.valueOf(filterStr) + ") ";
        }
        String query = "SELECT TABLENAME,TABLETYPE FROM SYS.SYSTABLES A,SYS.SYSSCHEMAS B WHERE A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME='" + this.getName() + "'";
        if (hasFilter) {
            query = String.valueOf(query) + filterStr;
        }
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                Object table;
                String tableName = r.getString("TABLENAME");
                String type = r.getString("TABLETYPE");
                EClass metaclass = null;
                if (type.equals("T") || type.equals("S")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getPersistentTable();
                } else if (type.equals("V")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getViewTable();
                }
                Object element = DerbyCatalogSchema.findElement(oldList, tableName, metaclass);
                if (element != null) {
                    table = (Table)element;
                    tableList.add(table);
                    ((ICatalogObject)table).refresh();
                    continue;
                }
                if (type.equals("T") || type.equals("S")) {
                    table = new DerbyCatalogTable();
                } else {
                    if (!type.equals("V")) continue;
                    table = new DerbyCatalogView();
                }
                table.setName(tableName);
                tableList.add(table);
            }
            this.tablesLoaded = true;
            r.close();
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private synchronized void loadRoutines() {
        if (this.routineLoaded) {
            return;
        }
        EList routineList = super.getRoutines();
        Object[] oldList = routineList.toArray();
        routineList.clear();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT ALIAS,ALIASTYPE FROM SYS.SYSALIASES A,SYS.SYSSCHEMAS B WHERE A.ALIASTYPE IN ('P','F') AND A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME='" + this.getName() + "'";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                Object routine;
                String routineName = r.getString("ALIAS");
                String type = r.getString("ALIASTYPE");
                EClass metaclass = null;
                if (type.equals("P")) {
                    metaclass = SQLRoutinesPackage.eINSTANCE.getProcedure();
                } else if (type.equals("F")) {
                    metaclass = SQLRoutinesPackage.eINSTANCE.getUserDefinedFunction();
                }
                Object element = DerbyCatalogSchema.findElement(oldList, routineName, metaclass);
                if (element != null) {
                    routine = (Routine)element;
                    ((ICatalogObject)routine).refresh();
                } else {
                    if (type.equals("P")) {
                        routine = new DerbyCatalogProcedure();
                    } else {
                        if (!type.equals("F")) continue;
                        routine = new DerbyCatalogUserDefinedFunction();
                    }
                    routine.setName(routineName);
                }
                routineList.add(routine);
            }
            this.routineLoaded = true;
            r.close();
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    protected static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        int i = 0;
        while (i < list.length) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == metaclass) {
                object = list[i];
                break;
            }
            ++i;
        }
        return object;
    }
}

