/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import java.io.CharArrayReader;
import java.io.Reader;
import java.text.Collator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.w3c.dom.Node;

public class StyledTextColorPicker
extends Composite {
    public static final String BACKGROUND = "background";
    public static final String BOLD = "bold";
    public static final String COLOR = "color";
    public static final String FOREGROUND = "foreground";
    public static final String ITALIC = "italic";
    public static final String NAME = "name";
    protected static final boolean showItalic = false;
    protected AccessibleControlListener backgroundAccListener = new AccessibleControlAdapter(){

        public void getValue(AccessibleControlEvent e) {
            if (e.childID == -1) {
                e.result = StyledTextColorPicker.this.getColorButtonValue(StyledTextColorPicker.this.fBackground);
            }
        }
    };
    protected SelectionListener buttonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            String namedStyle = StyledTextColorPicker.this.getStyleName(StyledTextColorPicker.this.fStyleCombo.getItem(StyledTextColorPicker.this.fStyleCombo.getSelectionIndex()));
            if (namedStyle == null) {
                return;
            }
            if (e.widget == StyledTextColorPicker.this.fForeground) {
                String oldValue;
                String newValue;
                String prefString = StyledTextColorPicker.this.getPreferenceStore().getString(StyledTextColorPicker.this.getPreferenceKey(namedStyle));
                String[] stylePrefs = ColorHelper.unpackStylePreferences(prefString);
                if (stylePrefs != null && !(newValue = StyledTextColorPicker.this.changeColor(oldValue = stylePrefs[0])).equals(oldValue)) {
                    stylePrefs[0] = newValue;
                    String newPrefString = ColorHelper.packStylePreferences(stylePrefs);
                    StyledTextColorPicker.this.getPreferenceStore().setValue(StyledTextColorPicker.this.getPreferenceKey(namedStyle), newPrefString);
                    StyledTextColorPicker.this.refresh();
                }
            } else if (e.widget == StyledTextColorPicker.this.fBackground) {
                String oldValue;
                String newValue;
                String prefString = StyledTextColorPicker.this.getPreferenceStore().getString(StyledTextColorPicker.this.getPreferenceKey(namedStyle));
                String[] stylePrefs = ColorHelper.unpackStylePreferences(prefString);
                if (stylePrefs != null && !(newValue = StyledTextColorPicker.this.changeColor(oldValue = stylePrefs[1])).equals(oldValue)) {
                    stylePrefs[1] = newValue;
                    String newPrefString = ColorHelper.packStylePreferences(stylePrefs);
                    StyledTextColorPicker.this.getPreferenceStore().setValue(StyledTextColorPicker.this.getPreferenceKey(namedStyle), newPrefString);
                    StyledTextColorPicker.this.refresh();
                }
            } else if (e.widget == StyledTextColorPicker.this.fBold) {
                String prefString = StyledTextColorPicker.this.getPreferenceStore().getString(StyledTextColorPicker.this.getPreferenceKey(namedStyle));
                String[] stylePrefs = ColorHelper.unpackStylePreferences(prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[2];
                    String newValue = String.valueOf(StyledTextColorPicker.this.fBold.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[2] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences(stylePrefs);
                        StyledTextColorPicker.this.getPreferenceStore().setValue(StyledTextColorPicker.this.getPreferenceKey(namedStyle), newPrefString);
                        StyledTextColorPicker.this.refresh();
                    }
                }
            } else if (e.widget == StyledTextColorPicker.this.fClearStyle) {
                StyledTextColorPicker.this.getPreferenceStore().setToDefault(StyledTextColorPicker.this.getPreferenceKey(namedStyle));
                StyledTextColorPicker.this.refresh();
            }
        }
    };
    protected SelectionListener comboListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectedIndex = StyledTextColorPicker.this.fStyleCombo.getSelectionIndex();
            String description = selectedIndex >= 0 ? StyledTextColorPicker.this.fStyleCombo.getItem(selectedIndex) : null;
            StyledTextColorPicker.this.activate(StyledTextColorPicker.this.getStyleName(description));
        }
    };
    protected Button fBackground;
    protected Label fBackgroundLabel;
    protected Button fBold;
    protected Button fClearStyle;
    protected Dictionary fContextStyleMap = null;
    protected Color fDefaultBackground = this.getDisplay().getSystemColor(25);
    protected Color fDefaultForeground = this.getDisplay().getSystemColor(24);
    protected Dictionary fDescriptions = null;
    protected Button fForeground;
    protected Label fForegroundLabel;
    protected String fInput = "";
    protected Button fItalic;
    private IStructuredDocumentRegion fNodes = null;
    protected AccessibleControlListener foregroundAccListener = new AccessibleControlAdapter(){

        public void getValue(AccessibleControlEvent e) {
            if (e.childID == -1) {
                e.result = StyledTextColorPicker.this.getColorButtonValue(StyledTextColorPicker.this.fForeground);
            }
        }
    };
    protected RegionParser fParser = null;
    private IPreferenceStore fPreferenceStore;
    protected Combo fStyleCombo = null;
    protected List fStyleList = null;
    protected StyledText fText = null;

    public StyledTextColorPicker(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.createControls(this);
    }

    protected void activate(String namedStyle) {
        if (namedStyle == null) {
            this.fForeground.setEnabled(false);
            this.fBackground.setEnabled(false);
            this.fClearStyle.setEnabled(false);
            this.fBold.setEnabled(false);
            this.fForegroundLabel.setEnabled(false);
            this.fBackgroundLabel.setEnabled(false);
        } else {
            this.fForeground.setEnabled(true);
            this.fBackground.setEnabled(true);
            this.fClearStyle.setEnabled(true);
            this.fBold.setEnabled(true);
            this.fForegroundLabel.setEnabled(true);
            this.fBackgroundLabel.setEnabled(true);
        }
        TextAttribute attribute = this.getAttribute(namedStyle);
        Color color = attribute.getForeground();
        if (color == null) {
            color = this.fDefaultForeground;
        }
        if (!(this.fForeground.getSize().x <= 0 || this.fForeground.getSize().y <= 0 || this.fForeground.getImage() != null && this.fForeground.getImage().getImageData() != null && this.fForeground.getImage().getImageData().getRGBs() != null && this.fForeground.getImage().getImageData().getRGBs().length >= 1 && this.fForeground.getImage().getImageData().getRGBs()[0].equals((Object)color.getRGB()))) {
            if (this.fForeground.getImage() != null) {
                this.fForeground.getImage().dispose();
            }
            Image foreground = new Image((Device)this.getDisplay(), new ImageData(this.fForeground.getSize().x, this.fForeground.getSize().y, 1, new PaletteData(new RGB[]{color.getRGB()})));
            this.fForeground.setImage(foreground);
        }
        if ((color = attribute.getBackground()) == null) {
            color = this.fDefaultBackground;
        }
        if (!(this.fBackground.getSize().x <= 0 || this.fBackground.getSize().y <= 0 || this.fBackground.getImage() != null && this.fBackground.getImage().getImageData() != null && this.fBackground.getImage().getImageData().getRGBs() != null && this.fBackground.getImage().getImageData().getRGBs().length >= 1 && this.fBackground.getImage().getImageData().getRGBs()[0].equals((Object)color.getRGB()))) {
            if (this.fBackground.getImage() != null) {
                this.fBackground.getImage().dispose();
            }
            Image background = new Image((Device)this.getDisplay(), new ImageData(this.fBackground.getSize().x, this.fBackground.getSize().y, 1, new PaletteData(new RGB[]{color.getRGB()})));
            this.fBackground.setImage(background);
        }
        this.fBold.setSelection((attribute.getStyle() & 1) != 0);
    }

    protected void applyStyles() {
        if (this.fText == null || this.fText.isDisposed() || this.fInput == null || this.fInput.length() == 0) {
            return;
        }
        IStructuredDocumentRegion node = this.fNodes;
        while (node != null) {
            ITextRegionList regions = node.getRegions();
            int i = 0;
            while (i < regions.size()) {
                TextAttribute attribute;
                ITextRegion currentRegion = regions.get(i);
                String namedStyle = (String)this.getContextStyleMap().get(currentRegion.getType());
                if (namedStyle != null && (attribute = this.getAttribute(namedStyle)) != null) {
                    StyleRange style = new StyleRange(node.getStartOffset(currentRegion), currentRegion.getLength(), attribute.getForeground(), attribute.getBackground(), attribute.getStyle());
                    this.fText.setStyleRange(style);
                }
                ++i;
            }
            node = node.getNext();
        }
    }

    private RGB changeColor(RGB startValue) {
        ColorDialog colorDlg = new ColorDialog(this.getShell());
        if (startValue != null) {
            colorDlg.setRGB(startValue);
        }
        if (colorDlg.getText() == null || colorDlg.getText().length() == 0) {
            colorDlg.setText(SSEUIMessages.StyledTextColorPicker_0);
        }
        colorDlg.open();
        RGB newRGB = colorDlg.getRGB();
        if (newRGB != null) {
            return newRGB;
        }
        return startValue;
    }

    private String changeColor(String rgb) {
        String changedColor = "null";
        RGB newColor = this.changeColor(ColorHelper.toRGB(rgb));
        if (newColor != null) {
            changedColor = ColorHelper.toRGBString(newColor);
        }
        return changedColor;
    }

    protected void close() {
    }

    private Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height + 4);
        return p;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 0x1000020);
        if (label != null) {
            button.setText(label);
        }
        GridData data = new GridData(1808);
        data.horizontalAlignment = 128;
        button.setLayoutData((Object)data);
        return button;
    }

    private Combo createCombo(Composite parent, String[] labels, int selectedItem) {
        Combo combo = new Combo(parent, 12);
        combo.setItems(labels);
        if (selectedItem >= 0) {
            combo.select(selectedItem);
        }
        GridData data = new GridData(768);
        data.horizontalAlignment = 256;
        combo.setLayoutData((Object)data);
        return combo;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.horizontalSpacing = 5;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1040);
        data.grabExcessVerticalSpace = false;
        data.verticalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void createControls(Composite parent) {
        Composite styleRow = this.createComposite(parent, 3);
        this.createLabel(styleRow, SSEUIMessages.Content_type__UI_);
        this.fStyleCombo = this.createCombo(styleRow, new String[0], -1);
        this.fClearStyle = this.createPushButton(styleRow, SSEUIMessages.Restore_Default_UI_);
        Composite styleRow2 = this.createComposite(parent, 6);
        this.fForegroundLabel = this.createLabel(styleRow2, SSEUIMessages.Foreground_UI_);
        this.fForeground = this.createPushButton(styleRow2, "");
        this.setAccessible((Control)this.fForeground, this.fForegroundLabel.getText());
        this.fForeground.getAccessible().addAccessibleControlListener(this.foregroundAccListener);
        Point buttonSize = this.computeImageSize((Control)parent);
        ((GridData)this.fForeground.getLayoutData()).widthHint = buttonSize.x;
        ((GridData)this.fForeground.getLayoutData()).heightHint = buttonSize.y;
        this.fBackgroundLabel = this.createLabel(styleRow2, SSEUIMessages.Background_UI_);
        this.fBackground = this.createPushButton(styleRow2, "");
        this.setAccessible((Control)this.fBackground, this.fBackgroundLabel.getText());
        this.fBackground.getAccessible().addAccessibleControlListener(this.backgroundAccListener);
        ((GridData)this.fBackground.getLayoutData()).widthHint = buttonSize.x;
        ((GridData)this.fBackground.getLayoutData()).heightHint = buttonSize.y;
        this.createLabel(styleRow2, "");
        this.fBold = this.createCheckBox(styleRow2, SSEUIMessages.Bold_UI_);
        this.fForeground.setEnabled(false);
        this.fBackground.setEnabled(false);
        this.fClearStyle.setEnabled(false);
        this.fBold.setEnabled(false);
        this.fForegroundLabel.setEnabled(false);
        this.fBackgroundLabel.setEnabled(false);
        Composite sample = this.createComposite(parent, 1);
        this.createLabel(sample, SSEUIMessages.Sample_text__UI_);
        this.fText = new StyledText(sample, 2826);
        GridData data = new GridData(1808);
        this.fText.setLayoutData((Object)data);
        this.fText.setEditable(false);
        this.fText.setBackground(this.fDefaultBackground);
        this.fText.setFont(JFaceResources.getTextFont());
        this.fText.addKeyListener(this.getTextKeyListener());
        this.fText.addSelectionListener(this.getTextSelectionListener());
        this.fText.addMouseListener(this.getTextMouseListener());
        this.fText.addTraverseListener(this.getTraverseListener());
        this.setAccessible((Control)this.fText, SSEUIMessages.Sample_text__UI_);
        this.fForeground.addSelectionListener(this.buttonListener);
        this.fBackground.addSelectionListener(this.buttonListener);
        this.fClearStyle.addSelectionListener(this.buttonListener);
        this.fBold.addSelectionListener(this.buttonListener);
        this.fStyleCombo.addSelectionListener(this.comboListener);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData(1808);
        button.setLayoutData((Object)data);
        return button;
    }

    protected TextAttribute getAttribute(String namedStyle) {
        String prefString;
        String[] stylePrefs;
        TextAttribute ta = new TextAttribute(this.getDefaultForeground(), this.getDefaultBackground(), 0);
        if (namedStyle != null && this.getPreferenceStore() != null && (stylePrefs = ColorHelper.unpackStylePreferences(prefString = this.getPreferenceStore().getString(this.getPreferenceKey(namedStyle)))) != null) {
            RGB foreground = ColorHelper.toRGB(stylePrefs[0]);
            RGB background = ColorHelper.toRGB(stylePrefs[1]);
            int fontModifier = 0;
            boolean bold = Boolean.valueOf(stylePrefs[2]);
            if (bold) {
                fontModifier |= 1;
            }
            ta = new TextAttribute(foreground != null ? EditorUtility.getColor(foreground) : null, background != null ? EditorUtility.getColor(background) : null, fontModifier);
        }
        return ta;
    }

    private String getColorButtonValue(Button b) {
        if (b == null || b.getImage() == null || b.getImage().getImageData() == null || b.getImage().getImageData().getRGBs() == null || b.getImage().getImageData().getRGBs()[0] == null) {
            return null;
        }
        String val = b.getImage().getImageData().getRGBs()[0].toString();
        return val;
    }

    public Node getColorsNode() {
        return null;
    }

    public Dictionary getContextStyleMap() {
        return this.fContextStyleMap;
    }

    public Color getDefaultBackground() {
        return this.fDefaultBackground;
    }

    public Color getDefaultForeground() {
        return this.fDefaultForeground;
    }

    public Dictionary getDescriptions() {
        return this.fDescriptions;
    }

    public Font getFont() {
        return this.fText.getFont();
    }

    protected String getNamedStyleAtOffset(int offset) {
        if (offset >= this.fInput.length()) {
            return this.getNamedStyleAtOffset(this.fInput.length() - 1);
        }
        if (offset < 0) {
            return this.getNamedStyleAtOffset(0);
        }
        if (this.fNodes == null) {
            return null;
        }
        IStructuredDocumentRegion aNode = this.fNodes;
        while (aNode != null && !aNode.containsOffset(offset)) {
            aNode = aNode.getNext();
        }
        if (aNode != null) {
            ITextRegion interest = aNode.getRegionAtCharacterOffset(offset);
            if (interest == null) {
                return null;
            }
            if (offset > aNode.getTextEndOffset(interest)) {
                return null;
            }
            String regionContext = interest.getType();
            if (regionContext == null) {
                return null;
            }
            String namedStyle = (String)this.getContextStyleMap().get(regionContext);
            if (namedStyle != null) {
                return namedStyle;
            }
        }
        return null;
    }

    public RegionParser getParser() {
        return this.fParser;
    }

    private String getPreferenceKey(String key) {
        String newKey = key;
        return newKey;
    }

    private IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    public List getStyleList() {
        return this.fStyleList;
    }

    private String getStyleName(String description) {
        if (description == null) {
            return null;
        }
        String styleName = null;
        Enumeration keys = this.getDescriptions().keys();
        while (keys.hasMoreElements()) {
            String test = keys.nextElement().toString();
            if (!this.getDescriptions().get(test).equals(description)) continue;
            styleName = test;
            break;
        }
        return styleName;
    }

    public String getText() {
        return this.fInput;
    }

    private KeyListener getTextKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    StyledTextColorPicker.this.selectColorAtOffset(x);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    StyledTextColorPicker.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private MouseListener getTextMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    StyledTextColorPicker.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private SelectionListener getTextSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StyledTextColorPicker.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                StyledTextColorPicker.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }
        };
    }

    private TraverseListener getTraverseListener() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.widget instanceof StyledText && (e.detail == 16 || e.detail == 8)) {
                    e.doit = true;
                }
            }
        };
    }

    public void refresh() {
        this.fText.setRedraw(false);
        int selectedIndex = this.fStyleCombo.getSelectionIndex();
        String description = selectedIndex >= 0 ? this.fStyleCombo.getItem(selectedIndex) : null;
        this.activate(this.getStyleName(description));
        this.fText.setFont(JFaceResources.getTextFont());
        this.applyStyles();
        this.fText.setRedraw(true);
    }

    public void releasePickerResources() {
        if (this.fForeground != null && !this.fForeground.isDisposed() && this.fForeground.getImage() != null) {
            this.fForeground.getImage().dispose();
        }
        if (this.fBackground != null && !this.fBackground.isDisposed() && this.fBackground.getImage() != null) {
            this.fBackground.getImage().dispose();
        }
    }

    private void selectColorAtOffset(int offset) {
        String namedStyle = this.getNamedStyleAtOffset(offset);
        if (namedStyle == null) {
            this.fStyleCombo.deselectAll();
            this.activate(null);
            return;
        }
        String description = (String)this.getDescriptions().get(namedStyle);
        if (description == null) {
            return;
        }
        int itemCount = this.fStyleCombo.getItemCount();
        int i = 0;
        while (i < itemCount) {
            if (this.fStyleCombo.getItem(i).equals(description)) {
                this.fStyleCombo.select(i);
                break;
            }
            ++i;
        }
        this.activate(namedStyle);
    }

    private void setAccessible(Control control, String name) {
        if (control == null) {
            return;
        }
        final String n = name;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = n;
                }
            }
        });
    }

    public void setColorsNode(Node newColorsNode) {
    }

    public void setContextStyleMap(Dictionary newContextStyleMap) {
        this.fContextStyleMap = newContextStyleMap;
    }

    public void setDefaultBackground(Color newDefaultBackground) {
        this.fDefaultBackground = newDefaultBackground;
    }

    public void setDefaultColorsNode(Node newDefaultColorsNode) {
    }

    public void setDefaultForeground(Color newDefaultForeground) {
        this.fDefaultForeground = newDefaultForeground;
    }

    public void setDescriptions(Dictionary newDescriptions) {
        this.fDescriptions = newDescriptions;
        this.updateStyleList();
    }

    public void setFont(Font font) {
        this.fText.setFont(font);
        this.fText.redraw();
    }

    public void setGeneratorKey(String key) {
    }

    public void setParser(RegionParser newParser) {
        this.fParser = newParser;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.fPreferenceStore = store;
    }

    public void setStyleList(List newStyleList) {
        this.fStyleList = newStyleList;
        this.updateStyleList();
    }

    public void setText(String s) {
        this.fInput = s;
        this.getParser().reset((Reader)new CharArrayReader(this.fInput.toCharArray()));
        this.fNodes = this.getParser().getDocumentRegions();
        if (this.fText != null) {
            this.fText.setText(s);
        }
        this.applyStyles();
    }

    RGB toRGB(String anRGBString, RGB defaultRGB) {
        RGB result = ColorHelper.toRGB(anRGBString);
        if (result == null) {
            return defaultRGB;
        }
        return result;
    }

    private void updateStyleList() {
        if (this.fStyleList == null || this.fDescriptions == null) {
            return;
        }
        Object[] descriptions = new String[this.fStyleList.size()];
        int i = 0;
        while (i < this.fStyleList.size()) {
            descriptions[i] = this.fStyleList.get(i) != null ? (String)this.getDescriptions().get(this.fStyleList.get(i)) : (String)this.fStyleList.get(i);
            ++i;
        }
        Object[] sortedObjects = new DescriptionSorter().sort(descriptions);
        String[] sortedDescriptions = new String[descriptions.length];
        int i2 = 0;
        while (i2 < descriptions.length) {
            sortedDescriptions[i2] = sortedObjects[i2].toString();
            ++i2;
        }
        this.fStyleCombo.setItems(sortedDescriptions);
        this.fStyleCombo.select(0);
    }

    protected class DescriptionSorter
    extends Sorter {
        Collator collator = Collator.getInstance();

        protected DescriptionSorter() {
        }

        public boolean compare(Object elementOne, Object elementTwo) {
            return this.collator.compare(elementOne.toString(), elementTwo.toString()) < 0;
        }
    }
}

