/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.InlineConstantAction;
import org.eclipse.jdt.internal.ui.refactoring.actions.InlineMethodAction;
import org.eclipse.jdt.ui.actions.InlineTempAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class InlineAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private final InlineTempAction fInlineTemp;
    private final InlineMethodAction fInlineMethod;
    private final InlineConstantAction fInlineConstant;

    public InlineAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.InlineAction_Inline);
        this.fInlineTemp = new InlineTempAction(site);
        this.fInlineConstant = new InlineConstantAction(site);
        this.fInlineMethod = new InlineMethodAction(site);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.inline_action");
    }

    public InlineAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.InlineAction_Inline);
        this.fEditor = editor;
        this.fInlineTemp = new InlineTempAction(editor);
        this.fInlineConstant = new InlineConstantAction(editor);
        this.fInlineMethod = new InlineMethodAction(editor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.inline_action");
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(ISelection selection) {
        this.fInlineConstant.update(selection);
        this.fInlineMethod.update(selection);
        this.fInlineTemp.update(selection);
        this.setEnabled(this.fInlineTemp.isEnabled() || this.fInlineConstant.isEnabled() || this.fInlineMethod.isEnabled());
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        ICompilationUnit cu = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        if (cu == null) {
            return;
        }
        CompilationUnit node = new RefactoringASTParser(3).parse(cu, true);
        if (this.fInlineTemp.isEnabled() && this.fInlineTemp.tryInlineTemp(cu, node, selection, this.getShell())) {
            return;
        }
        if (this.fInlineConstant.isEnabled() && this.fInlineConstant.tryInlineConstant(cu, node, selection, this.getShell())) {
            return;
        }
        if (this.fInlineMethod.isEnabled() && this.fInlineMethod.tryInlineMethod(cu, node, selection, this.getShell())) {
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.InlineAction_dialog_title, (String)RefactoringMessages.InlineAction_select);
    }

    public void run(IStructuredSelection selection) {
        if (this.fInlineConstant.isEnabled()) {
            this.fInlineConstant.run(selection);
        } else if (this.fInlineMethod.isEnabled()) {
            this.fInlineMethod.run(selection);
        } else {
            Assert.isTrue(!this.fInlineTemp.isEnabled());
        }
    }
}

