/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on May 10, 2004
 * 
 * TODO To change the template for this generated file go to Window -
 * Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.jst.common.navigator.internal.actions;

import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonMenuConstants;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;


/**  
 */
public class EditActionsNavigatorExtension extends CommonActionProvider implements ICommonActionProvider {

	private IWorkbenchAction cutAction;
	private IWorkbenchAction copyAction;
	private IWorkbenchAction pasteAction;
	private IWorkbenchAction deleteAction;

	private CCPActionGroup ccpActionGroup;

	public EditActionsNavigatorExtension() {
		//Default constructor
	}

	/* (non-Javadoc)
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#init(org.eclipse.ui.IViewPart, org.eclipse.jface.viewers.StructuredViewer, org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentService)
	 */
	public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {

		cutAction = ActionFactory.CUT.create(aViewPart.getViewSite().getWorkbenchWindow());
		copyAction = ActionFactory.COPY.create(aViewPart.getViewSite().getWorkbenchWindow());
		pasteAction = ActionFactory.PASTE.create(aViewPart.getViewSite().getWorkbenchWindow());
		deleteAction = ActionFactory.DELETE.create(aViewPart.getViewSite().getWorkbenchWindow());


		/*
		 * Since these actions are created after the view is activated, we must supplement the
		 * lifecycle by forcing their activation
		 */
		((RetargetAction) cutAction).partActivated(aViewPart);
		((RetargetAction) copyAction).partActivated(aViewPart);
		((RetargetAction) pasteAction).partActivated(aViewPart);
		((RetargetAction) deleteAction).partActivated(aViewPart);

		ccpActionGroup = new CCPActionGroup(aViewPart);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#setActionContext(org.eclipse.ui.actions.ActionContext)
	 */
	public void setActionContext(ActionContext aContext) {
		ccpActionGroup.setContext(aContext);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#fillActionBars(org.eclipse.ui.IActionBars)
	 */
	public boolean fillActionBars(IActionBars theActionBars) {
		ccpActionGroup.fillActionBars(theActionBars);
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public boolean fillContextMenu(IMenuManager aMenu) {
		if (deleteAction.isEnabled())
			aMenu.insertAfter(ICommonMenuConstants.COMMON_MENU_EDIT_ACTIONS, deleteAction);
		if (pasteAction.isEnabled())
			aMenu.insertAfter(ICommonMenuConstants.COMMON_MENU_EDIT_ACTIONS, pasteAction);
		if (copyAction.isEnabled())
			aMenu.insertAfter(ICommonMenuConstants.COMMON_MENU_EDIT_ACTIONS, copyAction);
		if (cutAction.isEnabled())
			aMenu.insertAfter(ICommonMenuConstants.COMMON_MENU_EDIT_ACTIONS, cutAction);
		return cutAction.isEnabled() || copyAction.isEnabled() || pasteAction.isEnabled() || deleteAction.isEnabled();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.NavigatorActionsExtension#dispose()
	 */
	public void dispose() {
		cutAction.dispose();
		copyAction.dispose();
		pasteAction.dispose();
		deleteAction.dispose();
		ccpActionGroup.dispose();
	}

}
