/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Mar 25, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.common.navigator.internal.plugin.NavigatorPlugin;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

/**
 * @author Admin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CommonWorkingSetDescriptorRegistry {

	private static final CommonWorkingSetProviderRegistry INSTANCE = new CommonWorkingSetProviderRegistry();
	private static boolean isInitialized = false;
	private static final String[] NO_DESCRIPTORS = new String[0];
	private List commonWorkingSetDescriptors = new ArrayList();

	/**
	 * 
	 */
	public CommonWorkingSetDescriptorRegistry() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	public void init() {
		new CommonWorkingSetRegistryReader().readRegistry();
	}

	/**
	 *  
	 */
	public static CommonWorkingSetProviderRegistry getInstance() {
		if (isInitialized)
			return INSTANCE;
		synchronized (INSTANCE) {
			if (!isInitialized) {
				INSTANCE.init();
				isInitialized = true;
			}
		}
		return INSTANCE;
	}
	
	/**
	 * @param aDesc
	 */
	private void addCommonWorkingSetDescriptor(CommonWorkingSetProviderDescriptor aDesc) {
		if (aDesc == null)
			return;
		synchronized (commonWorkingSetDescriptors) {
			boolean bValue = commonWorkingSetDescriptors.contains(aDesc);
			if (bValue == false) {
				commonWorkingSetDescriptors.add(aDesc);
			}
		}
	}
	
	public CommonWorkingSetProviderDescriptor[] getCommonWorkingSetDescriptors() {
		CommonWorkingSetProviderDescriptor[] descriptors = new CommonWorkingSetProviderDescriptor[commonWorkingSetDescriptors.size()];
		return (CommonWorkingSetProviderDescriptor[])commonWorkingSetDescriptors.toArray(descriptors);
		
	}
	
	/*public boolean containsId(String id) {
		CommonWorkingSetProviderDescriptor descriptor = null;
		for (int x=0; x< commonWorkingSetDescriptors.size(); ++x) {
			descriptor = (CommonWorkingSetProviderDescriptor)commonWorkingSetDescriptors.get(x);
			if (descriptor.getId().equals(id)) 
				return true;
		}
		return false;
	}*/
	
	class CommonWorkingSetRegistryReader extends RegistryReader {

		private static final String COMMON_WORKING_SET = "workingSetProviders"; //$NON-NLS-1$


		CommonWorkingSetRegistryReader() {
			super(NavigatorPlugin.PLUGIN_ID, COMMON_WORKING_SET);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader#readElement(org.eclipse.core.runtime.IConfigurationElement)
		 */
		protected boolean readElement(IConfigurationElement anElement) {
			if (COMMON_WORKING_SET.equals(anElement.getName())) {
				try {
					addCommonWorkingSetDescriptor(new CommonWorkingSetProviderDescriptor(anElement));
					return true;
				} catch (WorkbenchException e) {
					//	 log an error since its not safe to open a dialog here
					WorkbenchNavigatorPlugin.log("Unable to create common working set descriptor.", e.getStatus());//$NON-NLS-1$
				}
			}
			return false;
		}
	}

}
