/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Dec 2, 2003
 * 
 * To change the template for this generated file go to Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.wst.common.navigator.internal.groups;

import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IPluginContribution;

/**
 * @author jlanuti
 * 
 * To change the template for this generated type comment go to Window>Preferences>Java>Code
 * Generation>Code and Comments
 */
public class NavigatorGroup implements IActionFilter { // IAdaptable,
	private static final String PROJECT_NATURE = "projectNature"; //$NON-NLS-1$
	protected String pluginID;
	protected String displayName = null;
	protected String natureID = null;
	protected String icon = null;
	protected boolean exclude = false;
	protected int sortOrder = 0;
	protected IPluginContribution contribution;

	/**
	 * default constructor
	 */
	public NavigatorGroup(String pluginID, String displayName, String natureID, String icon, String exclude, int sortOrder, IPluginContribution contribution) {
		this.pluginID = pluginID;
		this.displayName = displayName;
		this.natureID = natureID;
		this.icon = icon;
		this.sortOrder = sortOrder;
		if (exclude != null && exclude.equals("true")) //$NON-NLS-1$
			this.exclude = true;
		this.contribution = contribution;
	}

	/**
	 * @return Returns the sortOrder.
	 */
	public int getSortOrder() {
		return sortOrder;
	}

	/**
	 * @param sortOrder
	 *            The sortOrder to set.
	 */
	protected void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}

	/**
	 * @return displayName
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @return natureId
	 */
	public String getNatureID() {
		return natureID;
	}

	/**
	 * @param string
	 */
	public void setDisplayName(String string) {
		displayName = string;
	}

	/**
	 * @param string
	 */
	public void setNatureID(String string) {
		natureID = string;
	}

	/**
	 * @return icon
	 */
	public String getIcon() {
		return icon;
	}

	/**
	 * @param string
	 */
	public void setIcon(String string) {
		icon = string;
	}

	public String toString() {
		return "NavigatorGroup[displayName=" + getDisplayName() + ", natureID=" + getNatureID() + "]"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	/**
	 * @return Returns the pluginID.
	 */
	public String getPluginID() {
		return pluginID;
	}

	//	/* (non-Javadoc)
	//	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	//	 */
	//	public Object getAdapter(Class adapter) {
	//		
	//		return null;
	//	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionFilter#testAttribute(java.lang.Object, java.lang.String,
	 *      java.lang.String)
	 */
	public boolean testAttribute(Object target, String name, String value) {
		if (PROJECT_NATURE.equals(name))
			return getNatureID().equals(value);
		return false;
	}

	public IPluginContribution getContribution() {
		return contribution;
	}
}