/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Jan 16, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.wst.common.navigator.internal.groups;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorMessages;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentProvider;


/**
 * @author mdelder
 */
public class ToggleGroupingAction extends Action implements IAction {

	private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();

	private final StructuredViewer structuredViewer;
	private final NavigatorContentService contentService;
	private NavigatorGroupContentProvider groupProvider = null;
	private boolean isGroupingEnabled;

	public ToggleGroupingAction(StructuredViewer aViewer, NavigatorContentService aContentService) {
		super(WorkbenchNavigatorMessages._9_UI_, IAction.AS_PUSH_BUTTON); 
		setToolTipText(WorkbenchNavigatorMessages._10_UI_); 
		ImageDescriptor icon = getImageDescriptor("icons/shownavigatorgroups_obj.gif"); //$NON-NLS-1$
		setHoverImageDescriptor(icon);
		setImageDescriptor(icon);

		structuredViewer = aViewer;
		contentService = aContentService;
		isGroupingEnabled = getGroupProvider().isGroupingEnabled();
		setChecked(isGroupingEnabled);
	}

	/**
	 * Returns the image descriptor with the given relative path.
	 */
	protected ImageDescriptor getImageDescriptor(String relativePath) {
		try {
			WorkbenchNavigatorPlugin plugin = WorkbenchNavigatorPlugin.getDefault();
			URL installURL = plugin.getDescriptor().getInstallURL();
			URL url = new URL(installURL, relativePath);
			return ImageDescriptor.createFromURL(url);
		} catch (MalformedURLException e) {
			// should not happen
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}

	public void setGroupingEnabled(boolean toEnableGrouping) {
		if (toEnableGrouping != isGroupingEnabled) {
			isGroupingEnabled = toEnableGrouping;	
			//setChecked(isGroupingEnabled);
			if (getGroupProvider() != null)
				getGroupProvider().setGroupingEnabled(isGroupingEnabled);
			structuredViewer.refresh();
		}
	}

	public boolean isGroupingEnabled() {
		return isGroupingEnabled;
	}


	public void run() {
		setGroupingEnabled(!isGroupingEnabled);
	}

	private NavigatorGroupContentProvider getGroupProvider() {
		if (groupProvider == null) {
			NavigatorContentDescriptor groupDescriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(NavigatorGroupActionProvider.NAVIGATOR_GROUP_CONTENT_EXTENSION);
			if (groupDescriptor != null) {
				NavigatorContentProvider delegateContentProvider = (NavigatorContentProvider) contentService.getDescriptorInstance(groupDescriptor).getContentProvider();
				groupProvider = (NavigatorGroupContentProvider) delegateContentProvider.getDelegateContentProvider();
			}			
		}
		return groupProvider;
	}

}
