/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.provisional.views;
 
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/**
 * Defines a label provider for the title bar in the tabbed properties view.
 * 
 * @author ahunter
 */
public class CommonNavigatorTitleProvider extends LabelProvider {

	private CommonNavigator commonNavigator = null;

	private ILabelProvider labelProvider;
	private IDescriptionProvider descriptionProvider; 
	/**
	 * Constructor for CommonNavigatorTitleProvider. 
	 */
	public CommonNavigatorTitleProvider() {
		super();
		IWorkbenchPart part = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActivePart();
		Assert.isTrue(part instanceof CommonNavigator);
		this.commonNavigator = (CommonNavigator) part;

		Assert.isTrue(commonNavigator.getCommonViewer().getLabelProvider() instanceof ILabelProvider);
		labelProvider = (ILabelProvider) commonNavigator.getCommonViewer().getLabelProvider(); 
		
		descriptionProvider = new NavigatorContentServiceDescriptionProvider(commonNavigator.getNavigatorContentService());
	}

	/**
	 * Retrieve the structured selection from the object.
	 * @param object The object, which is the selection in the project navigator.
	 * @return the structured selection.
	 */
	protected IStructuredSelection getStructuredSelection(Object object) {

		/*
		 * Ensure the selection is non-null and is a selection.
		 */
		if (object == null || !(object instanceof ISelection)) {
			return null;
		}

		ISelection aSelection = (ISelection) object;

		/*
		 * Ensure the selection is a non-empty IStructuredSelection
		 */
		if (aSelection.isEmpty()
				|| !(aSelection instanceof IStructuredSelection))
			return null;

		return (IStructuredSelection) object;
	}

	/**
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object object) {
		IStructuredSelection structuredSelection = getStructuredSelection(object);
		if (structuredSelection == null || structuredSelection.size() > 1) {
			return null;
		}

		Object target = structuredSelection.getFirstElement();
		if (target == null) {
			return null;
		}
 
		if (labelProvider == null) {
			return null;
		}
		return labelProvider.getImage(target);
	}

	/**
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object object) {
		return descriptionProvider.getDescription(object);
	}

}
