/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.extensions;

import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;
import org.eclipse.wst.common.navigator.internal.views.DefaultNavigatorContentExtension;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class SkeletonNavigatorContentExtension extends DefaultNavigatorContentExtension implements INavigatorContentExtension {

	
	private ICommonLabelProvider labelProvider;
	private INavigatorContentProvider contentProvider;
	public static final INavigatorContentExtension INSTANCE = new SkeletonNavigatorContentExtension();
	
	private SkeletonNavigatorContentExtension() {}
	
	/* (non-Javadoc)
	 * @see org.eclipse.wst.common.navigator.views.INavigatorContentExtension#getContentProvider()
	 */
	public INavigatorContentProvider getContentProvider() {
		if(contentProvider == null)
			contentProvider = new NavigatorContentProvider(SkeletonTreeContentProvider.INSTANCE);
		return contentProvider;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.wst.common.navigator.views.INavigatorContentExtension#getLabelProvider()
	 */
	public ICommonLabelProvider getLabelProvider() {
		if(labelProvider == null)
			labelProvider = new DelegateCommonLabelProvider(SkeletonLabelProvider.INSTANCE);
		return labelProvider;
	}

}
