/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.controller;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.common.internal.annotations.core.AnnotationsAdapter;
import org.eclipse.jst.common.internal.annotations.core.AnnotationsProviderManager;
import org.eclipse.jst.common.internal.annotations.core.IAnnotationsProvider;

public class AnnotationsControllerHelper {
    public static final AnnotationsControllerHelper INSTANCE = new AnnotationsControllerHelper();

    protected AnnotationsControllerHelper() {
    }

    public boolean isAnnotated(EObject eObject) {
        if (AnnotationsAdapter.getAnnotations((EObject)eObject, (String)"generated") != null) {
            return true;
        }
        List annotationsProviders = AnnotationsProviderManager.INSTANCE.getAnnotationsProviders();
        int i = 0;
        while (i < annotationsProviders.size()) {
            IAnnotationsProvider provider = (IAnnotationsProvider)annotationsProviders.get(i);
            if (provider != null && provider.isAnnotated(eObject)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAnnotated(EObject eObject, String value) {
        AnnotationsAdapter.addAnnotations((EObject)eObject, (String)"generated", (Object)value);
    }

    public void addAnnotations(EObject eObject, String name, Object value) {
        AnnotationsAdapter.addAnnotations((EObject)eObject, (String)name, (Object)value);
    }

    public Object getAnnotations(EObject eObject, String name) {
        return AnnotationsAdapter.getAnnotations((EObject)eObject, (String)name);
    }

    public String getTagset(EObject eObject) {
        String tagset = this.getTagsetFromProviders(eObject);
        if (tagset == null) {
            tagset = this.getTagsetFromFragment(eObject);
        }
        return tagset;
    }

    private String getTagsetFromFragment(EObject eObject) {
        String generatedComment = (String)AnnotationsAdapter.getAnnotations((EObject)eObject, (String)"generated");
        if (generatedComment == null || generatedComment.length() == 0) {
            return null;
        }
        int poundit = generatedComment.indexOf(35);
        int slash = generatedComment.indexOf(47);
        if (poundit < 0 || slash < 0 || poundit >= slash) {
            return null;
        }
        return generatedComment.substring(poundit + 1, slash);
    }

    private String getTagsetFromProviders(EObject eObject) {
        String tagset = null;
        List annotationProviders = AnnotationsProviderManager.INSTANCE.getAnnotationsProviders();
        int size = annotationProviders.size();
        int i = 0;
        while (i < size && tagset == null) {
            IAnnotationsProvider provider = (IAnnotationsProvider)annotationProviders.get(i);
            tagset = provider != null ? provider.getPrimaryTagset(eObject) : null;
            ++i;
        }
        return tagset;
    }

    public ICompilationUnit getAnnotatedCU(EObject eObject) {
        IType itype;
        String fragementString = (String)AnnotationsAdapter.getAnnotations((EObject)eObject, (String)"generated");
        if (fragementString == null) {
            return null;
        }
        String typeString = fragementString.substring(0, fragementString.indexOf(35));
        if (typeString != null && (itype = this.findType(typeString, eObject)) != null) {
            return itype.getCompilationUnit();
        }
        return null;
    }

    private ICompilationUnit getAnnotatedCUFromProvider(EObject eObject) {
        ICompilationUnit primaryCU = null;
        List annotationProviders = AnnotationsProviderManager.INSTANCE.getAnnotationsProviders();
        int size = annotationProviders.size();
        int i = 0;
        while (i < size && primaryCU == null) {
            IAnnotationsProvider provider = (IAnnotationsProvider)annotationProviders.get(i);
            primaryCU = provider != null ? provider.getPrimaryAnnotatedCompilationUnit(eObject) : null;
            ++i;
        }
        return primaryCU;
    }

    protected IType findType(String type, EObject eObject) {
        IType result = null;
        IProject project = ProjectUtilities.getProject((EObject)eObject);
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
        if (javaProject != null) {
            try {
                result = javaProject.findType(type);
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        return result;
    }

    public boolean hasAnnotationSupport(IProject project) {
        return AnnotationsControllerManager.INSTANCE.hasAnnotationsBuilder(project);
    }
}

