/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.common.navigator.internal.views.dnd.CommonNavigatorDropAdapter;
import org.eclipse.wst.common.navigator.internal.views.dnd.IDropValidator;
import org.eclipse.wst.common.navigator.internal.views.dnd.NavigatorDropActionDelegate;

public class JavaDropAction
extends NavigatorDropActionDelegate
implements IDropValidator {
    private List fElements;
    private JavaMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private JavaCopyProcessor fCopyProcessor;
    private int fCanCopyElements;

    public boolean run(CommonNavigatorDropAdapter dropAdapter, Object source, Object target) {
        if (LocalSelectionTransfer.getInstance().isSupportedType(dropAdapter.getCurrentTransfer())) {
            try {
                switch (dropAdapter.getCurrentOperation()) {
                    case 2: {
                        this.handleDropMove(target);
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(target);
                    }
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)e, (String)PackagesMessages.SelectionTransferDropAdapter_error_title, (String)PackagesMessages.SelectionTransferDropAdapter_error_message);
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle((InvocationTargetException)e, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.OpenRefactoringWizardAction_exception);
            }
            catch (InterruptedException interruptedException) {}
            this.clear();
            return true;
        }
        if (FileTransfer.getInstance().isSupportedType(dropAdapter.getCurrentTransfer())) {
            IContainer targetContainer;
            Object data;
            block16: {
                block15: {
                    data = FileTransfer.getInstance().nativeToJava(dropAdapter.getCurrentTransfer());
                    if (data != null && data instanceof String[]) break block15;
                    return false;
                }
                targetContainer = this.getActualTarget(target);
                if (targetContainer != null) break block16;
                return false;
            }
            try {
                this.getShell().forceActive();
                new CopyFilesAndFoldersOperation(this.getShell()).copyFiles((String[])data, targetContainer);
            }
            catch (JavaModelException e) {
                String title = PackagesMessages.DropAdapter_errorTitle;
                String message = PackagesMessages.DropAdapter_errorMessage;
                ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)title, (String)message);
            }
            return true;
        }
        return false;
    }

    private IContainer getActualTarget(Object dropTarget) throws JavaModelException {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof IJavaElement) {
            return this.getActualTarget(((IJavaElement)dropTarget).getCorrespondingResource());
        }
        return null;
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        this.fElements = ((IStructuredSelection)s).toList();
    }

    public boolean validateDrop(CommonNavigatorDropAdapter dropAdapter, Object target, int operation, TransferData transferType) {
        boolean result = true;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferType)) {
            this.initializeSelection();
            try {
                switch (operation) {
                    case 16: {
                        result = this.handleValidateDefault(target) != 0;
                        break;
                    }
                    case 1: {
                        result = this.handleValidateCopy(target) != 0;
                        break;
                    }
                    case 2: {
                        result = this.handleValidateMove(target) != 0;
                    }
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)e, (String)PackagesMessages.SelectionTransferDropAdapter_error_title, (String)PackagesMessages.SelectionTransferDropAdapter_error_message);
                result = false;
            }
        }
        return result;
    }

    private void handleDropMove(Object target) throws JavaModelException, InvocationTargetException, InterruptedException {
        IJavaElement[] javaElements = ReorgUtils.getJavaElements((List)this.fElements);
        IResource[] resources = ReorgUtils.getResources((List)this.fElements);
        ReorgMoveStarter starter = null;
        if (target instanceof IResource) {
            starter = ReorgMoveStarter.create((IJavaElement[])javaElements, (IResource[])resources, (IResource)((IResource)target));
        } else if (target instanceof IJavaElement) {
            starter = ReorgMoveStarter.create((IJavaElement[])javaElements, (IResource[])resources, (IJavaElement)((IJavaElement)target));
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private void handleDropCopy(Object target) throws JavaModelException, InvocationTargetException, InterruptedException {
        IJavaElement[] javaElements = ReorgUtils.getJavaElements((List)this.fElements);
        IResource[] resources = ReorgUtils.getResources((List)this.fElements);
        ReorgCopyStarter starter = null;
        if (target instanceof IResource) {
            starter = ReorgCopyStarter.create((IJavaElement[])javaElements, (IResource[])resources, (IResource)((IResource)target));
        } else if (target instanceof IJavaElement) {
            starter = ReorgCopyStarter.create((IJavaElement[])javaElements, (IResource[])resources, (IJavaElement)((IJavaElement)target));
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private int handleValidateCopy(Object target) throws JavaModelException {
        if (this.fCopyProcessor == null) {
            this.fCopyProcessor = JavaCopyProcessor.create((IResource[])ReorgUtils.getResources((List)this.fElements), (IJavaElement[])ReorgUtils.getJavaElements((List)this.fElements));
        }
        if (!this.canCopyElements()) {
            return 0;
        }
        if (target instanceof IResource && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IResource)target).isOK()) {
            return 1;
        }
        if (target instanceof IJavaElement && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IJavaElement)target).isOK()) {
            return 1;
        }
        return 0;
    }

    private int handleValidateDefault(Object target) throws JavaModelException {
        if (target == null) {
            return 0;
        }
        return this.handleValidateMove(target);
    }

    private int handleValidateMove(Object target) throws JavaModelException {
        if (target == null) {
            return 0;
        }
        if (this.fMoveProcessor == null) {
            this.fMoveProcessor = JavaMoveProcessor.create((IResource[])ReorgUtils.getResources((List)this.fElements), (IJavaElement[])ReorgUtils.getJavaElements((List)this.fElements));
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        if (target instanceof IResource && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IResource)target).isOK()) {
            return 2;
        }
        if (target instanceof IJavaElement && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IJavaElement)target).isOK()) {
            return 2;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyProcessor == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private void clear() {
        this.fElements = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyProcessor = null;
        this.fCanCopyElements = 0;
    }
}

