/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class CommonAdapterFactoryContentProvider
extends AdapterFactoryContentProvider {
    public CommonAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void notifyChanged(final Notification notification) {
        final AbstractTreeViewer abstractViewer = this.getViewer();
        if (abstractViewer == null) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.processNotificationChanged(notification, abstractViewer);
        } else {
            new UIJob("Update the Viewer for the Common Adapter Factory Content Provider"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        CommonAdapterFactoryContentProvider.this.processNotificationChanged(notification, abstractViewer);
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void processNotificationChanged(Notification notification, AbstractTreeViewer abstractViewer) {
        switch (notification.getEventType()) {
            case 3: {
                if (notification.getNewValue() != null && this.isValidChild(notification.getNotifier(), notification.getNewValue())) {
                    abstractViewer.add(notification.getNotifier(), notification.getNewValue());
                }
                return;
            }
            case 5: {
                if (notification.getNewValue() != null && notification.getNewValue() instanceof Collection) {
                    Object[] objects = ((Collection)notification.getNewValue()).toArray();
                    abstractViewer.add(notification.getNotifier(), this.filterValidChild(notification.getNotifier(), objects));
                }
                return;
            }
            case 7: {
                abstractViewer.refresh(notification.getNotifier(), true);
                return;
            }
            case 4: {
                if (notification.getOldValue() != null) {
                    abstractViewer.remove(notification.getOldValue());
                } else {
                    abstractViewer.refresh(notification.getNotifier(), true);
                }
                return;
            }
            case 6: {
                if (notification.getOldValue() != null) {
                    Object[] objects = ((Collection)notification.getOldValue()).toArray();
                    abstractViewer.remove(objects);
                } else {
                    abstractViewer.refresh(notification.getNotifier(), true);
                }
                return;
            }
            case 1: {
                abstractViewer.refresh(notification.getNotifier(), true);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (this.isValidChild(parent, element)) {
            return parent;
        }
        return this.findChild(parent, element);
    }

    private Object findChild(Object parent, Object element) {
        Object[] children = this.getChildren(parent);
        if (this.contains(children, element)) {
            return parent;
        }
        int i = 0;
        while (i < children.length) {
            parent = this.findChild(children[i], element);
            if (parent != null) {
                return parent;
            }
            ++i;
        }
        return null;
    }

    private boolean isValidChild(Object parent, Object element) {
        if (parent == null) {
            return false;
        }
        Object[] children = this.getChildren(parent);
        return this.contains(children, element);
    }

    private boolean contains(Object[] children, Object element) {
        if (children == null || children.length == 0) {
            return false;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Object[] filterValidChild(Object parent, Object[] elements) {
        Object[] childrenArray = this.getChildren(parent);
        ArrayList<Object> children = new ArrayList<Object>();
        int i = 0;
        while (i < childrenArray.length) {
            children.add(childrenArray[i]);
            ++i;
        }
        children.retainAll(Arrays.asList(elements));
        return children.toArray();
    }

    private AbstractTreeViewer getViewer() {
        if (this.viewer instanceof AbstractTreeViewer) {
            return (AbstractTreeViewer)this.viewer;
        }
        return null;
    }
}

