/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.IWorkingSetActionGroup;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class WorkingSetShowActionGroup
extends ActionGroup
implements IWorkingSetActionGroup {
    private List fContributions = new ArrayList();
    private ConfigureWorkingSetAction fConfigureWorkingSetAction;
    private WorkingSetModel fWorkingSetModel;
    private final Shell fShell;

    public WorkingSetShowActionGroup(Shell shell) {
        this.fShell = shell;
    }

    public void setWorkingSetMode(WorkingSetModel model) {
        Assert.isNotNull((Object)model);
        this.fWorkingSetModel = model;
        if (this.fConfigureWorkingSetAction != null) {
            this.fConfigureWorkingSetAction.setWorkingSetModel(this.fWorkingSetModel);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IMenuManager menuManager = actionBars.getMenuManager();
        this.fillViewMenu(menuManager);
    }

    public void fillViewMenu(IMenuManager menuManager) {
        this.fConfigureWorkingSetAction = new ConfigureWorkingSetAction(this.fShell);
        if (this.fWorkingSetModel != null) {
            this.fConfigureWorkingSetAction.setWorkingSetModel(this.fWorkingSetModel);
        }
        this.addAction(menuManager, this.fConfigureWorkingSetAction);
    }

    public void cleanViewMenu(IMenuManager menuManager) {
        Iterator iter = this.fContributions.iterator();
        while (iter.hasNext()) {
            menuManager.remove((IContributionItem)iter.next());
        }
        this.fContributions.clear();
    }

    private void addAction(IMenuManager menuManager, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        if (menuManager != null) {
            menuManager.appendToGroup("working_set_action_group", (IContributionItem)item);
        }
        this.fContributions.add(item);
    }
}

