/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.workingset.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.common.navigator.internal.workingset.views.CustomHashtable;
import org.eclipse.jst.common.navigator.internal.workingset.views.IMultiElementTreeContentProvider;
import org.eclipse.jst.common.navigator.internal.workingset.views.MultiElementSelection;
import org.eclipse.jst.common.navigator.internal.workingset.views.TreePath;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;

public class CommonWorkingSetViewer
extends CommonViewer {
    private List fPendingGetChildren;
    private Map fAdditionalMappings;
    private List fItemsBeingRemoved = new ArrayList();
    private boolean fInPreserveSelection;

    public CommonWorkingSetViewer(String aCommonNavigatorId, Composite aParent, int aStyle) {
        super(aCommonNavigatorId, aParent, aStyle);
        if (this.fPendingGetChildren == null) {
            this.fPendingGetChildren = Collections.synchronizedList(new ArrayList());
        }
    }

    public void add(Object parentElement, Object[] childElements) {
        if (this.fPendingGetChildren.contains(parentElement)) {
            return;
        }
        List l = (List)this.getAdditionalMappings().get(parentElement);
        if (l == null) {
            super.add(parentElement, childElements);
        } else {
            ArrayList stable = new ArrayList(l);
            super.add(parentElement, childElements);
            Iterator iter = stable.iterator();
            while (iter.hasNext()) {
                Widget item = (Widget)iter.next();
                super.internalAdd(item, parentElement, childElements);
            }
        }
    }

    protected Object[] getRawChildren(Object parent) {
        List list = this.fPendingGetChildren;
        synchronized (list) {
            Object[] objectArray;
            try {
                this.fPendingGetChildren.add(parent);
                objectArray = super.getRawChildren(parent);
                {
                    Object var3_4 = null;
                    this.fPendingGetChildren.remove(parent);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.fPendingGetChildren.remove(parent);
                throw throwable;
            }
            {
            }
            return objectArray;
        }
    }

    protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        IStructuredSelection is = (IStructuredSelection)invalidSelection;
        ArrayList<Object> ns = null;
        ns = newSelection instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)newSelection).toList()) : new ArrayList<IJavaProject>();
        boolean changed = false;
        Iterator iter = is.iterator();
        while (iter.hasNext()) {
            IProject project;
            Object element = iter.next();
            if (!(element instanceof IProject) || !(project = (IProject)element).isOpen()) continue;
            IJavaProject jProject = JavaCore.create((IProject)project);
            if (jProject != null && jProject.exists()) {
                ns.add(jProject);
            }
            changed = true;
        }
        if (changed) {
            newSelection = new StructuredSelection(ns);
            this.setSelection(newSelection);
        }
        super.handleInvalidSelection(invalidSelection, newSelection);
    }

    protected void mapElement(Object element, Widget item) {
        Widget existingItem = this.findItem(element);
        if (existingItem == null || existingItem == item) {
            super.mapElement(element, item);
        } else {
            ArrayList<Widget> l = (ArrayList<Widget>)this.getAdditionalMappings().get(element);
            if (l == null) {
                l = new ArrayList<Widget>();
                this.getAdditionalMappings().put(element, l);
            }
            if (!l.contains(item)) {
                l.add(item);
                this.fResourceToItemsMapper.addToMap(element, (Item)item);
            }
        }
    }

    protected void unmapElement(Object element, Widget item) {
        List l = (List)this.getAdditionalMappings().get(element);
        if (l == null) {
            super.unmapElement(element, item);
            return;
        }
        if (this.findItem(element) == item) {
            super.unmapElement(element, item);
            if (l != null && l.size() >= 1) {
                Widget widget = (Widget)l.remove(0);
                this.fResourceToItemsMapper.removeFromMap(element, (Item)widget);
                super.mapElement(element, widget);
            }
        } else {
            l.remove(item);
            this.fResourceToItemsMapper.removeFromMap(element, (Item)item);
        }
        if (l.size() == 0) {
            this.getAdditionalMappings().remove(element);
        }
    }

    protected void unmapAllElements() {
        this.getAdditionalMappings().clear();
        super.unmapAllElements();
    }

    public void remove(Object[] elements) {
        this.fItemsBeingRemoved.clear();
        this.fItemsBeingRemoved.addAll(Arrays.asList(elements));
        super.removeWithoutRefresh(elements);
        ArrayList<Object> stillExisting = new ArrayList<Object>();
        do {
            stillExisting.clear();
            int i = 0;
            while (i < elements.length) {
                if (this.findItem(elements[i]) != null) {
                    stillExisting.add(elements[i]);
                }
                ++i;
            }
            if (stillExisting.size() <= 0) continue;
            this.fItemsBeingRemoved.clear();
            this.fItemsBeingRemoved.addAll(stillExisting);
            super.removeWithoutRefresh(stillExisting.toArray());
        } while (stillExisting.size() > 0);
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
        int i = 0;
        while (i < elements.length) {
            super.internalRefresh(contentProvider.getParent(elements[i]));
            ++i;
        }
    }

    private Map getAdditionalMappings() {
        if (this.fAdditionalMappings == null) {
            this.fAdditionalMappings = new HashMap();
            this.fPendingGetChildren = Collections.synchronizedList(new ArrayList());
        }
        return this.fAdditionalMappings;
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        List l = (List)this.getAdditionalMappings().get(element);
        if (l == null) {
            super.internalRefresh(element, updateLabels);
        } else {
            ArrayList stable = new ArrayList(l);
            super.internalRefresh(element, updateLabels);
            Iterator iter = stable.iterator();
            while (iter.hasNext()) {
                Widget item = (Widget)iter.next();
                super.internalRefresh(item, element, true, updateLabels);
            }
        }
    }

    protected void internalUpdate(Widget item, Object element, String[] properties) {
        List l = (List)this.getAdditionalMappings().get(element);
        if (l == null) {
            if (!item.isDisposed()) {
                super.internalUpdate(item, element, properties);
            } else {
                System.out.println("Widget Disposed");
            }
        } else {
            ArrayList stable = new ArrayList(l);
            super.internalUpdate(item, element, properties);
            Iterator iter = stable.iterator();
            while (iter.hasNext()) {
                Widget additionalItem = (Widget)iter.next();
                super.internalUpdate(additionalItem, element, properties);
            }
        }
    }

    public ISelection getSelection() {
        IContentProvider cp = this.getContentProvider();
        if (!(cp instanceof IMultiElementTreeContentProvider)) {
            return super.getSelection();
        }
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return StructuredSelection.EMPTY;
        }
        Tree tree = this.getTree();
        TreeItem[] selection = tree.getSelection();
        ArrayList<Object> result = new ArrayList<Object>(selection.length);
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        int i = 0;
        while (i < selection.length) {
            TreeItem item = selection[i];
            Object element = this.getElement(item);
            if (element != null) {
                if (!result.contains(element)) {
                    result.add(element);
                }
                treePaths.add(this.createTreePath(item));
            }
            ++i;
        }
        return new MultiElementSelection((StructuredViewer)this, result, treePaths.toArray(new TreePath[treePaths.size()]));
    }

    private TreePath createTreePath(TreeItem item) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(item.getData());
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            result.add(parent.getData());
            parent = parent.getParentItem();
        }
        Collections.reverse(result);
        return new TreePath(result.toArray());
    }

    private Object getElement(TreeItem item) {
        Object result = item.getData();
        if (result == null) {
            return null;
        }
        return result;
    }

    protected Widget internalGetWidgetToSelect(Object element) {
        Widget result = this.findItem(element);
        if (!(result instanceof TreeItem)) {
            return result;
        }
        if (this.isInHistroyWorkingSet((TreeItem)result)) {
            List l = (List)this.getAdditionalMappings().get(element);
            if (l != null && !l.isEmpty()) {
                return (Widget)l.get(0);
            }
            return null;
        }
        return result;
    }

    private boolean isInHistroyWorkingSet(TreeItem item) {
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            Object data = this.getElement(parent);
            if (data instanceof IWorkingSet && "org.eclipse.jst.common.navigator.ui.HistoryWorkingSet".equals(((IWorkingSet)data).getId())) {
                return true;
            }
            parent = parent.getParentItem();
        }
        return false;
    }

    protected boolean isSameSelection(List items, Item[] current) {
        if (items.size() != current.length) {
            return false;
        }
        HashSet newSelection = new HashSet(items);
        int i = 0;
        while (i < current.length) {
            if (!newSelection.contains(current[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void preservingSelection(Runnable updateCode) {
        try {
            this.fInPreserveSelection = true;
            super.preservingSelection(updateCode);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fInPreserveSelection = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.fInPreserveSelection = false;
            return;
        }
    }

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            int i = 0;
            while (i < selectedElements.size()) {
                if (this.fItemsBeingRemoved.contains(selectedElements.get(i))) {
                    return;
                }
                ++i;
            }
        }
        if (!this.fInPreserveSelection || !(selection instanceof MultiElementSelection)) {
            super.setSelectionToWidget(selection, reveal);
            return;
        }
        IContentProvider cp = this.getContentProvider();
        if (!(cp instanceof IMultiElementTreeContentProvider)) {
            super.setSelectionToWidget(selection, reveal);
            return;
        }
        IMultiElementTreeContentProvider contentProvider = (IMultiElementTreeContentProvider)cp;
        MultiElementSelection toRestore = (MultiElementSelection)selection;
        ArrayList<TreePath> pathsToSelect = new ArrayList<TreePath>();
        Iterator iter = toRestore.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            TreePath[] pathsToRestore = toRestore.getTreePaths(element);
            CustomHashtable currentParents = this.createRootAccessedMap(contentProvider.getTreePaths(element));
            int i = 0;
            while (i < pathsToRestore.length) {
                TreePath path = pathsToRestore[i];
                Object root = path.getFirstSegment();
                if (root != null && path.equals((TreePath)currentParents.get(root), this.getComparer())) {
                    pathsToSelect.add(path);
                }
                ++i;
            }
        }
        ArrayList<Tree> toSelect = new ArrayList<Tree>();
        Iterator iter2 = pathsToSelect.iterator();
        while (iter2.hasNext()) {
            Object segment;
            TreePath path = (TreePath)iter2.next();
            int size = path.getSegmentCount();
            if (size == 0) continue;
            Tree current = this.getTree();
            int last = size - 1;
            int i = 0;
            while (i < size && current != null && (segment = path.getSegment(i)) != null) {
                this.internalExpandToLevel((Widget)current, 1);
                current = this.internalFindChild((Widget)current, segment);
                if (i == last && current != null) {
                    toSelect.add(current);
                }
                ++i;
            }
        }
        this.getTree().setSelection(toSelect.toArray(new TreeItem[toSelect.size()]));
    }

    private Widget internalFindChild(Widget parent, Object element) {
        Item[] items = this.getChildren(parent);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Object data = item.getData();
            if (data != null && this.equals(data, element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private CustomHashtable createRootAccessedMap(TreePath[] paths) {
        CustomHashtable result = new CustomHashtable(this.getComparer());
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            Object root = path.getFirstSegment();
            if (root != null) {
                result.put(root, path);
            }
            ++i;
        }
        return result;
    }
}

