/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.ui.internal.cmp.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.ejb.annotation.internal.messages.IEJBAnnotationConstants;
import org.eclipse.jst.j2ee.ejb.annotation.ui.internal.wizards.IBeanWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddContainerManagedEntityBeanWizardPage
extends DataModelWizardPage
implements IBeanWizardPage {
    private Text ejbNameText;
    private Text jndiNameText;
    private Text displayNameText;
    private Combo usecaseButton;
    private Combo versionButton;
    private Text schemaText;

    public AddContainerManagedEntityBeanWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(IEJBAnnotationConstants.ADD_EJB_CMPWIZARD_PAGE_DESC);
        this.setTitle(IEJBAnnotationConstants.ADD_EJB_CMPWIZARD_PAGE_TITLE);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IEjbCommonDataModel.EJB_NAME", "EntityBeanDataModel.DATASOURCE", "EntityBeanDataModel.SCHEMA", "EntityBeanDataModel.VERSION", "IEjbCommonDataModel.DISPLAY_NAME", "IEjbCommonDataModel.DESCRIPTION"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        this.createNameDescription(group);
        this.createVersionGroup(group);
        this.createUsecaseTypeGroup(group);
        this.displayNameText.setFocus();
        IStatus projectStatus = this.validateProjectName();
        if (!projectStatus.isOK()) {
            this.setErrorMessage(projectStatus.getMessage());
            composite.setEnabled(false);
        }
        return composite;
    }

    protected IStatus validateProjectName() {
        if (this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME") == null || this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME").trim().length() == 0) {
            return WTPCommonPlugin.createErrorStatus((String)IEJBAnnotationConstants.NO_EJB_PROJECTS);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected void createNameDescription(Composite composite) {
        Label ejbNameLabel = new Label(composite, 16384);
        ejbNameLabel.setText(IEJBAnnotationConstants.EJB_NAME_LABEL);
        ejbNameLabel.setLayoutData((Object)new GridData(32));
        this.ejbNameText = new Text(composite, 2052);
        this.ejbNameText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.ejbNameText, "IEjbCommonDataModel.EJB_NAME", null);
        Label jndiNameLabel = new Label(composite, 16384);
        jndiNameLabel.setText(IEJBAnnotationConstants.DATASOURCE_NAME_LABEL);
        jndiNameLabel.setLayoutData((Object)new GridData(32));
        this.jndiNameText = new Text(composite, 2052);
        this.jndiNameText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.jndiNameText, "EntityBeanDataModel.DATASOURCE", null);
        Label schemaLabel = new Label(composite, 16384);
        schemaLabel.setText(IEJBAnnotationConstants.SCHEMA_NAME_LABEL);
        schemaLabel.setLayoutData((Object)new GridData(32));
        this.schemaText = new Text(composite, 2052);
        this.schemaText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.schemaText, "EntityBeanDataModel.SCHEMA", null);
        Label displayNameLabel = new Label(composite, 16384);
        displayNameLabel.setText(IEJBAnnotationConstants.DISPLAY_NAME_LABEL);
        displayNameLabel.setLayoutData((Object)new GridData(32));
        this.displayNameText = new Text(composite, 2052);
        this.displayNameText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.displayNameText, "IEjbCommonDataModel.DISPLAY_NAME", null);
        Label descLabel = new Label(composite, 16384);
        descLabel.setText(IEJBAnnotationConstants.DESCRIPTION_LABEL);
        descLabel.setLayoutData((Object)new GridData(32));
        final Text descText = new Text(composite, 2052);
        descText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(descText, "IEjbCommonDataModel.DESCRIPTION", null);
        this.ejbNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddContainerManagedEntityBeanWizardPage.this.jndiNameText.setText(AddContainerManagedEntityBeanWizardPage.this.ejbNameText.getText());
                AddContainerManagedEntityBeanWizardPage.this.displayNameText.setText(AddContainerManagedEntityBeanWizardPage.this.ejbNameText.getText());
                descText.setText("An Entity bean named " + AddContainerManagedEntityBeanWizardPage.this.ejbNameText.getText());
            }
        });
    }

    protected void createUsecaseTypeGroup(Composite composite) {
        Label usecaseTypeLabel = new Label(composite, 16384);
        usecaseTypeLabel.setText(IEJBAnnotationConstants.ENTITY_USECASE_LABEL);
        usecaseTypeLabel.setLayoutData((Object)new GridData(32));
        this.usecaseButton = new Combo(composite, 12);
        this.usecaseButton.setItems(new String[]{IEJBAnnotationConstants.CMP_FROM_TABLE, IEJBAnnotationConstants.CMP_FROM_BEAN});
        this.usecaseButton.setText(IEJBAnnotationConstants.CMP_FROM_TABLE);
        this.usecaseButton.setLayoutData((Object)new GridData(768));
        this.usecaseButton.select(0);
    }

    protected void createVersionGroup(Composite composite) {
        Label versionLabel = new Label(composite, 16384);
        versionLabel.setText(IEJBAnnotationConstants.ENTITY_VERSION_LABEL);
        versionLabel.setLayoutData((Object)new GridData(32));
        this.versionButton = new Combo(composite, 12);
        this.versionButton.setItems(new String[]{"1.x", "2.x"});
        this.versionButton.setText(IEJBAnnotationConstants.CMP_FROM_TABLE);
        this.versionButton.setLayoutData((Object)new GridData(768));
        this.versionButton.select(0);
        this.synchHelper.synchCombo(this.versionButton, "EntityBeanDataModel.VERSION", null);
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    public String getDisplayName() {
        return this.displayNameText.getText();
    }

    public String getEjbName() {
        return this.model.getStringProperty("IEjbCommonDataModel.EJB_NAME");
    }

    public boolean isJavaBean() {
        if (this.usecaseButton == null) {
            return false;
        }
        return this.usecaseButton.getSelectionIndex() == 1;
    }
}

