/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.wizard.NewModuleGroup;
import org.eclipse.jst.j2ee.internal.wizard.ServerEarAndStandaloneGroup;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUIUtil;

public abstract class J2EEComponentCreationWizardPage
extends DataModelWizardPage
implements IJ2EEComponentCreationDataModelProperties {
    private static final boolean isWindows = SWT.getPlatform().toLowerCase().startsWith("win");
    protected static final String MODULE_VERSION = "100";
    protected NewModuleGroup projectNameGroup;
    protected Composite advancedComposite;
    protected Button advancedButton;
    protected boolean showAdvanced = false;
    protected AdvancedSizeController advancedController;
    protected boolean advancedControlsBuilt = false;
    protected ServerEarAndStandaloneGroup earGroup;
    protected Combo serverTargetCombo;
    protected Text moduleNameText = null;
    protected Text locationPathField = null;
    protected Button browseButton = null;
    protected Button supportMultipleModules = null;
    protected Combo projectNameCombo = null;
    protected Text sourceFolderNameText = null;
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;
    private static final String MODULE_NAME_UI = J2EEUIMessages.getResourceString("94");
    private String defBrowseButtonLabel = J2EEUIMessages.getResourceString("93");
    private static final String defDirDialogLabel = "Directory";

    public J2EEComponentCreationWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)top, this.getInfopopID());
        top.setLayout((Layout)new GridLayout());
        top.setData((Object)new GridData(1808));
        Composite composite = new Composite(top, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createModuleGroup(composite);
        Composite detail = new Composite(top, 0);
        detail.setLayout((Layout)new GridLayout());
        detail.setData((Object)new GridData(1808));
        this.createAdvancedComposite(detail);
        return top;
    }

    protected Composite createAdvancedComposite(Composite parent) {
        this.advancedControlsBuilt = true;
        this.advancedButton = new Button(parent, 2);
        this.setAdvancedLabelText();
        final Cursor hand = new Cursor((Device)this.advancedButton.getDisplay(), 21);
        this.advancedButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                hand.dispose();
            }
        });
        this.advancedComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        GridData data = new GridData();
        this.advancedComposite.setData((Object)data);
        this.advancedComposite.setLayout((Layout)layout);
        this.advancedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                J2EEComponentCreationWizardPage.this.toggleAdvanced(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.advancedButton.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 32) {
                    J2EEComponentCreationWizardPage.this.advancedButton.setCursor(hand);
                }
            }
        });
        this.addToAdvancedComposite(this.advancedComposite);
        return this.advancedComposite;
    }

    protected void createModuleGroup(Composite parent) {
        this.createProjectNameGroup(parent);
        this.createProjectLocationGroup(parent);
    }

    private void createProjectNameGroup(Composite parent) {
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText(MODULE_NAME_UI);
        GridData data = new GridData();
        projectNameLabel.setLayoutData((Object)data);
        this.moduleNameText = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 305;
        this.moduleNameText.setLayoutData((Object)data);
        new Label(parent, 0);
        this.synchHelper.synchText(this.moduleNameText, "IComponentCreationDataModelProperties.COMPONENT_NAME", new Control[]{projectNameLabel});
        this.moduleNameText.setFocus();
    }

    private void createProjectLocationGroup(Composite parent) {
        Label locationPathLabel = new Label(parent, 0);
        locationPathLabel.setText(J2EEUIMessages.getResourceString("1"));
        GridData data = new GridData();
        locationPathLabel.setLayoutData((Object)data);
        this.locationPathField = new Text(parent, 2056);
        data = new GridData(768);
        data.widthHint = 305;
        this.locationPathField.setLayoutData((Object)data);
        this.browseButton = new Button(parent, 8);
        this.browseButton.setText(this.defBrowseButtonLabel);
        this.browseButton.setLayoutData((Object)new GridData(768));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2EEComponentCreationWizardPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(true);
        this.locationPathField.setEditable(true);
        this.synchHelper.synchText(this.locationPathField, "IFlexibleProjectCreationDataModelProperties.LOCATION", null);
    }

    protected void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(defDirDialogLabel);
        String dirName = this.getDataModel().getStringProperty("IFlexibleProjectCreationDataModelProperties.LOCATION");
        if (dirName != null && dirName.length() != 0 && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.getDataModel().setProperty("IFlexibleProjectCreationDataModelProperties.LOCATION", (Object)selectedDirectory);
        }
    }

    protected void addToAdvancedComposite(Composite advanced) {
        this.createServerTargetComposite(advanced);
        this.createVersionComposite(advanced);
        this.createServerEarAndStandaloneGroup(advanced);
    }

    protected void createServerTargetComposite(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(J2EEUIMessages.getResourceString("2"));
        this.serverTargetCombo = new Combo(parent, 2056);
        this.serverTargetCombo.setLayoutData((Object)new GridData(768));
        Button newServerTargetButton = new Button(parent, 0);
        newServerTargetButton.setText(J2EEUIMessages.getResourceString("14"));
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!J2EEComponentCreationWizardPage.launchNewRuntimeWizard(J2EEComponentCreationWizardPage.this.getShell(), J2EEComponentCreationWizardPage.this.model)) {
                    J2EEComponentCreationWizardPage.this.setErrorMessage(J2EECreationResourceHandler.ServerTargetDataModel_UI_9);
                }
            }
        });
        Control[] deps = new Control[]{label, newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected void createServerEarAndStandaloneGroup(Composite parent) {
        this.earGroup = new ServerEarAndStandaloneGroup(parent, this.getDataModel(), this.synchHelper);
    }

    private void createProjectsComboGroup(Composite parent) {
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText(J2EEUIMessages.getResourceString("32"));
        this.projectNameCombo = new Combo(parent, 8);
        this.projectNameCombo.setLayoutData((Object)new GridData(768));
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject project;
                String projectName = J2EEComponentCreationWizardPage.this.projectNameCombo.getText();
                if (projectName != null && projectName.length() != 0 && (project = ProjectUtilities.getProject((String)projectName)) != null) {
                    IRuntime runtime = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget();
                    if (runtime != null) {
                        J2EEComponentCreationWizardPage.this.synchHelper.getDataModel().setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", (Object)runtime.getName());
                    }
                    J2EEComponentCreationWizardPage.this.synchHelper.getDataModel().setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
                    J2EEComponentCreationWizardPage.this.synchHelper.getDataModel().setProperty("IFlexibleProjectCreationDataModelProperties.LOCATION", (Object)project.getLocation().toOSString());
                }
            }
        });
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IComponentCreationDataModelProperties.PROJECT_NAME", "IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", "IComponentCreationDataModelProperties.COMPONENT_VERSION", "IComponentCreationDataModelProperties.COMPONENT_NAME", "IFlexibleProjectCreationDataModelProperties.LOCATION", "IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", "IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", "IJavaComponentCreationDataModelProperties.JAVASOURCE_FOLDER"};
    }

    protected void createSourceFolderComposite(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        separator.setLayoutData((Object)gd);
        Label label = new Label(parent, 0);
        label.setText(this.getSourceFolderLabel());
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.sourceFolderNameText = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 305;
        this.sourceFolderNameText.setLayoutData((Object)data);
        new Label(parent, 0);
        this.synchHelper.synchText(this.sourceFolderNameText, "IJavaComponentCreationDataModelProperties.JAVASOURCE_FOLDER", null);
    }

    protected void createVersionComposite(Composite parent) {
        this.createVersionComposite(parent, this.getVersionLabel(), "IComponentCreationDataModelProperties.COMPONENT_VERSION");
    }

    protected String getVersionLabel() {
        return J2EEUIMessages.getResourceString(MODULE_VERSION);
    }

    protected String getSourceFolderLabel() {
        return J2EEUIMessages.getResourceString("SOURCEFOLDER");
    }

    public void dispose() {
        super.dispose();
        if (this.earGroup != null) {
            this.earGroup.dispose();
        }
        if (this.projectNameGroup != null) {
            this.projectNameGroup.dispose();
        }
    }

    protected void enter() {
        if (this.advancedControlsBuilt) {
            if (this.isFirstTimeToPage) {
                this.initializeAdvancedController();
            }
            if (isWindows) {
                this.advancedController.setShellSizeForAdvanced();
            }
        }
        super.enter();
    }

    private void initializeAdvancedController() {
        this.advancedController = new AdvancedSizeController(this.getShell());
    }

    protected void exit() {
        if (this.advancedControlsBuilt && isWindows && this.advancedController != null) {
            this.advancedController.resetOriginalShellSize();
        }
        super.exit();
    }

    public void storeDefaultSettings() {
        IDialogSettings settings;
        super.storeDefaultSettings();
        if (this.advancedControlsBuilt && (settings = this.getDialogSettings()) != null) {
            settings.put(this.getShowAdvancedKey(), this.showAdvanced);
        }
    }

    protected String getShowAdvancedKey() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "_SHOW_ADVANCED";
    }

    protected void restoreDefaultSettings() {
        super.restoreDefaultSettings();
        if (this.advancedControlsBuilt) {
            IDialogSettings settings = this.getDialogSettings();
            if (settings != null) {
                this.showAdvanced = !settings.getBoolean(this.getShowAdvancedKey());
            }
            this.advancedButton.setSelection(!this.showAdvanced);
            this.toggleAdvanced(false);
        }
    }

    private void setAdvancedLabelText() {
        if (this.advancedControlsBuilt) {
            if (this.showAdvanced) {
                this.advancedButton.setText(J2EEUIMessages.getResourceString("J2EEProjectCreationPage_UI_0"));
            } else {
                this.advancedButton.setText(J2EEUIMessages.getResourceString("J2EEProjectCreationPage_UI_1"));
            }
        }
    }

    protected void toggleAdvanced(boolean setSize) {
        if (this.advancedControlsBuilt) {
            this.showAdvanced = !this.showAdvanced;
            this.advancedComposite.setVisible(this.showAdvanced);
            this.setAdvancedLabelText();
            if (setSize && isWindows && this.advancedControlsBuilt) {
                if (this.advancedController == null) {
                    this.initializeAdvancedController();
                }
                if (isWindows) {
                    this.advancedController.setShellSizeForAdvanced();
                }
            }
        }
    }

    protected void createVersionComposite(Composite parent, String labelText, String versionProp) {
        String[] items;
        Label label = new Label(parent, 0);
        label.setText(labelText);
        Combo versionCombo = new Combo(parent, 2056);
        GridData gridData = new GridData(768);
        gridData.widthHint = 305;
        versionCombo.setLayoutData((Object)gridData);
        Control[] deps = new Control[]{label};
        this.synchHelper.synchCombo(versionCombo, versionProp, deps);
        if (versionCombo.getSelectionIndex() == -1 && (items = versionCombo.getItems()) != null && items.length > 0) {
            versionCombo.select(items.length - 1);
        }
        new Label(parent, 0);
    }

    public static boolean launchNewRuntimeWizard(Shell shell, IDataModel model) {
        DataModelPropertyDescriptor[] preAdditionDescriptors = model.getValidPropertyDescriptors("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
        boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)shell, (String)"", (String)"");
        if (isOK && model != null) {
            DataModelPropertyDescriptor[] postAdditionDescriptors = model.getValidPropertyDescriptors("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
            Object[] preAddition = new Object[preAdditionDescriptors.length];
            int i = 0;
            while (i < preAddition.length) {
                preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                ++i;
            }
            Object[] postAddition = new Object[postAdditionDescriptors.length];
            int i2 = 0;
            while (i2 < postAddition.length) {
                postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                ++i2;
            }
            Object newAddition = ProjectUtilities.getNewObject((Object[])preAddition, (Object[])postAddition);
            model.notifyPropertyChange("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", 4);
            if (newAddition != null) {
                model.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", newAddition);
            } else {
                return false;
            }
        }
        return isOK;
    }

    private class AdvancedSizeController
    implements ControlListener {
        private int advancedHeight = -1;
        private Point originalSize;
        private boolean ignoreShellResize = false;

        private AdvancedSizeController(Shell aShell) {
            this.originalSize = aShell.getSize();
            aShell.addControlListener((ControlListener)this);
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            Control control;
            if (!this.ignoreShellResize && (control = (Control)e.getSource()).isVisible()) {
                this.originalSize = control.getSize();
                if (this.advancedHeight == -1) {
                    this.setShellSizeForAdvanced();
                }
            }
        }

        protected void resetOriginalShellSize() {
            this.setShellSize(this.originalSize.x, this.originalSize.y);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setShellSize(int x, int y) {
            this.ignoreShellResize = true;
            try {
                J2EEComponentCreationWizardPage.this.getShell().setSize(x, y);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.ignoreShellResize = false;
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.ignoreShellResize = false;
                return;
            }
        }

        protected void setShellSizeForAdvanced() {
            int height = this.calculateAdvancedShellHeight();
            if (height != -1) {
                this.setShellSize(J2EEComponentCreationWizardPage.this.getShell().getSize().x, height);
            }
        }

        private int calculateAdvancedShellHeight() {
            Point advancedCompSize = J2EEComponentCreationWizardPage.this.advancedComposite.getSize();
            if (advancedCompSize.x == 0) {
                return -1;
            }
            int height = this.computeAdvancedHeight();
            if (!J2EEComponentCreationWizardPage.this.showAdvanced && height != -1) {
                height -= J2EEComponentCreationWizardPage.this.advancedComposite.getSize().y;
            }
            return height;
        }

        private int computeAdvancedHeight() {
            if (this.advancedHeight == -1) {
                Point controlSize = J2EEComponentCreationWizardPage.this.getControl().getSize();
                if (controlSize.x != 0) {
                    Point pageSize = J2EEComponentCreationWizardPage.this.getControl().computeSize(-1, -1);
                    int minHeight = this.originalSize.y - controlSize.y;
                    this.advancedHeight = pageSize.y + minHeight;
                }
            }
            return this.advancedHeight;
        }
    }
}

