/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.provider.J2EEItemProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class J2EEUtilityJarItemProvider
extends J2EEItemProvider {
    public static final String UTILITY_JARS = J2EEUIMessages.getResourceString("Utility_JARs_UI_");
    private boolean childrenLoaded = false;
    private Application application = null;

    public J2EEUtilityJarItemProvider(Application app, AdapterFactory adapterFactory, Object parent) {
        super(adapterFactory);
        this.setParent(parent);
        this.application = app;
        UtilityJarResourceChangeListener.INSTANCE.addUtilityJarItemProvider(ProjectUtilities.getProject((EObject)this.application), this);
    }

    public boolean hasChildren(Object object) {
        this.getChildren(object);
        return !this.children.isEmpty();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getChildren(Object object) {
        if (this.childrenLoaded) return this.children;
        try {
            this.disableNotification();
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    J2EEUtilityJarItemProvider.this.computeChildren();
                }
            });
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.enableNotification();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.enableNotification();
        return this.children;
    }

    public void dispose() {
        super.dispose();
        UtilityJarResourceChangeListener.INSTANCE.removeUtilityJarItemProvider(ProjectUtilities.getProject((EObject)this.application), this);
    }

    private void computeChildren() {
        block9: {
            this.childrenLoaded = true;
            IVirtualComponent ear = ComponentUtilities.findComponent((EObject)this.application);
            if (ear == null) break block9;
            IVirtualReference[] modules = ear.getReferences();
            int i = 0;
            while (i < modules.length) {
                block10: {
                    IFile utilityJar;
                    IVirtualComponent module;
                    block11: {
                        module = modules[i].getReferencedComponent();
                        if (module.getProject() == null || !module.getProject().isAccessible()) break block10;
                        if (!J2EEProjectUtilities.isUtilityProject((IProject)module.getProject())) break block11;
                        IProject project = ProjectUtilities.getProject((EObject)this.application);
                        if (project == null) break block10;
                        utilityJar = project.getFile(String.valueOf(module.getName()) + ".jar");
                        if (utilityJar != null) {
                            this.children.add((Object)utilityJar);
                        }
                    }
                    if (module.isBinary()) {
                        File diskFile = ((VirtualArchiveComponent)module).getUnderlyingDiskFile();
                        if (diskFile.exists()) {
                            this.children.add((Object)diskFile);
                        } else {
                            utilityJar = ((VirtualArchiveComponent)module).getUnderlyingWorkbenchFile();
                            if (utilityJar != null) {
                                this.children.add((Object)utilityJar);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static boolean isJarFile(IResource member) {
        return member.getType() == 1 && member.getName().toLowerCase().endsWith(".jar");
    }

    public static boolean isComponentFile(IResource member) {
        return member.getType() == 1 && member.getName().toLowerCase().endsWith(".component");
    }

    public Object getImage(Object object) {
        return J2EEPlugin.getPlugin().getImage("folder");
    }

    public String getText(Object object) {
        return UTILITY_JARS;
    }

    public void utilityJarChanged(IResource resource, IResourceDelta delta) {
        if (this.childrenLoaded) {
            if (delta.getKind() == 1 && !this.children.contains((Object)resource)) {
                this.children.add((Object)resource);
            } else if (delta.getKind() == 2 && this.children.contains((Object)resource)) {
                this.children.remove((Object)resource);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IRESOURCE_CLASS || adapter == IPROJECT_CLASS) {
            return this.application != null ? ProjectUtilities.getProject((EObject)this.application) : null;
        }
        return null;
    }

    protected static class UtilityJarResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        protected static final UtilityJarResourceChangeListener INSTANCE = new UtilityJarResourceChangeListener();
        private boolean listening = false;
        private Map earProjectsToUtilityJarProviderMap;

        protected UtilityJarResourceChangeListener() {
        }

        public void addUtilityJarItemProvider(IProject project, J2EEUtilityJarItemProvider utilityJarItemProvider) {
            List providers = this.getProviders(project);
            if (providers != null) {
                providers.add(utilityJarItemProvider);
            }
            if (!this.listening) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
                this.listening = true;
            }
        }

        private List getProviders(IProject project) {
            ArrayList result = (ArrayList)this.getEarProjectsToUtilityJarProviderMap().get(project);
            if (result == null && project != null) {
                result = new ArrayList();
                this.getEarProjectsToUtilityJarProviderMap().put(project, result);
            }
            return result;
        }

        private Map getEarProjectsToUtilityJarProviderMap() {
            if (this.earProjectsToUtilityJarProviderMap == null) {
                this.earProjectsToUtilityJarProviderMap = new HashMap();
            }
            return this.earProjectsToUtilityJarProviderMap;
        }

        public void removeUtilityJarItemProvider(IProject project, J2EEUtilityJarItemProvider utilityJarItemProvider) {
            List providers = this.getProviders(project);
            providers.remove((Object)utilityJarItemProvider);
            if (providers.isEmpty()) {
                this.getEarProjectsToUtilityJarProviderMap().remove(project);
            }
            if (this.getEarProjectsToUtilityJarProviderMap().isEmpty()) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                this.listening = false;
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        public boolean visit(IResourceDelta delta) {
            switch (delta.getResource().getType()) {
                case 2: 
                case 8: {
                    return true;
                }
                case 4: {
                    return this.getEarProjectsToUtilityJarProviderMap().containsKey(delta.getResource());
                }
                case 1: {
                    IResource resource = delta.getResource();
                    if (J2EEUtilityJarItemProvider.isComponentFile(resource)) {
                        List utilityJarItemProviders = this.getProviders(resource.getProject());
                        int i = 0;
                        while (i < utilityJarItemProviders.size()) {
                            ((J2EEUtilityJarItemProvider)((Object)utilityJarItemProviders.get(i))).getChildren().clear();
                            ((J2EEUtilityJarItemProvider)((Object)utilityJarItemProviders.get(i))).computeChildren();
                            ++i;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
    }
}

