/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ui.project.facet;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.ui.project.facet.EarProjectWizard;
import org.eclipse.jst.j2ee.web.project.facet.IWebFacetInstallDataModelProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class EarSelectionPanel
implements IWebFacetInstallDataModelProperties {
    private final Button addToEar;
    private final Combo combo;
    private final Button newButton;
    private final Label label;
    private final IDataModel model;
    private DataModelSynchHelper synchhelper;

    public EarSelectionPanel(IDataModel model, Composite parent) {
        this.model = model;
        this.synchhelper = new DataModelSynchHelper(model);
        this.addToEar = new Button(parent, 32);
        this.addToEar.setText(Resources.addToEarLabel);
        this.addToEar.setLayoutData((Object)EarSelectionPanel.gdhspan(EarSelectionPanel.gdhfill(), 3));
        this.synchhelper.synchCheckbox(this.addToEar, "IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", null);
        this.label = new Label(parent, 0);
        this.label.setText(Resources.earProjectLabel);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        this.label.setLayoutData((Object)gridData);
        this.combo = new Combo(parent, 0);
        this.combo.setLayoutData((Object)EarSelectionPanel.gdhfill());
        this.newButton = new Button(parent, 8);
        this.newButton.setText(Resources.newButtonLabel);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EarSelectionPanel.this.handleAddButton();
            }
        });
        this.synchhelper.synchCombo(this.combo, "IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", new Control[]{this.label, this.newButton});
    }

    private void handleAddButton() {
        EarProjectWizard wizard = new EarProjectWizard();
        WizardDialog dialog = new WizardDialog(this.newButton.getShell(), (IWizard)wizard);
        IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        wizard.setRuntimeInDataModel(runtime);
        if (dialog.open() != 256) {
            this.model.notifyPropertyChange("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", 4);
            String earproj = wizard.getProjectName();
            this.model.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)earproj);
        }
    }

    private static GridData gdhfill() {
        return new GridData(768);
    }

    public static final GridData gdhspan(GridData gd, int span) {
        gd.horizontalSpan = span;
        return gd;
    }

    public void dispose() {
        if (this.synchhelper != null) {
            this.synchhelper.dispose();
            this.synchhelper = null;
        }
    }

    public String getComboText() {
        return this.combo.getText();
    }

    private static final class Resources
    extends NLS {
        public static String addToEarLabel;
        public static String newButtonLabel;
        public static String earProjectLabel;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.ui.project.facet.EarSelectionPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jst.j2ee.ui.project.facet.EarSelectionPanel$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

