/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.validation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ValidateXmlCommand;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ManifestException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.validation.EarHelper;
import org.eclipse.jst.j2ee.internal.validation.ManifestLineValidator;
import org.eclipse.jst.j2ee.internal.validation.UIEarHelper;
import org.eclipse.jst.j2ee.internal.validation.UIEarMessageConstants;
import org.eclipse.jst.j2ee.model.internal.validation.EarValidator;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.MessageLimitException;

public class UIEarValidator
extends EarValidator
implements UIEarMessageConstants {
    public static final String VALIDATOR_ID = "org.eclipse.jst.j2ee.internal.validation.UIEarValidator";
    public static final String MANIFEST_GROUP_NAME = "WSAD.EAR.MANIFEST";
    protected UIEarHelper earHelper;
    private IProject project = null;

    public Command createValidateXMLCommand() {
        ValidateXmlCommand cmd = (ValidateXmlCommand)super.createValidateXMLCommand();
        cmd.setValidateNested(false);
        return cmd;
    }

    protected String getResourceName() {
        return ((EarHelper)this._helper).getProject().getName();
    }

    protected void duplicateProjectMapError(String earProjectName, String moduleUri, String projectName) {
        String[] params = new String[]{projectName, earProjectName, moduleUri};
        this.addError(this.getBaseName(), "DUPLICATE_MODULE_FOR_PROJECT_NAME_ERROR_", params, this.appDD);
    }

    protected void cleanUpSubTaskMessages(EObject ref) {
        IFile file;
        String groupName = "EJB_REF_GROUP_NAME";
        if (ref instanceof EjbRef) {
            ref = (EjbRef)ref;
        } else if (ref instanceof ResourceRef) {
            ref = (ResourceRef)ref;
            groupName = "RES_REF_GROUP_NAME";
        } else if (ref instanceof ServiceRef) {
            ref = (ServiceRef)ref;
            groupName = "SERVICE_REF_GROUP_NAME";
        } else if (ref instanceof ResourceEnvRef) {
            ref = (ResourceEnvRef)ref;
            groupName = "RES_ENV_REF_GROUP_NAME";
        } else if (ref instanceof SecurityRoleRef) {
            ref = (SecurityRoleRef)ref;
            groupName = "SEC_ROLE_REF_GROUP_NAME";
        } else if (ref instanceof MessageDestinationRef) {
            ref = (MessageDestinationRef)ref;
            groupName = "MESSAGE_REF_GROUP_NAME";
        }
        Resource res = ref.eResource();
        if (res != null && (file = WorkbenchResourceHelper.getFile((Resource)res)) != null) {
            this._reporter.removeMessageSubset((IValidator)this, (Object)file, groupName);
        }
    }

    protected void cleanUpAllRefSubTaskMessages(Resource res) {
        if (res != null) {
            IFile file = WorkbenchResourceHelper.getFile((Resource)res);
            if (file != null) {
                this._reporter.removeMessageSubset((IValidator)this, (Object)file, "EJB_REF_GROUP_NAME");
            }
            this._reporter.removeMessageSubset((IValidator)this, (Object)file, "RES_REF_GROUP_NAME");
            this._reporter.removeMessageSubset((IValidator)this, (Object)file, "SERVICE_REF_GROUP_NAME");
            this._reporter.removeMessageSubset((IValidator)this, (Object)file, "SEC_ROLE_REF_GROUP_NAME");
            this._reporter.removeMessageSubset((IValidator)this, (Object)file, "MESSAGE_REF_GROUP_NAME");
            this._reporter.removeMessageSubset((IValidator)this, (Object)file, "RES_ENV_REF_GROUP_NAME");
        }
    }

    public UIEarHelper getEarHelper() {
        return this.earHelper;
    }

    protected void invalidClassPathEntryWarning(String entry, Archive anArchive) {
        String[] params = new String[]{anArchive.getURI(), entry};
        this.addWarning(this.getBaseName(), "INVALID_MANIFEST_CLASSPATH_ONE_WARN_", params, this.getManifestFile(anArchive), MANIFEST_GROUP_NAME);
    }

    protected void invalidClassPathEntryWarning(String entry, String resolvedEntry, Archive anArchive) {
        String[] params = new String[]{anArchive.getURI(), entry, resolvedEntry};
        this.addWarning(this.getBaseName(), "INVALID_MANIFEST_CLASSPATH_TWO_WARN_", params, this.getManifestFile(anArchive), MANIFEST_GROUP_NAME);
    }

    protected void invalidDepedencyWarning(String entry, Archive anArchive, ModuleFile m) {
        String[] params = new String[]{m.getURI(), entry, anArchive.getURI()};
        this.addWarning(this.getBaseName(), "INVALID_MANIFEST_CLASSPATH_DEPENDENCY_WARN_", params, this.getManifestFile(anArchive), MANIFEST_GROUP_NAME);
    }

    public void setEarHelper(UIEarHelper newEarHelper) {
        this.earHelper = newEarHelper;
    }

    public void validate(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        IVirtualFile ddFile;
        this.earHelper = (UIEarHelper)inHelper;
        IProject proj = ((IWorkbenchContext)inHelper).getProject();
        IVirtualComponent earModule = ComponentCore.createComponent((IProject)proj);
        if (J2EEProjectUtilities.isEARProject(proj) && (ddFile = earModule.getRootFolder().getFile("META-INF/application.xml")).exists()) {
            super.validate(inHelper, inReporter);
            this.validateModuleMaps(earModule);
            this.validateManifests();
        }
    }

    public void validateManifests() throws ValidationException {
        if (this.earFile == null) {
            return;
        }
        List archives = this.earFile.getArchiveFiles();
        int i = 0;
        while (i < archives.size()) {
            try {
                Archive anArchive = (Archive)archives.get(i);
                IFile target = this.getManifestFile(anArchive);
                if (target != null) {
                    this._reporter.removeMessageSubset((IValidator)this, (Object)target, MANIFEST_GROUP_NAME);
                }
                this.validateManifestCase(anArchive);
                this.validateManifestLines(anArchive);
                this.validateManifestClasspath(anArchive);
            }
            catch (MessageLimitException messageLimitException) {}
            ++i;
        }
    }

    public void validateManifestCase(Archive anArchive) {
        String mfuri = "META-INF/MANIFEST.MF";
        if (anArchive.containsFile(mfuri)) {
            return;
        }
        anArchive.getOptions().setIsReadOnly(true);
        EList files = anArchive.getFiles();
        String uri = null;
        int i = 0;
        while (i < files.size()) {
            File aFile = (File)files.get(i);
            uri = aFile.getURI();
            if (mfuri.equalsIgnoreCase(uri) && !mfuri.equals(uri)) {
                String[] params = new String[]{uri, anArchive.getURI()};
                IFile target = this.earHelper.getProject().getFile("META-INF/MANIFEST.MF");
                this.addError(this.getBaseName(), "INVALID_CASE_FOR_MANIFEST_ERROR_", params, target);
            }
            ++i;
        }
    }

    public void validateManifestClasspath(Archive anArchive) throws ValidationException {
        ArchiveManifest manifest = null;
        try {
            manifest = anArchive.getManifest();
        }
        catch (ManifestException mf) {
            mf.getMessage();
            String[] args = new String[]{anArchive.getURI()};
            this.addError("ERROR_READING_MANIFEST_ERROR_", args);
        }
        if (manifest == null) {
            return;
        }
        String[] cp = manifest.getClassPathTokenized();
        int i = 0;
        while (i < cp.length) {
            block9: {
                String uri = ArchiveUtil.deriveEARRelativeURI((String)cp[i], (Archive)anArchive);
                if (uri == null) {
                    this.invalidClassPathEntryWarning(cp[i], anArchive);
                } else {
                    ModuleFile m;
                    Archive archive;
                    File f = null;
                    try {
                        f = this.earFile.getFile(uri);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.invalidClassPathEntryWarning(cp[i], this.earFile.getURI(), anArchive);
                        break block9;
                    }
                    if (f != null && f.isArchive() && anArchive.isModuleFile() && !ArchiveUtil.isValidDependency((Archive)(archive = (Archive)f), (Archive)(m = (ModuleFile)anArchive))) {
                        this.invalidDepedencyWarning(cp[i], archive, m);
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    protected void validateManifestLines(Archive anArchive) throws ValidationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 86->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void addErrorsIfNecessary(Archive anArchive, ManifestLineValidator mfVal) {
        if (!mfVal.hasErrors()) {
            return;
        }
        IFile target = this.getManifestFile(anArchive);
        if (!mfVal.endsWithLineBreak()) {
            this.addFileEndError(anArchive, mfVal, target);
        }
        int[] lines = mfVal.getLineNumbersExceedingLimit();
        int i = 0;
        while (i < lines.length) {
            this.addLineLengthError(anArchive, target, lines[i]);
            ++i;
        }
    }

    protected void addLineLengthError(Archive anArchive, IFile target, int lineNo) {
        String[] args = new String[]{Integer.toString(lineNo), anArchive.getURI()};
        if (target != null) {
            this.addError(this.getBaseName(), "MANIFEST_LINE_EXCEEDS_LENGTH_ERROR_", args, target, MANIFEST_GROUP_NAME, lineNo);
        } else {
            this.addError(this.getBaseName(), "MANIFEST_LINE_EXCEEDS_LENGTH_ERROR_", args, null, MANIFEST_GROUP_NAME);
        }
    }

    protected void addFileEndError(Archive anArchive, ManifestLineValidator mfVal, IFile target) {
        String[] args = new String[]{anArchive.getURI()};
        if (target != null) {
            this.addError(this.getBaseName(), "MANIFEST_LINE_END_ERROR_", args, this.getManifestFile(anArchive), MANIFEST_GROUP_NAME, mfVal.getLineCount());
        } else {
            this.addError(this.getBaseName(), "MANIFEST_LINE_END_ERROR_", args, MANIFEST_GROUP_NAME);
        }
    }

    protected void handleManifestException(IOException ex, Archive anArchive) throws ValidationException {
        Logger.getLogger().logError((Throwable)ex);
        Message message = new Message(this.getBaseName(), 1, "ERROR_READING_MANIFEST_ERROR_", new String[]{anArchive.getURI()});
        throw new ValidationException((IMessage)message, (Throwable)ex);
    }

    protected void validateUtilJarContainsNoSpaces(EARArtifactEdit edit, IVirtualComponent module) {
        IVirtualReference[] utilJars = edit.getUtilityModuleReferences();
        if (utilJars == null) {
            return;
        }
        int i = 0;
        while (i < utilJars.length) {
            String uri;
            IVirtualReference utilModule = utilJars[i];
            if (utilModule != null && (uri = ModuleURIUtil.fullyQualifyURI((IProject)this.project).toString()) != null && uri.indexOf(" ") != -1) {
                String[] params = new String[]{uri};
                this.addError(this.getBaseName(), "URI_CONTAINS_SPACES_ERROR_", params, this.appDD);
            }
            ++i;
        }
    }

    protected void validateDuplicateUtilJars(EARArtifactEdit edit, IVirtualComponent module) {
        IVirtualReference[] utilJars = edit.getUtilityModuleReferences();
        HashSet<String> visitedUtilUri = new HashSet<String>();
        if (utilJars == null) {
            return;
        }
        int i = 0;
        while (i < utilJars.length) {
            IVirtualReference utilModule = utilJars[i];
            if (utilModule != null) {
                String uri = ModuleURIUtil.fullyQualifyURI((IProject)this.project).toString();
                if (visitedUtilUri.contains(uri)) {
                    String compName = module.getName();
                    this.duplicateUtilError(module.getName(), uri, compName);
                } else {
                    visitedUtilUri.add(uri);
                }
            }
            ++i;
        }
    }

    protected void duplicateUtilError(String earProjectName, String moduleUri, String projectName) {
        String[] params = new String[]{projectName, earProjectName, moduleUri};
        this.addError(this.getBaseName(), "DUPLICATE_UTILJAR_FOR_PROJECT_NAME_ERROR_", params);
    }

    /*
     * Exception decompiling
     */
    public void validateModuleMaps(IVirtualComponent component) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 175->179)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void validateModuleURIExtension(Module module) {
        String newUri = module.getUri();
        if (newUri != null && newUri.length() > 0) {
            if (module instanceof EjbModule && !newUri.endsWith(".jar")) {
                String[] params = new String[]{module.getUri()};
                IFile target = this.earHelper.getProject().getFile("META-INF/application.xml");
                this.addWarning(this.getBaseName(), "INVALID_URI_FOR_MODULE_ERROR_", params, target);
            } else if (module instanceof WebModule && !newUri.endsWith(".war")) {
                String[] params = new String[]{module.getUri()};
                IFile target = this.earHelper.getProject().getFile("META-INF/application.xml");
                this.addWarning(this.getBaseName(), "INVALID_URI_FOR_MODULE_ERROR_", params, target);
            }
        }
    }

    protected IFile getManifestFile(Archive anArchive) {
        URIConverter conv = anArchive.getResourceSet().getURIConverter();
        if (conv instanceof WorkbenchURIConverter) {
            WorkbenchURIConverter wbConv = (WorkbenchURIConverter)conv;
            IContainer input = wbConv.getInputContainer();
            if (input == null) {
                return null;
            }
            IProject p = input.getProject();
            if (p == null || JemProjectUtilities.isBinaryProject((IProject)p)) {
                return null;
            }
            IFile result = J2EEProjectUtilities.getManifestFile(p);
            if (result != null && result.exists()) {
                return result;
            }
        }
        return null;
    }

    protected void validateDocType(EARArtifactEdit edit, IVirtualComponent module) {
        if (edit == null) {
            return;
        }
        if (edit.getJ2EEVersion() >= 13 && this.appDD.getVersionID() < 13) {
            String[] params = new String[]{"1.2", this.getResourceName(), "1.3"};
            this.addError(this.getBaseName(), "EAR_INVALID_DOC_TYPE_ERROR_", params, this.appDD);
        } else if (edit.getJ2EEVersion() < 13 && this.appDD.getVersionID() >= 13) {
            String[] params = new String[]{"1.3", this.getResourceName(), "1.2"};
            this.addError(this.getBaseName(), "EAR_INVALID_DOC_TYPE_ERROR_", params, this.appDD);
        }
    }

    public void validateUriAlreadyExistsInEar(EARArtifactEdit edit, IVirtualComponent component) {
        IVirtualReference[] modules = edit.getJ2EEModuleReferences();
        if (modules == null) {
            return;
        }
        int i = 0;
        while (i < modules.length) {
            IVirtualReference reference = modules[i];
            IVirtualComponent module = reference.getReferencedComponent();
            if (module != null && module.getRootFolder().getRuntimePath() != null) {
                IProject currentEARProject = this.earHelper.getProject();
                try {
                    IFile exFile = currentEARProject.getFile(module.getRootFolder().getRuntimePath());
                    if (exFile != null && exFile.exists()) {
                        String[] params = new String[]{module.getRootFolder().getRuntimePath().toString(), currentEARProject.getName()};
                        this.addWarning(this.getBaseName(), "URI_ALREADY_EXISTS_IN_EAR_WARN_", params, this.appDD);
                    }
                }
                catch (IllegalArgumentException iae) {
                    Logger.getLogger().logError((Throwable)iae);
                }
            }
            ++i;
        }
    }
}

