/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;

public class JSPTranslationExtension
extends JSPTranslation {
    private static final boolean DEBUG;
    private static final String CT_ID_JSP_FRAGMENT = "org.eclipse.jst.jsp.core.jspfragmentsource";
    private IDocument fJspDocument = null;
    private IDocument fJavaDocument = null;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jsptranslation");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public JSPTranslationExtension(IDocument jspDocument, IDocument javaDocument, IJavaProject javaProj, JSPTranslator translator) {
        super(javaProj, translator);
        this.fJspDocument = jspDocument;
        this.fJavaDocument = javaDocument;
        this.addPositionsToDocuments();
    }

    public IDocument getJspDocument() {
        return this.fJspDocument;
    }

    public IDocument getJavaDocument() {
        return this.fJavaDocument;
    }

    public String getJavaText() {
        return this.getJavaDocument() != null ? this.getJavaDocument().get() : "";
    }

    public TextEdit getJspEdit(TextEdit javaEdit) {
        if (javaEdit == null) {
            return null;
        }
        ArrayList<Object> jspEdits = new ArrayList<Object>();
        int offset = javaEdit.getOffset();
        int length = javaEdit.getLength();
        if (javaEdit instanceof MultiTextEdit && javaEdit.getChildren().length > 0) {
            IRegion r = TextEdit.getCoverage((TextEdit[])this.getAllEdits(javaEdit));
            offset = r.getOffset();
            length = r.getLength();
        }
        Position[] javaPositions = this.getJavaRanges(offset, length);
        Position[] jspPositions = new Position[javaPositions.length];
        PositionDelta[] deltas = new PositionDelta[javaPositions.length];
        int i = 0;
        while (i < javaPositions.length) {
            deltas[i] = new PositionDelta(javaPositions[i].offset, javaPositions[i].length);
            if (!this.isIndirect(javaPositions[i].offset)) {
                jspPositions[i] = (Position)this.getJava2JspMap().get(javaPositions[i]);
            }
            ++i;
        }
        if (DEBUG) {
            System.out.println("================================================");
            System.out.println("deltas:");
            String javaText = this.getJavaText();
            int i2 = 0;
            while (i2 < deltas.length) {
                System.out.println("pos[" + deltas[i2].preOffset + ":" + deltas[i2].preLength + "]" + javaText.substring(deltas[i2].preOffset, deltas[i2].preOffset + deltas[i2].preLength));
                ++i2;
            }
            System.out.println("===============================================");
        }
        UndoEdit undo = null;
        try {
            undo = javaEdit.apply(this.getJavaDocument());
        }
        catch (MalformedTreeException e) {
            Logger.logException(e);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        String newJavaText = this.getJavaDocument().get();
        if (DEBUG) {
            System.out.println("java post format text:\n" + newJavaText);
        }
        int i3 = 0;
        while (i3 < javaPositions.length) {
            deltas[i3].setPostEditData(javaPositions[i3].offset, javaPositions[i3].length, javaPositions[i3].isDeleted);
            ++i3;
        }
        Position jspPos = null;
        String replaceText = "";
        int i4 = 0;
        while (i4 < deltas.length) {
            jspPos = jspPositions[i4];
            if (jspPos != null) {
                if (deltas[i4].isDeleted) {
                    jspEdits.add(new DeleteEdit(jspPos.offset, jspPos.length));
                } else {
                    replaceText = newJavaText.substring(deltas[i4].postOffset, deltas[i4].postOffset + deltas[i4].postLength);
                    jspEdits.add(new ReplaceEdit(jspPos.offset, jspPos.length, replaceText));
                }
                if (DEBUG) {
                    this.debugReplace(deltas, jspPos, replaceText, i4);
                }
            } else if (this.isImport(javaPositions[i4].getOffset()) && replaceText.lastIndexOf("import ") != -1) {
                replaceText = newJavaText.substring(deltas[i4].postOffset, deltas[i4].postOffset + deltas[i4].postLength);
                String importText = replaceText.substring(replaceText.lastIndexOf("import "), replaceText.indexOf(";"));
                importText = "<%@page import=\"" + importText + "\" %>\n";
                jspEdits.add(new InsertEdit(0, importText));
            }
            ++i4;
        }
        TextEdit allJspEdits = this.createMultiTextEdit(jspEdits.toArray(new TextEdit[jspEdits.size()]));
        if (undo != null) {
            try {
                undo.apply(this.getJavaDocument());
            }
            catch (MalformedTreeException e) {
                Logger.logException(e);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
        return allJspEdits;
    }

    private TextEdit createMultiTextEdit(TextEdit[] edits) {
        if (edits.length == 0) {
            return new MultiTextEdit();
        }
        IRegion region = TextEdit.getCoverage((TextEdit[])edits);
        MultiTextEdit multiEdit = new MultiTextEdit(region.getOffset(), region.getLength());
        int i = 0;
        while (i < edits.length) {
            this.addToMultiEdit(edits[i], multiEdit);
            ++i;
        }
        return multiEdit;
    }

    private void addToMultiEdit(TextEdit edit, MultiTextEdit multiEdit) {
        TextEdit[] children = multiEdit.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].covers(edit)) {
                return;
            }
            ++i;
        }
        multiEdit.addChild(edit);
    }

    private void addPositionsToDocuments() {
        if (this.getJavaDocument() != null && this.getJspDocument() != null) {
            HashMap java2jsp = this.getJava2JspMap();
            Iterator it = java2jsp.keySet().iterator();
            Position javaPos = null;
            while (it.hasNext()) {
                block6: {
                    javaPos = (Position)it.next();
                    try {
                        this.fJavaDocument.addPosition(javaPos);
                    }
                    catch (BadLocationException e) {
                        if (!DEBUG) break block6;
                        System.out.println("tyring to add Java Position:[" + javaPos.offset + ":" + javaPos.length + "] to " + this.getJavaPath());
                        Logger.logException(e);
                    }
                }
                try {
                    this.fJspDocument.addPosition((Position)java2jsp.get(javaPos));
                }
                catch (BadLocationException e) {
                    if (!DEBUG) continue;
                    System.out.println("tyring to add JSP Position:[" + ((Position)java2jsp.get((Object)javaPos)).offset + ":" + ((Position)java2jsp.get((Object)javaPos)).length + "] to " + this.getJavaPath());
                    Logger.logException(e);
                }
            }
        }
    }

    private TextEdit[] getAllEdits(TextEdit javaEdit) {
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        if (javaEdit instanceof MultiTextEdit) {
            TextEdit[] children = javaEdit.getChildren();
            int i = 0;
            while (i < children.length) {
                result.addAll(Arrays.asList(this.getAllEdits(children[i])));
                ++i;
            }
        } else {
            result.add(javaEdit);
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    public void reconcileCompilationUnit() {
        if (!this.isJspFragment()) {
            super.reconcileCompilationUnit();
        }
    }

    private boolean isJspFragment() {
        boolean isFrag = false;
        ITextFileBuffer buf = FileBufferModelManager.getInstance().getBuffer(this.getJspDocument());
        isFrag = buf != null ? this.isJspFragment(buf) : this.isJspFragment(this.getJspDocument());
        return isFrag;
    }

    /*
     * Exception decompiling
     */
    private boolean isJspFragment(IDocument sDoc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 120->123)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isJspFragment(ITextFileBuffer buf) {
        IContentType jspFragType;
        IFile f;
        boolean isFrag = false;
        IPath loc = buf.getLocation();
        if (loc != null && (f = ResourcesPlugin.getWorkspace().getRoot().getFile(loc)) != null && f.exists() && (jspFragType = Platform.getContentTypeManager().getContentType(CT_ID_JSP_FRAGMENT)) != null) {
            isFrag = jspFragType.isAssociatedWith(f.getName());
        }
        return isFrag;
    }

    private void debugReplace(PositionDelta[] deltas, Position jspPos, String replaceText, int i) {
        String jspChunk = this.getJspDocument().get().substring(jspPos.offset, jspPos.offset + jspPos.length);
        if (!deltas[i].isDeleted) {
            System.out.println("replacing:");
            System.out.println("jsp:[" + jspChunk + "]");
            System.out.println("w/ :[" + replaceText + "]");
            System.out.println("--------------------------------");
        }
    }

    private class PositionDelta {
        public boolean isDeleted = false;
        public int preOffset = 0;
        public int preLength = 0;
        public int postOffset = 0;
        public int postLength = 0;

        public PositionDelta(int preOffset, int preLength) {
            this.preOffset = preOffset;
            this.preLength = preLength;
        }

        public void setPostEditData(int postOffset, int postLength, boolean isDeleted) {
            this.postOffset = postOffset;
            this.postLength = postLength;
            this.isDeleted = isDeleted;
        }
    }
}

