/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.jst.j2ee.webservice.wsdd.internal.impl.WsddFactoryImpl;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class ServiceHandlersWidgetOutputCommand
extends AbstractDataModelOperation {
    private WsddResource wsddResource_;
    private Hashtable wsDescToHandlers_;
    private Hashtable serviceDescNameToDescObj_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        try {
            Enumeration e = this.wsDescToHandlers_.keys();
            while (e.hasMoreElements()) {
                List handlerTableItems;
                Hashtable<String, PortComponent> wsPortsTable = new Hashtable<String, PortComponent>();
                Hashtable wsPortToHandlerTable = new Hashtable();
                String serviceDescName = (String)e.nextElement();
                WebServiceDescription wsDescription_ = (WebServiceDescription)this.serviceDescNameToDescObj_.get(serviceDescName);
                if (wsDescription_ != null) {
                    EList wsPorts = wsDescription_.getPortComponents();
                    int k = 0;
                    while (k < wsPorts.size()) {
                        PortComponent port = (PortComponent)wsPorts.get(k);
                        wsPortsTable.put(port.getPortComponentName(), port);
                        wsPortToHandlerTable.put(port.getPortComponentName(), new ArrayList());
                        ++k;
                    }
                }
                if ((handlerTableItems = (List)this.wsDescToHandlers_.get(serviceDescName)) != null) {
                    HandlerTableItem hti;
                    WsddFactoryImpl wsddFactory = new WsddFactoryImpl();
                    int i = 0;
                    while (i < handlerTableItems.size()) {
                        hti = (HandlerTableItem)handlerTableItems.get(i);
                        PortComponent wsPort = hti.getPort();
                        if (wsPort == null) {
                            if (wsPortsTable.get(hti.getPortName()) != null) {
                                wsPort = (PortComponent)wsPortsTable.get(hti.getPortName());
                            } else {
                                wsPort = wsddFactory.createPortComponent();
                                wsPort.setPortComponentName(hti.getPortName());
                                wsPortsTable.put(wsPort.getPortComponentName(), wsPort);
                            }
                        }
                        wsPortToHandlerTable.put(wsPort.getPortComponentName(), new ArrayList());
                        ++i;
                    }
                    i = 0;
                    while (i < handlerTableItems.size()) {
                        Object handler;
                        hti = (HandlerTableItem)handlerTableItems.get(i);
                        String portName = hti.getPortName();
                        PortComponent port = (PortComponent)wsPortsTable.get(portName);
                        if (port == null) {
                            return status;
                        }
                        EList existingHandlers = port.getHandlers();
                        if (!existingHandlers.contains(handler = hti.getHandler())) {
                            Handler newHandler = wsddFactory.createHandler();
                            newHandler.setHandlerName(hti.getHandlerName());
                            newHandler.setHandlerClass(hti.getHandlerClassName());
                            ((List)wsPortToHandlerTable.get(portName)).add(newHandler);
                        } else if (handler instanceof Handler) {
                            EtoolsCopyUtility copyUtil = new EtoolsCopyUtility();
                            copyUtil.setCopyAdapters(true);
                            Handler clonedHandler = (Handler)copyUtil.copy((EObject)((Handler)handler));
                            ((List)wsPortToHandlerTable.get(portName)).add(clonedHandler);
                        }
                        ++i;
                    }
                }
                this.removeExistingHandlers(wsPortsTable, wsPortToHandlerTable);
                this.addPortsToDescriptions(wsPortsTable, wsDescription_);
                this.addHandlersToPorts(wsPortsTable, wsPortToHandlerTable);
            }
            if (this.wsddResource_ != null) {
                this.wsddResource_.save(new HashMap());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    private void removeExistingHandlers(Hashtable portsTable, Hashtable portsToHandlersTable) {
        try {
            Enumeration ports = portsToHandlersTable.keys();
            while (ports.hasMoreElements()) {
                String portName = (String)ports.nextElement();
                Object port = portsTable.get(portName);
                if (port == null || !(port instanceof PortComponent)) continue;
                EList handlers = ((PortComponent)port).getHandlers();
                handlers.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addPortsToDescriptions(Hashtable portsTable, WebServiceDescription wsDescription_) {
        try {
            Enumeration ports = portsTable.keys();
            while (ports.hasMoreElements()) {
                String portName = (String)ports.nextElement();
                Object port = portsTable.get(portName);
                EList emfPorts = wsDescription_.getPortComponents();
                if (emfPorts.contains(port) || port == null || !(port instanceof PortComponent)) continue;
                emfPorts.add((PortComponent)port);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addHandlersToPorts(Hashtable portsTable, Hashtable portsToHandlersTable) {
        try {
            Enumeration ports = portsToHandlersTable.keys();
            while (ports.hasMoreElements()) {
                String portName = (String)ports.nextElement();
                Object port = portsTable.get(portName);
                if (port == null || !(port instanceof PortComponent)) continue;
                List handlers = (List)portsToHandlersTable.get(portName);
                EList modelHandlers = ((PortComponent)port).getHandlers();
                modelHandlers.addAll(handlers);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setHandlersList(List handlerTableItems) {
    }

    public void setWsDescToHandlers(Hashtable wsDescToHandlers) {
        this.wsDescToHandlers_ = wsDescToHandlers;
    }

    public void setWsddResource(WsddResource wsddRes) {
        this.wsddResource_ = wsddRes;
    }

    public void setServiceDescNameToDescObj(Hashtable serviceDescNameToDescObj) {
        this.serviceDescNameToDescObj_ = serviceDescNameToDescObj;
    }
}

