/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.widgets;

import java.util.Hashtable;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.command.internal.env.core.data.DataFlowManager;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.env.ui.registry.WidgetRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.INamedWidgetContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.INamedWidgetContributorFactory;
import org.eclipse.wst.command.internal.env.ui.widgets.PageInfo;
import org.eclipse.wst.command.internal.env.ui.widgets.PageWizardDataEvents;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleCommandEngineManager;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.env.ui.widgets.WizardPageFactory;

public class WizardPageManager
extends SimpleCommandEngineManager {
    private WizardPageFactory pageFactory_;
    private Hashtable pageTable_;
    private IWizard wizard_;
    protected SimpleWidgetRegistry registry_;
    private PageWizardDataEvents currentPage_;
    private PageWizardDataEvents nextPage_;
    private PageWizardDataEvents nextPeekPage_;
    private PageWizardDataEvents firstPage_;
    private CommandFragment lastUndoFragment_;
    private boolean firstFragment_;
    private INamedWidgetContributorFactory widgetFactory_;
    private Stack widgetStack_;
    private Stack widgetStackStack_;
    private Hashtable widgetTable_;
    private WidgetRegistry widgetRegistry_;
    private Hashtable widgetFactoryTable_;

    public WizardPageManager(SimpleWidgetRegistry registry, WizardPageFactory pageFactory, IWizard wizard, DataFlowManager dataManager, EclipseEnvironment environment) {
        super(environment, dataManager);
        this.pageFactory_ = pageFactory;
        this.pageTable_ = new Hashtable();
        this.registry_ = registry;
        this.wizard_ = wizard;
        this.widgetTable_ = new Hashtable();
        this.widgetFactoryTable_ = new Hashtable();
        this.widgetRegistry_ = WidgetRegistry.instance();
        this.widgetStackStack_ = new Stack();
    }

    public IStatus runForwardToNextStop() {
        this.firstFragment_ = true;
        this.nextPage_ = null;
        IWizardContainer container = this.wizard_.getContainer();
        if (container == null || container.getCurrentPage() == null) {
            container = null;
        }
        return super.runForwardToNextStop((IRunnableContext)container);
    }

    public IWizardPage getCurrentPage() {
        return this.currentPage_;
    }

    public boolean hasNextPage() {
        this.nextPeekPage_ = null;
        try {
            this.nextPeekPage_ = this.getNextPageInGroup(this.widgetFactory_, false);
            if (this.nextPeekPage_ == null) {
                this.engine_.peekForwardToNextStop();
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
        }
        return this.nextPeekPage_ != null;
    }

    public IWizardPage getNextPage() {
        try {
            if (this.currentPage_ != null) {
                this.currentPage_.getDataEvents().externalize();
            }
            this.nextPage_ = this.getNextPageInGroup(this.widgetFactory_, true);
            if (this.nextPage_ == null) {
                this.widgetFactory_ = null;
                this.widgetStack_ = null;
                IStatus status = this.runForwardToNextStop();
                if (status.getSeverity() == 4) {
                    this.undoToLastPage();
                }
            }
            if (this.nextPage_ != null) {
                this.nextPage_.setWizard(this.wizard_);
            }
            return this.nextPage_;
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handlePageVisible(PageWizardDataEvents page, boolean isPageVisible) {
        block14: {
            if (!isPageVisible && page == this.firstPage_ && page == this.currentPage_) {
                this.undoToLastPage();
                this.currentPage_ = null;
                this.firstPage_ = null;
            }
            if (this.currentPage_ != null && page == this.currentPage_.getPreviousPage() && isPageVisible) {
                if (this.widgetFactory_ != null) {
                    if (this.widgetStack_.size() > 0) {
                        this.widgetStack_.pop();
                    }
                    if (this.widgetStack_.size() == 0) {
                        this.widgetFactory_ = null;
                        this.widgetStack_ = null;
                        this.widgetStackStack_.pop();
                    }
                }
                if (this.widgetFactory_ == null) {
                    this.undoToLastPage();
                }
                this.currentPage_ = page;
                return;
            }
            if (!isPageVisible) return;
            try {
                try {
                    WidgetDataEvents dataEvents = page.getDataEvents();
                    this.dataManager_.process((Object)dataEvents);
                    dataEvents.internalize();
                    page.validatePageToStatus();
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (this.currentPage_ != null) {
                    page.setPreviousPage(this.currentPage_);
                }
                if (this.firstPage_ == null) {
                    this.firstPage_ = page;
                }
                this.currentPage_ = page;
                throw throwable;
            }
            {
                Object var4_7 = null;
                if (this.currentPage_ == null) break block14;
            }
            page.setPreviousPage(this.currentPage_);
        }
        if (this.firstPage_ == null) {
            this.firstPage_ = page;
        }
        this.currentPage_ = page;
    }

    public boolean performFinish() {
        boolean doneOk = true;
        PageWizardDataEvents startPage = this.currentPage_;
        this.currentPage_.getDataEvents().externalize();
        do {
            IStatus status;
            if ((status = this.runForwardToNextStop()).getSeverity() == 4) {
                doneOk = false;
                continue;
            }
            this.currentPage_ = this.nextPage_;
        } while (this.nextPage_ != null && doneOk);
        if (!doneOk) {
            PageWizardDataEvents page = null;
            boolean done = false;
            do {
                done = this.engine_.undoToLastStop();
            } while ((page = this.getPage(this.lastUndoFragment_)) != startPage && !done);
            this.currentPage_ = page;
        }
        return doneOk;
    }

    public boolean performCancel() {
        while (!this.engine_.undoToLastStop()) {
        }
        return true;
    }

    protected boolean peekFragment(CommandFragment fragment) {
        INamedWidgetContributorFactory factory;
        this.nextPeekPage_ = this.getPage(fragment);
        if (this.nextPeekPage_ == null && (factory = this.getWidgetFactory(fragment.getId())) != null) {
            this.nextPeekPage_ = this.getNextPageInGroup(factory, false);
        }
        return this.nextPeekPage_ == null;
    }

    protected boolean nextFragment(CommandFragment fragment) {
        if (!super.nextFragment(fragment)) {
            return false;
        }
        if (this.firstFragment_) {
            this.firstFragment_ = false;
        } else {
            this.widgetFactory_ = this.getWidgetFactory(fragment.getId());
            if (this.widgetFactory_ != null) {
                this.widgetStack_ = new Stack();
                this.nextPage_ = this.getNextPageInGroup(this.widgetFactory_, true);
                if (this.nextPage_ == null) {
                    this.widgetStack_ = null;
                    this.widgetFactory_ = null;
                } else {
                    StackEntry entry = new StackEntry();
                    entry.factory_ = this.widgetFactory_;
                    entry.stack_ = this.widgetStack_;
                    this.widgetStackStack_.push(entry);
                }
            } else {
                this.nextPage_ = this.getPage(fragment);
            }
        }
        return this.nextPage_ == null;
    }

    protected boolean undoFragment(CommandFragment fragment) {
        this.lastUndoFragment_ = fragment;
        return true;
    }

    private PageWizardDataEvents getNextPageInGroup(INamedWidgetContributorFactory factory, boolean pushNewWidget) {
        PageWizardDataEvents page = null;
        if (factory != null) {
            INamedWidgetContributor newWidget = null;
            if (this.widgetStack_ == null || this.widgetStack_.size() == 0) {
                newWidget = factory.getFirstNamedWidget();
            } else {
                INamedWidgetContributor currentWidget = (INamedWidgetContributor)this.widgetStack_.peek();
                newWidget = factory.getNextNamedWidget(currentWidget);
            }
            if (newWidget != null) {
                page = this.getPage(newWidget);
                if (pushNewWidget) {
                    this.widgetStack_.push(newWidget);
                }
            }
        }
        return page;
    }

    private void undoToLastPage() {
        boolean stackEmpty = false;
        boolean doneUndoing = false;
        while (!doneUndoing) {
            INamedWidgetContributorFactory factory;
            stackEmpty = this.engine_.undoToLastStop();
            PageWizardDataEvents page = null;
            if (this.lastUndoFragment_ != null && (page = this.getPage(this.lastUndoFragment_)) == null && (factory = this.getWidgetFactory(this.lastUndoFragment_.getId())) != null) {
                StackEntry entry = (StackEntry)this.widgetStackStack_.peek();
                this.widgetFactory_ = entry.factory_;
                this.widgetStack_ = entry.stack_;
                if (this.widgetStack_ != null && !this.widgetStack_.empty()) {
                    INamedWidgetContributor currentWidget = (INamedWidgetContributor)this.widgetStack_.peek();
                    page = this.getPage(currentWidget);
                }
            }
            boolean bl = doneUndoing = page != null || stackEmpty;
        }
    }

    private PageWizardDataEvents getPage(CommandFragment fragment) {
        PageInfo pageInfo;
        PageWizardDataEvents page = (PageWizardDataEvents)this.pageTable_.get(fragment);
        String id = fragment.getId();
        if (page == null && id != null && (pageInfo = this.registry_.getPageInfo(id)) != null) {
            page = this.pageFactory_.getPage(pageInfo, this);
            this.pageTable_.put(fragment, page);
        }
        return page;
    }

    private PageWizardDataEvents getPage(INamedWidgetContributor widget) {
        PageWizardDataEvents page = (PageWizardDataEvents)this.widgetTable_.get(widget);
        if (page == null) {
            PageInfo pageInfo = new PageInfo(widget.getTitle(), widget.getDescription(), widget.getWidgetContributorFactory());
            page = this.pageFactory_.getPage(pageInfo, this);
            this.widgetTable_.put(widget, page);
        }
        return page;
    }

    private INamedWidgetContributorFactory getWidgetFactory(String id) {
        INamedWidgetContributorFactory factory = (INamedWidgetContributorFactory)this.widgetFactoryTable_.get(id);
        if (factory == null) {
            factory = this.widgetRegistry_.getFactory(id);
            if (factory != null) {
                this.widgetFactoryTable_.put(id, factory);
                factory.registerDataMappings(this.dataManager_.getMappingRegistry());
                this.dataManager_.process((Object)factory);
            }
        } else {
            this.dataManager_.process((Object)factory);
        }
        return factory;
    }

    private class StackEntry {
        INamedWidgetContributorFactory factory_;
        Stack stack_;

        private StackEntry() {
        }
    }
}

