/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class RemoveReferenceComponentOperation
extends AbstractDataModelOperation {
    public RemoveReferenceComponentOperation() {
    }

    public RemoveReferenceComponentOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.removeReferencedComponents(monitor);
        return OK_STATUS;
    }

    protected void removeReferencedComponents(IProgressMonitor monitor) {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        if (!sourceComp.getProject().isAccessible()) {
            return;
        }
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        int i = 0;
        while (i < modList.size()) {
            IVirtualComponent comp = (IVirtualComponent)modList.get(i);
            if (comp != null && sourceComp != null) {
                IVirtualReference ref = sourceComp.getReference(comp.getName());
                if (ref != null && ref.getReferencedComponent() != null && ref.getReferencedComponent().isBinary()) {
                    this.removeRefereneceInComponent(sourceComp, ref);
                } else if (Arrays.asList(comp.getReferencingComponents()).contains(sourceComp)) {
                    String deployPath = this.model.getStringProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH");
                    Path path = new Path(deployPath);
                    if (ref != null && ref.getRuntimePath() != null && path != null && ref.getRuntimePath().equals((Object)path)) {
                        this.removeRefereneceInComponent(sourceComp, sourceComp.getReference(comp.getName()));
                        IProject targetProject = comp.getProject();
                        targetprojectList.add(targetProject);
                    }
                }
            }
            ++i;
        }
        try {
            ProjectUtilities.removeReferenceProjects((IProject)sourceComp.getProject(), targetprojectList);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void removeRefereneceInComponent(IVirtualComponent component, IVirtualReference reference) {
        ((VirtualComponent)component.getComponent()).removeReference(reference);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

