/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonNavigatorManager;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonSorter;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.CommonNavigatorActionGroup;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.filters.CommonViewerFilter;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;

public class CommonNavigator
extends ViewPart
implements ISetSelectionTarget,
ITabbedPropertySheetPageContributor {
    public static final String POPUP_MENU_ID = "#CommonNavigatorPopupMenu";
    public static final int IS_LINKING_ENABLED_PROPERTY = 1;
    private CommonViewer commonViewer;
    private CommonNavigatorManager commonManager;
    private ActionGroup commonActionGroup;
    private IMemento memento;
    private boolean isLinkingEnabled = false;
    private String LINKING_ENABLED = "CommonNavigator.LINKING_ENABLED";
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite aParent) {
        this.commonViewer = this.createCommonViewer(aParent);
        this.commonViewer.addFilter(this.createCommonFilter(this.commonViewer));
        this.commonViewer.setSorter(this.createCommonSorter(this.commonViewer));
        this.commonViewer.setInput(this.getInitialInput() != null ? this.getInitialInput() : ResourcesPlugin.getWorkspace().getRoot());
        this.commonViewer.getControl().addDisposeListener(this.createDisposeListener());
        this.getSite().setSelectionProvider((ISelectionProvider)this.commonViewer);
        this.commonActionGroup = this.createCommonActionGroup();
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.updateTitle();
        this.commonManager = this.createCommonManager();
        if (this.memento != null) {
            this.commonManager.restoreState(this.memento);
        }
    }

    public void dispose() {
        if (this.commonManager != null) {
            this.commonManager.dispose();
        }
        super.dispose();
    }

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        super.init(aSite, aMemento);
        this.memento = aMemento;
        if (this.memento != null) {
            Integer linkingEnabledInteger = this.memento.getInteger(this.LINKING_ENABLED);
            this.setLinkingEnabled(linkingEnabledInteger != null ? linkingEnabledInteger == 1 : false);
        }
    }

    public void saveState(IMemento aMemento) {
        aMemento.putInteger(this.LINKING_ENABLED, this.isLinkingEnabled ? 1 : 0);
        super.saveState(aMemento);
        this.commonManager.saveState(aMemento);
    }

    public void setFocus() {
        if (this.commonViewer != null) {
            this.commonViewer.getTree().setFocus();
        }
    }

    public void selectReveal(ISelection selection) {
        if (this.commonViewer != null) {
            this.commonViewer.setSelection(selection, true);
        }
    }

    public final void setLinkingEnabled(boolean toEnableLinking) {
        this.isLinkingEnabled = toEnableLinking;
        this.firePropertyChange(1);
    }

    public final boolean isLinkingEnabled() {
        return this.isLinkingEnabled;
    }

    public CommonViewer getCommonViewer() {
        return this.commonViewer;
    }

    public NavigatorContentService getNavigatorContentService() {
        return this.getCommonViewer().getNavigatorContentService();
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer aViewer = new CommonViewer(this.getViewSite().getId(), aParent, 770);
        this.initListeners(aViewer);
        return aViewer;
    }

    protected void initListeners(TreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    CommonNavigator.this.handleDoubleClick(event);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
            }
        });
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        IStructuredSelection selection = (IStructuredSelection)anEvent.getSelection();
        Object element = selection.getFirstElement();
        CommonViewer viewer = this.getCommonViewer();
        if (viewer.isExpandable(element)) {
            viewer.setExpandedState(element, !viewer.getExpandedState(element));
        }
    }

    protected CommonNavigatorManager createCommonManager() {
        return new CommonNavigatorManager(this);
    }

    protected ActionGroup createCommonActionGroup() {
        return new CommonNavigatorActionGroup(this, this.commonViewer);
    }

    protected ViewerFilter createCommonFilter(CommonViewer aViewer) {
        return new CommonViewerFilter(aViewer);
    }

    protected ViewerSorter createCommonSorter(CommonViewer aViewer) {
        return new CommonSorter(aViewer.getNavigatorContentService());
    }

    protected DisposeListener createDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommonNavigator.this.dispose();
            }
        };
    }

    protected IAdaptable getInitialInput() {
        return this.getSite().getPage().getInput();
    }

    protected void updateTitle() {
        if (this.commonViewer == null) {
            return;
        }
        Object input = this.commonViewer.getInput();
        String viewName = this.getConfigurationElement().getAttribute("name");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (input == null || input.equals(workspace) || input.equals(workspace.getRoot())) {
            this.setPartName(viewName);
            this.setTitleToolTip("");
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.commonViewer.getLabelProvider();
            String inputToolTip = this.getFrameToolTipText(input);
            this.setPartName(NavigatorMessages.getString(NavigatorMessages.Navigator_title, new Object[]{viewName, labelProvider.getText(input)}));
            this.setTitleToolTip(inputToolTip);
        }
    }

    protected String getFrameToolTipText(Object anElement) {
        if (anElement instanceof IResource) {
            IPath path = ((IResource)anElement).getFullPath();
            if (path.isRoot()) {
                return NavigatorMessages.Navigator_toolTip;
            }
            return path.makeRelative().toString();
        }
        if (this.commonViewer != null) {
            return ((ILabelProvider)this.commonViewer.getLabelProvider()).getText(anElement);
        }
        return "";
    }

    public String getContributorId() {
        return this.getViewSite().getId();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }
}

