/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views;

import org.eclipse.wst.common.navigator.internal.views.Timer;

class TimerQueue
implements Runnable {
    private static TimerQueue singleton;
    Timer firstTimer;
    boolean running;
    private static final Object classLock;

    static {
        classLock = new Object();
    }

    public TimerQueue() {
        this.start();
    }

    synchronized void addTimer(Timer timer, long expirationTime) {
        if (timer.running) {
            return;
        }
        Timer previousTimer = null;
        Timer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            if (nextTimer.expirationTime > expirationTime) break;
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (previousTimer == null) {
            this.firstTimer = timer;
        } else {
            previousTimer.nextTimer = timer;
        }
        timer.expirationTime = expirationTime;
        timer.nextTimer = nextTimer;
        timer.running = true;
        this.notify();
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized long postExpiredTimers() {
        long timeToWait;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            timeToWait = timer.expirationTime - currentTime;
            if (timeToWait <= 0L) {
                try {
                    timer.post();
                }
                catch (SecurityException securityException) {}
                this.removeTimer(timer);
                if (timer.isRepeats()) {
                    this.addTimer(timer, currentTime + (long)timer.getDelay());
                }
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        } while (timeToWait <= 0L);
        return timeToWait;
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer previousTimer = null;
        Timer nextTimer = this.firstTimer;
        boolean found = false;
        while (nextTimer != null) {
            if (nextTimer == timer) {
                found = true;
                break;
            }
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (!found) {
            return;
        }
        if (previousTimer == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            previousTimer.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        try {
            while (true) {
                if (!this.running) {
                    return;
                }
                timeToWait = this.postExpiredTimers();
                try {
                    this.wait(timeToWait);
                }
                catch (InterruptedException v0) {}
            }
        }
        catch (ThreadDeath td) {
            this.running = false;
            timer = this.firstTimer;
            ** while (timer != null)
        }
lbl-1000:
        // 1 sources

        {
            timer.eventQueued = false;
            timer = timer.nextTimer;
            continue;
        }
lbl18:
        // 1 sources

        var5_4 = this;
        synchronized (var5_4) {
            if (this.running != false) throw td;
            this.start();
            throw td;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerQueue singleton() {
        if (singleton == null) {
            Object object = classLock;
            synchronized (object) {
                singleton = new TimerQueue();
            }
        }
        return singleton;
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Ack!");
        }
        Thread timerThread = new Thread((Runnable)this, "TimerQueue");
        try {
            timerThread.setDaemon(true);
        }
        catch (SecurityException securityException) {}
        timerThread.start();
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TimerQueue (");
        Timer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            buf.append(nextTimer.toString());
            nextTimer = nextTimer.nextTimer;
            if (nextTimer == null) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }
}

