/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.workbench;

import java.text.Collator;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;

public class ResourceSorter
implements Comparator {
    public static final int NAME = 1;
    public static final int TYPE = 2;
    private int criteria = 1;
    private Collator collator = Collator.getInstance();

    protected int classComparison(Object element) {
        if (element instanceof IResource) {
            return 2;
        }
        return 0;
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof IResource) || !(o2 instanceof IResource)) {
            return this.compareClass(o1, o2);
        }
        IResource r1 = (IResource)o1;
        IResource r2 = (IResource)o2;
        if (r1 instanceof IContainer && r2 instanceof IContainer) {
            return this.compareNames(r1, r2);
        }
        if (r1 instanceof IContainer) {
            return -1;
        }
        if (r2 instanceof IContainer) {
            return 1;
        }
        if (this.criteria == 1) {
            return this.compareNames(r1, r2);
        }
        if (this.criteria == 2) {
            return this.compareTypes(r1, r2);
        }
        return 0;
    }

    protected int compareClass(Object element1, Object element2) {
        return this.classComparison(element1) - this.classComparison(element2);
    }

    protected int compareNames(IResource resource1, IResource resource2) {
        return this.collator.compare(resource1.getName(), resource2.getName());
    }

    protected int compareTypes(IResource resource1, IResource resource2) {
        String ext2;
        String ext1 = this.getExtensionFor(resource1);
        int result = this.collator.compare(ext1, ext2 = this.getExtensionFor(resource2));
        if (result != 0) {
            return result;
        }
        return this.compareNames(resource1, resource2);
    }

    public int getCriteria() {
        return this.criteria;
    }

    private String getExtensionFor(IResource resource) {
        String ext = resource.getFileExtension();
        return ext == null ? "" : ext;
    }

    public void setCriteria(int criteria) {
        this.criteria = criteria;
    }
}

