/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.CopyOnWriteSet;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class FacetedProject
implements IFacetedProject {
    private static final String TRACING_DELEGATE_CALLS = "org.eclipse.wst.common.project.facet.core/delegate/calls";
    private final IProject project;
    private final CopyOnWriteSet facets;
    private final CopyOnWriteSet fixed;
    private String runtimeName;
    IFile f;
    private long fLastModified = -1L;
    private final List listeners;
    private final Object lock = new Object();
    private boolean isBeingModified = false;
    private Thread modifierThread = null;
    static /* synthetic */ Class class$0;

    FacetedProject(IProject project) throws CoreException {
        this.project = project;
        this.facets = new CopyOnWriteSet();
        this.fixed = new CopyOnWriteSet();
        this.listeners = new ArrayList();
        this.f = project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml");
        this.refresh();
    }

    public IProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getProjectFacets() {
        Object object = this.lock;
        synchronized (object) {
            return this.facets.getReadOnlySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasProjectFacet(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            IProjectFacetVersion fv;
            Iterator itr = this.facets.iterator();
            do {
                if (itr.hasNext()) continue;
                return false;
            } while ((fv = (IProjectFacetVersion)itr.next()).getProjectFacet() != f);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProjectFacet(IProjectFacetVersion fv) {
        Object object = this.lock;
        synchronized (object) {
            return this.facets.contains(fv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProjectFacetVersion getInstalledVersion(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            Iterator itr = this.facets.iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                if (fv.getProjectFacet() != f) continue;
                return fv;
            }
            return null;
        }
    }

    public void installProjectFacet(IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, fv, config);
        this.modify(Collections.singleton(action), monitor);
    }

    public void uninstallProjectFacet(IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, fv, config);
        this.modify(Collections.singleton(action), monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modify(final Set actions, IProgressMonitor monitor) throws CoreException {
        this.beginModification();
        try {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    FacetedProject.this.modifyInternal(actions, monitor);
                }
            };
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.endModification();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.endModification();
            this.notifyListeners();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void modifyInternal(Set actions, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 510->514)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getFixedProjectFacets() {
        Object object = this.lock;
        synchronized (object) {
            return this.fixed.getReadOnlySet();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFixedProjectFacets(final Set facets) throws CoreException {
        this.beginModification();
        try {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws CoreException {
                    Object object = FacetedProject.this.lock;
                    synchronized (object) {
                        FacetedProject.this.fixed.clear();
                        FacetedProject.this.fixed.addAll((Collection)facets);
                    }
                    FacetedProject.this.save();
                }
            };
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endModification();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.endModification();
            this.notifyListeners();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRuntimeName() {
        Object object = this.lock;
        synchronized (object) {
            return this.runtimeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRuntime getRuntime() {
        Object object = this.lock;
        synchronized (object) {
            if (RuntimeManager.isRuntimeDefined(this.runtimeName)) {
                return RuntimeManager.getRuntime(this.runtimeName);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRuntime(final IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        this.beginModification();
        try {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    FacetedProject.this.setRuntimeInternal(runtime, monitor);
                }
            };
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.endModification();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.endModification();
            this.notifyListeners();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void setRuntimeInternal(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 244->248)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IMarker createErrorMarker(String message) throws CoreException {
        return this.createErrorMarker("org.eclipse.wst.common.project.facet.core.validation.marker", message);
    }

    public IMarker createErrorMarker(String type, String message) throws CoreException {
        return this.createMarker(2, type, message);
    }

    public IMarker createWarningMarker(String message) throws CoreException {
        return this.createWarningMarker("org.eclipse.wst.common.project.facet.core.validation.marker", message);
    }

    public IMarker createWarningMarker(String type, String message) throws CoreException {
        return this.createMarker(1, type, message);
    }

    private IMarker createMarker(int severity, String type, String message) throws CoreException {
        IMarker[] existing = this.project.findMarkers(type, false, 0);
        int i = 0;
        while (i < existing.length) {
            IMarker m = existing[i];
            if (m.getAttribute("severity", -1) == severity && m.getAttribute("message", "").equals(message)) {
                return m;
            }
            ++i;
        }
        IMarker m = this.project.createMarker(type);
        m.setAttribute("message", (Object)message);
        m.setAttribute("severity", severity);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IFacetedProjectListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IFacetedProjectListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Object[] copy;
        List list = this.listeners;
        synchronized (list) {
            copy = this.listeners.toArray();
        }
        int i = 0;
        while (i < copy.length) {
            try {
                ((IFacetedProjectListener)copy[i]).projectChanged();
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void beginModification() throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (!this.isBeingModified) {
                    this.isBeingModified = true;
                    this.modifierThread = Thread.currentThread();
                    return;
                }
                if (this.modifierThread == Thread.currentThread()) {
                    String msg = Resources.illegalModificationMsg;
                    IStatus st = FacetCorePlugin.createErrorStatus(msg);
                    throw new CoreException(st);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endModification() {
        Object object = this.lock;
        synchronized (object) {
            this.isBeingModified = false;
            this.modifierThread = null;
            this.lock.notifyAll();
        }
    }

    private static void callDelegate(IProject project, IProjectFacetVersion fv, Object config, IDelegate.Type type, IDelegate delegate, IProgressMonitor monitor) throws CoreException {
        String tracingDelegateCallsStr = Platform.getDebugOption((String)TRACING_DELEGATE_CALLS);
        boolean tracingDelegateCalls = tracingDelegateCallsStr == null ? false : tracingDelegateCallsStr.equals("true");
        long timeStarted = -1L;
        if (tracingDelegateCalls) {
            String msg = Resources.bind(Resources.tracingDelegateStarting, fv.getProjectFacet().getId(), fv.getVersionString(), type.toString(), delegate.getClass().getName());
            System.out.println(msg);
            timeStarted = System.currentTimeMillis();
        }
        try {
            delegate.execute(project, fv, config, monitor);
        }
        catch (Exception e) {
            String msg = type == IDelegate.Type.INSTALL ? NLS.bind((String)Resources.failedOnInstall, (Object)fv) : (type == IDelegate.Type.UNINSTALL ? NLS.bind((String)Resources.failedOnUninstall, (Object)fv) : (type == IDelegate.Type.VERSION_CHANGE ? NLS.bind((String)Resources.failedOnVersionChange, (Object)fv.getProjectFacet().getLabel(), (Object)fv.getVersionString()) : (type == IDelegate.Type.RUNTIME_CHANGED ? NLS.bind((String)Resources.failedOnRuntimeChanged, (Object)fv) : "Unknown delegate type!")));
            Status status = new Status(4, "org.eclipse.wst.common.project.facet.core", 0, msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        if (tracingDelegateCalls) {
            long duration = System.currentTimeMillis() - timeStarted;
            String msg = NLS.bind((String)Resources.tracingDelegateFinished, (Object)String.valueOf(duration));
            System.out.println(msg);
        }
    }

    private void apply(IFacetedProject.Action action) {
        IFacetedProject.Action.Type type = action.getType();
        IProjectFacetVersion fv = action.getProjectFacetVersion();
        if (type == IFacetedProject.Action.Type.INSTALL) {
            this.facets.add(fv);
        } else if (type == IFacetedProject.Action.Type.UNINSTALL) {
            this.facets.remove(fv);
        } else if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
            Iterator itr = this.facets.iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion x = (IProjectFacetVersion)itr.next();
                if (x.getProjectFacet() != fv.getProjectFacet()) continue;
                itr.remove();
                break;
            }
            this.facets.add(fv);
        }
    }

    private void save() throws CoreException {
        byte[] bytes;
        StringWriter w = new StringWriter();
        PrintWriter out = new PrintWriter(w);
        String nl = System.getProperty("line.separator");
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.print(nl);
        out.print("<faceted-project>");
        out.print(nl);
        if (this.runtimeName != null) {
            out.print("  <runtime name=\"");
            out.print(this.runtimeName);
            out.print("\"/>");
            out.print(nl);
        }
        Iterator itr = this.fixed.iterator();
        while (itr.hasNext()) {
            IProjectFacet f = (IProjectFacet)itr.next();
            out.print("  <fixed facet=\"");
            out.print(f.getId());
            out.print("\"/>");
            out.print(nl);
        }
        itr = this.facets.iterator();
        while (itr.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            out.print("  <installed facet=\"");
            out.print(fv.getProjectFacet().getId());
            out.print("\" version=\"");
            out.print(fv.getVersionString());
            out.print("\"/>");
            out.print(nl);
        }
        out.print("</faceted-project>");
        out.print(nl);
        try {
            bytes = w.getBuffer().toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        if (this.f.exists()) {
            this.f.setContents((InputStream)in, true, false, null);
        } else {
            IFolder parent = (IFolder)this.f.getParent();
            if (!parent.exists()) {
                parent.create(true, true, null);
            }
            this.f.create((InputStream)in, true, null);
        }
        this.fLastModified = this.f.getLocation().toFile().lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.f.exists() && this.f.getLocation().toFile().lastModified() == this.fLastModified) {
                return;
            }
            this.facets.clear();
            this.fixed.clear();
            this.runtimeName = null;
            if (!this.f.exists()) {
                this.fLastModified = -1L;
                return;
            }
            this.fLastModified = this.f.getLocation().toFile().lastModified();
            Element root = FacetedProject.parse(this.f.getLocation().toFile());
            Element[] elements = this.children(root);
            int i = 0;
            while (i < elements.length) {
                String id;
                Element e = elements[i];
                String name = e.getNodeName();
                if (name.equals("runtime")) {
                    this.runtimeName = e.getAttribute("name");
                } else if (name.equals("fixed")) {
                    id = e.getAttribute("facet");
                    if (!ProjectFacetsManager.isProjectFacetDefined(id)) {
                        String msg = NLS.bind((String)Resources.facetNotDefined, (Object)id);
                        IStatus st = FacetCorePlugin.createErrorStatus(msg);
                        throw new CoreException(st);
                    }
                    IProjectFacet f = ProjectFacetsManager.getProjectFacet(id);
                    this.fixed.add(f);
                } else if (name.equals("installed")) {
                    id = e.getAttribute("facet");
                    String version = e.getAttribute("version");
                    if (!ProjectFacetsManager.isProjectFacetDefined(id)) {
                        String msg = NLS.bind((String)Resources.facetNotDefined, (Object)id);
                        IStatus st = FacetCorePlugin.createErrorStatus(msg);
                        throw new CoreException(st);
                    }
                    IProjectFacet f = ProjectFacetsManager.getProjectFacet(id);
                    if (!f.hasVersion(version)) {
                        String msg = NLS.bind((String)Resources.facetVersionNotDefined, (Object)id, (Object)version);
                        IStatus st = FacetCorePlugin.createErrorStatus(msg);
                        throw new CoreException(st);
                    }
                    IProjectFacetVersion fv = f.getVersion(version);
                    this.facets.add(fv);
                }
                ++i;
            }
        }
    }

    private static Element parse(File f) {
        DocumentBuilder docbuilder;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            docbuilder = factory.newDocumentBuilder();
            docbuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            return docbuilder.parse(f).getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Element[] children(Element element) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nl = element.getChildNodes();
        int i = 0;
        int n = nl.getLength();
        while (i < n) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                list.add(node);
            }
            ++i;
        }
        return list.toArray(new Element[list.size()]);
    }

    private static final class Resources
    extends NLS {
        public static String failedOnInstall;
        public static String failedOnUninstall;
        public static String failedOnVersionChange;
        public static String failedOnRuntimeChanged;
        public static String facetNotDefined;
        public static String facetVersionNotDefined;
        public static String facetNotSupported;
        public static String illegalModificationMsg;
        public static String tracingDelegateStarting;
        public static String tracingDelegateFinished;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.FacetedProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.FacetedProject$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }

        public static final String bind(String msg, String arg1, String arg2, String arg3, String arg4) {
            return NLS.bind((String)msg, (Object[])new Object[]{arg1, arg2, arg3, arg4});
        }
    }
}

