/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.internal.ConflictingFacetsFilter;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeManagerImpl;

public abstract class AbstractRuntime
implements IRuntime {
    private String name;

    AbstractRuntime() {
    }

    public final String getName() {
        return this.name;
    }

    final void setName(String name) {
        this.name = name;
    }

    public final String getProperty(String key) {
        return (String)this.getProperties().get(key);
    }

    public final Object getAdapter(Class adapter) {
        String t = adapter.getName();
        Object res = Platform.getAdapterManager().loadAdapter((Object)this, t);
        if (res == null) {
            Iterator itr = this.getRuntimeComponents().iterator();
            while (itr.hasNext()) {
                res = ((IRuntimeComponent)itr.next()).getAdapter(adapter);
                if (res == null) continue;
                return res;
            }
        }
        return res;
    }

    public boolean supports(IProjectFacet f) {
        Iterator itr = f.getVersions().iterator();
        while (itr.hasNext()) {
            if (!this.supports((IProjectFacetVersion)itr.next())) continue;
            return true;
        }
        return false;
    }

    public Set getDefaultFacets(Set fixed) throws CoreException {
        HashMap<IProjectFacet, IProjectFacetVersion> facets = new HashMap<IProjectFacet, IProjectFacetVersion>();
        Iterator itr1 = this.getRuntimeComponents().iterator();
        while (itr1.hasNext()) {
            IRuntimeComponent rc = (IRuntimeComponent)itr1.next();
            IRuntimeComponentVersion rcv = rc.getRuntimeComponentVersion();
            Iterator itr2 = RuntimeManagerImpl.getDefaultFacets(rcv).iterator();
            while (itr2.hasNext()) {
                IProjectFacetVersion fv = (IProjectFacetVersion)itr2.next();
                if (facets.containsKey(fv.getProjectFacet())) continue;
                facets.put(fv.getProjectFacet(), fv);
            }
        }
        ConflictingFacetsFilter filter = new ConflictingFacetsFilter(fixed);
        Iterator itr = facets.values().iterator();
        while (itr.hasNext()) {
            if (filter.check((IProjectFacetVersion)itr.next())) continue;
            itr.remove();
        }
        HashMap<IProjectFacet, IProjectFacetVersion> toadd = null;
        Iterator itr2 = fixed.iterator();
        while (itr2.hasNext()) {
            IProjectFacet f = (IProjectFacet)itr2.next();
            if (facets.containsKey(f)) continue;
            if (toadd == null) {
                toadd = new HashMap<IProjectFacet, IProjectFacetVersion>();
            }
            toadd.put(f, f.getLatestSupportedVersion(this));
        }
        if (toadd != null) {
            facets.putAll(toadd);
        }
        return new HashSet(facets.values());
    }

    public final boolean equals(Object obj) {
        if (obj instanceof IRuntime) {
            IRuntime r = (IRuntime)obj;
            return this.getName().equals(r.getName()) && this.getRuntimeComponents().equals(r.getRuntimeComponents()) && this.getProperties().equals(r.getProperties());
        }
        return false;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

